/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.render.component.anim;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.text.TextUtils;
import com.didi.hummer.annotation.Component;
import com.didi.hummer.annotation.JsMethod;
import com.didi.hummer.annotation.JsProperty;
import com.didi.hummer.core.engine.JSCallback;
import com.didi.hummer.render.component.anim.HummerAnimationUtils;
import com.didi.hummer.render.component.view.HMBase;
import java.util.List;

@Component(value="BasicAnimation")
public class BasicAnimation {
    @JsProperty(value="from")
    protected Object from;
    @JsProperty(value="value")
    protected Object value;
    @JsProperty(value="duration")
    protected float duration;
    @JsProperty(value="delay")
    protected float delay;
    @JsProperty(value="easing")
    protected String easing;
    @JsProperty(value="repeatCount")
    protected int repeatCount;
    @JsProperty(value="repeatMode")
    protected String repeatMode;
    protected Animator animator;
    protected String animType;
    protected JSCallback animStartCallback;
    protected JSCallback animEndCallback;
    public static final int AXIS_X = 1;
    public static final int AXIS_Y = 2;
    public static final int AXIS_Z = 3;
    public static final int DIRECTION_X = 11;
    public static final int DIRECTION_Y = 12;
    public static final int DIRECTION_XY = 13;
    protected AnimatorListenerAdapter animatorListener = new AnimatorListenerAdapter(){

        public void onAnimationStart(Animator animation) {
            super.onAnimationStart(animation);
            if (BasicAnimation.this.animStartCallback != null) {
                BasicAnimation.this.animStartCallback.call(new Object[0]);
            }
        }

        public void onAnimationEnd(Animator animation) {
            super.onAnimationEnd(animation);
            if (BasicAnimation.this.animEndCallback != null) {
                BasicAnimation.this.animEndCallback.call(new Object[0]);
            }
        }
    };

    public BasicAnimation(String animType) {
        this.animType = animType;
    }

    protected static Object[] trans2Array(Object value) {
        return HummerAnimationUtils.trans2Array(value);
    }

    @JsMethod(value="on")
    public void on(String event, JSCallback callback) {
        if ("start".equalsIgnoreCase(event)) {
            this.animStartCallback = callback;
        } else if ("end".equalsIgnoreCase(event)) {
            this.animEndCallback = callback;
        }
    }

    public void start(HMBase base) {
        List<PropertyValuesHolder> list = HummerAnimationUtils.parser(this.animType, this.value, this.from);
        ObjectAnimator anim = ObjectAnimator.ofPropertyValuesHolder((Object)base.getAnimViewWrapper(), (PropertyValuesHolder[])list.toArray(new PropertyValuesHolder[0]));
        this.animator = anim;
        anim.setDuration(HummerAnimationUtils.getAnimDuration(this.duration));
        anim.setRepeatCount(this.toRawRepeatCount(this.repeatCount));
        anim.setRepeatMode(this.toRawRepeatMode(this.repeatMode));
        anim.setStartDelay((long)HummerAnimationUtils.getAnimDelay(this.delay));
        anim.setInterpolator(HummerAnimationUtils.getInterpolator(this.easing));
        anim.addListener((Animator.AnimatorListener)this.animatorListener);
        anim.start();
    }

    public void stop() {
        if (this.isRunning()) {
            this.animator.cancel();
            this.animator = null;
        }
        if (this.animStartCallback != null) {
            this.animStartCallback.release();
        }
        if (this.animEndCallback != null) {
            this.animEndCallback.release();
        }
    }

    public boolean isRunning() {
        return this.animator != null && this.animator.isRunning();
    }

    protected int toRawRepeatCount(int repeatCount) {
        int rawRepeatCount = 0;
        if (repeatCount < 0) {
            rawRepeatCount = -1;
        } else if (repeatCount > 1) {
            rawRepeatCount = repeatCount - 1;
        }
        return rawRepeatCount;
    }

    protected int toRawRepeatMode(String repeatMode) {
        int rawRepeatMode = 1;
        if (!TextUtils.isEmpty((CharSequence)repeatMode)) {
            if ((repeatMode = repeatMode.toLowerCase()).equals("normal")) {
                rawRepeatMode = 1;
            } else if (repeatMode.equals("reverse")) {
                rawRepeatMode = 2;
            }
        }
        return rawRepeatMode;
    }
}

