/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.render.component.anim;

import android.animation.ArgbEvaluator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import com.didi.hummer.render.style.HummerStyleUtils;
import com.didi.hummer.render.utility.YogaAttrUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HummerAnimationUtils {
    public static final int AXIS_X = 1;
    public static final int AXIS_Y = 2;
    public static final int AXIS_Z = 3;
    public static final int DIRECTION_X = 11;
    public static final int DIRECTION_Y = 12;
    public static final int DIRECTION_XY = 13;

    public static long getAnimDuration(float duration) {
        return (long)(duration * 1000.0f);
    }

    public static int getAnimDelay(float delay) {
        return (int)(delay * 1000.0f);
    }

    public static TimeInterpolator getInterpolator(String easing) {
        if ("linear".equalsIgnoreCase(easing)) {
            return new LinearInterpolator();
        }
        if ("ease-in".equalsIgnoreCase(easing)) {
            return new AccelerateInterpolator();
        }
        if ("ease-out".equalsIgnoreCase(easing)) {
            return new DecelerateInterpolator();
        }
        if ("ease-in-out".equalsIgnoreCase(easing)) {
            return new AccelerateDecelerateInterpolator();
        }
        return new AccelerateDecelerateInterpolator();
    }

    public static List<PropertyValuesHolder> parser(String animType, Object value) {
        return HummerAnimationUtils.parser(animType, value, null);
    }

    public static List<PropertyValuesHolder> parser(String animType, Object value, Object from) {
        if ("position".equalsIgnoreCase(animType) || "translate".equalsIgnoreCase(animType)) {
            return HummerAnimationUtils.animTranslation(value, from);
        }
        if ("opacity".equalsIgnoreCase(animType)) {
            return HummerAnimationUtils.animAlpha(value, from);
        }
        if ("scale".equalsIgnoreCase(animType)) {
            return HummerAnimationUtils.animScale(value, from, 13);
        }
        if ("scaleX".equalsIgnoreCase(animType)) {
            return HummerAnimationUtils.animScale(value, from, 11);
        }
        if ("scaleY".equalsIgnoreCase(animType)) {
            return HummerAnimationUtils.animScale(value, from, 12);
        }
        if ("rotateX".equalsIgnoreCase(animType) || "rotationX".equalsIgnoreCase(animType)) {
            return HummerAnimationUtils.animRotation(value, from, 1);
        }
        if ("rotateY".equalsIgnoreCase(animType) || "rotationY".equalsIgnoreCase(animType)) {
            return HummerAnimationUtils.animRotation(value, from, 2);
        }
        if ("rotate".equalsIgnoreCase(animType) || "rotateZ".equalsIgnoreCase(animType) || "rotation".equalsIgnoreCase(animType) || "rotationZ".equalsIgnoreCase(animType)) {
            return HummerAnimationUtils.animRotation(value, from, 3);
        }
        if ("backgroundColor".equalsIgnoreCase(animType)) {
            return HummerAnimationUtils.animBackgroundColor(value, from);
        }
        if ("width".equalsIgnoreCase(animType)) {
            return HummerAnimationUtils.animWidth(value, from);
        }
        if ("height".equalsIgnoreCase(animType)) {
            return HummerAnimationUtils.animHeight(value, from);
        }
        if ("skew".equalsIgnoreCase(animType)) {
            return HummerAnimationUtils.animSkew(value, from);
        }
        return new ArrayList<PropertyValuesHolder>();
    }

    protected static Object[] trans2Array(Object value) {
        Object[] array = null;
        if (value instanceof Map) {
            Map map = (Map)value;
            array = new Object[2];
            Object objX = map.get("x");
            Object objY = map.get("y");
            array[0] = objX;
            array[1] = objY;
        }
        return array;
    }

    private static List<PropertyValuesHolder> animTranslation(Object value, Object from) {
        float[] vs = null;
        Object[] valueArray = HummerAnimationUtils.trans2Array(value);
        if (valueArray != null && valueArray.length == 2) {
            vs = new float[]{HummerStyleUtils.convertNumber(valueArray[0]), HummerStyleUtils.convertNumber(valueArray[1])};
        }
        if (vs == null) {
            return new ArrayList<PropertyValuesHolder>();
        }
        float[] fs = null;
        Object[] fromArray = HummerAnimationUtils.trans2Array(from);
        if (fromArray != null && fromArray.length == 2) {
            fs = new float[]{HummerStyleUtils.convertNumber(fromArray[0]), HummerStyleUtils.convertNumber(fromArray[1])};
        }
        ArrayList<PropertyValuesHolder> list = new ArrayList<PropertyValuesHolder>();
        if (fs != null) {
            PropertyValuesHolder holderX = PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{fs[0], vs[0]});
            PropertyValuesHolder holderY = PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{fs[1], vs[1]});
            list.add(holderX);
            list.add(holderY);
        } else {
            PropertyValuesHolder holderX = PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{vs[0]});
            PropertyValuesHolder holderY = PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{vs[1]});
            list.add(holderX);
            list.add(holderY);
        }
        return list;
    }

    private static List<PropertyValuesHolder> animAlpha(Object value, Object from) {
        PropertyValuesHolder holder;
        ArrayList<PropertyValuesHolder> list = new ArrayList<PropertyValuesHolder>();
        if (value == null) {
            return list;
        }
        float v = HummerStyleUtils.convertNumber(value, false);
        if (from != null) {
            float f = HummerStyleUtils.convertNumber(from, false);
            holder = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{f, v});
        } else {
            holder = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{v});
        }
        list.add(holder);
        return list;
    }

    private static List<PropertyValuesHolder> animScale(Object value, Object from, int direction) {
        ArrayList<PropertyValuesHolder> list = new ArrayList<PropertyValuesHolder>();
        if (value == null) {
            return list;
        }
        float[] vs = null;
        Object[] valueArray = HummerAnimationUtils.trans2Array(value);
        if (valueArray != null && valueArray.length == 2 && direction == 13) {
            vs = new float[]{HummerStyleUtils.convertNumber(valueArray[0], false), HummerStyleUtils.convertNumber(valueArray[1], false)};
            list.add(PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{vs[0]}));
            list.add(PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{vs[1]}));
            return list;
        }
        float f = HummerStyleUtils.convertNumber(from, false);
        float v = HummerStyleUtils.convertNumber(value, false);
        switch (direction) {
            case 11: {
                if (from != null) {
                    list.add(PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{f, v}));
                    break;
                }
                list.add(PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{v}));
                break;
            }
            case 12: {
                if (from != null) {
                    list.add(PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{f, v}));
                    break;
                }
                list.add(PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{v}));
                break;
            }
            default: {
                if (from != null) {
                    list.add(PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{f, v}));
                    list.add(PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{f, v}));
                    break;
                }
                list.add(PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{v}));
                list.add(PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{v}));
            }
        }
        return list;
    }

    private static List<PropertyValuesHolder> animRotation(Object value, Object from, int axis) {
        String animName;
        ArrayList<PropertyValuesHolder> list = new ArrayList<PropertyValuesHolder>();
        if (value == null) {
            return list;
        }
        switch (axis) {
            case 1: {
                animName = "rotationX";
                break;
            }
            case 2: {
                animName = "rotationY";
                break;
            }
            default: {
                animName = "rotation";
            }
        }
        float f = HummerStyleUtils.convertNumber(from, false);
        float v = HummerStyleUtils.convertNumber(value, false);
        if (from != null) {
            list.add(PropertyValuesHolder.ofFloat((String)animName, (float[])new float[]{f, v}));
        } else {
            list.add(PropertyValuesHolder.ofFloat((String)animName, (float[])new float[]{v}));
        }
        return list;
    }

    private static List<PropertyValuesHolder> animBackgroundColor(Object value, Object from) {
        ArrayList<PropertyValuesHolder> list = new ArrayList<PropertyValuesHolder>();
        if (value == null) {
            return list;
        }
        int f = YogaAttrUtils.parseColor(String.valueOf(from));
        int v = YogaAttrUtils.parseColor(String.valueOf(value));
        if (from != null) {
            list.add(PropertyValuesHolder.ofObject((String)"backgroundColor", (TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{f, v}));
        } else {
            list.add(PropertyValuesHolder.ofObject((String)"backgroundColor", (TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{v}));
        }
        return list;
    }

    protected static List<PropertyValuesHolder> animWidth(Object value, Object from) {
        ArrayList<PropertyValuesHolder> list = new ArrayList<PropertyValuesHolder>();
        if (value == null) {
            return list;
        }
        int v = (int)HummerStyleUtils.convertNumber(value);
        if (from == null) {
            PropertyValuesHolder holderWidth = PropertyValuesHolder.ofInt((String)"width", (int[])new int[]{v});
            list.add(holderWidth);
        } else {
            int f = (int)HummerStyleUtils.convertNumber(from);
            if (f == v) {
                return list;
            }
            PropertyValuesHolder holderWidth = PropertyValuesHolder.ofInt((String)"width", (int[])new int[]{f, v});
            list.add(holderWidth);
        }
        return list;
    }

    protected static List<PropertyValuesHolder> animHeight(Object value, Object from) {
        ArrayList<PropertyValuesHolder> list = new ArrayList<PropertyValuesHolder>();
        if (value == null) {
            return list;
        }
        int v = (int)HummerStyleUtils.convertNumber(value);
        if (from == null) {
            PropertyValuesHolder holderWidth = PropertyValuesHolder.ofInt((String)"height", (int[])new int[]{v});
            list.add(holderWidth);
        } else {
            int f = (int)HummerStyleUtils.convertNumber(from);
            if (f == v) {
                return list;
            }
            PropertyValuesHolder holderWidth = PropertyValuesHolder.ofInt((String)"height", (int[])new int[]{f, v});
            list.add(holderWidth);
        }
        return list;
    }

    protected static List<PropertyValuesHolder> animSkew(Object value, Object from) {
        ArrayList<PropertyValuesHolder> list = new ArrayList<PropertyValuesHolder>();
        if (value == null) {
            return list;
        }
        float[] vs = null;
        Object[] valueArray = HummerAnimationUtils.trans2Array(value);
        if (valueArray != null && valueArray.length == 2) {
            vs = new float[]{HummerStyleUtils.convertNumber(valueArray[0], false), HummerStyleUtils.convertNumber(valueArray[1], false)};
        }
        PropertyValuesHolder holderY = PropertyValuesHolder.ofFloat((String)"skewY", (float[])new float[]{(float)Math.tan(Math.toRadians(vs[1]))});
        PropertyValuesHolder holderX = PropertyValuesHolder.ofFloat((String)"skewX", (float[])new float[]{(float)Math.tan(Math.toRadians(vs[0]))});
        list.add(holderX);
        list.add(holderY);
        return list;
    }
}

