/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.render.component.anim;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.Keyframe;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TypeEvaluator;
import android.view.View;
import com.didi.hummer.annotation.Component;
import com.didi.hummer.annotation.JsProperty;
import com.didi.hummer.render.component.anim.AnimViewWrapper;
import com.didi.hummer.render.component.anim.BasicAnimation;
import com.didi.hummer.render.component.anim.HummerAnimationUtils;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.style.HummerStyleUtils;
import com.didi.hummer.render.utility.YogaAttrUtils;
import java.io.Serializable;
import java.util.List;

@Component(value="KeyframeAnimation")
public class KeyframeAnimation
extends BasicAnimation {
    @JsProperty(value="keyframes")
    private List<KeyFrame> keyframes;

    public KeyframeAnimation(String animType) {
        super(animType);
    }

    public void setKeyframes(List<KeyFrame> keyframes) {
        this.keyframes = keyframes;
    }

    @Override
    public void start(HMBase base) {
        Object view = base.getView();
        if ("position".equalsIgnoreCase(this.animType)) {
            this.animTranslation((View)view);
        } else if ("opacity".equalsIgnoreCase(this.animType)) {
            this.animAlpha((View)view);
        } else if ("scale".equalsIgnoreCase(this.animType)) {
            this.animScale((View)view, 13);
        } else if ("scaleX".equalsIgnoreCase(this.animType)) {
            this.animScale((View)view, 11);
        } else if ("scaleY".equalsIgnoreCase(this.animType)) {
            this.animScale((View)view, 12);
        } else if ("rotationX".equalsIgnoreCase(this.animType)) {
            this.animRotation((View)view, 1);
        } else if ("rotationY".equalsIgnoreCase(this.animType)) {
            this.animRotation((View)view, 2);
        } else if ("rotationZ".equalsIgnoreCase(this.animType)) {
            this.animRotation((View)view, 3);
        } else if ("backgroundColor".equalsIgnoreCase(this.animType)) {
            this.animBackgroundColor(base);
        } else if ("width".equalsIgnoreCase(this.animType)) {
            this.animWidth(base);
        } else if ("height".equalsIgnoreCase(this.animType)) {
            this.animHeight(base);
        } else if ("skew".equalsIgnoreCase(this.animType)) {
            this.animSkew(base);
        }
    }

    protected void animTranslation(View view) {
        if (this.keyframes == null) {
            return;
        }
        Keyframe[] frameXArray = new Keyframe[this.keyframes.size()];
        Keyframe[] frameYArray = new Keyframe[this.keyframes.size()];
        for (int i = 0; i < this.keyframes.size(); ++i) {
            KeyFrame kf = this.keyframes.get(i);
            Object[] array = KeyframeAnimation.trans2Array(kf.value);
            Keyframe frameX = Keyframe.ofFloat((float)kf.percent, (float)HummerStyleUtils.convertNumber(array[0]));
            Keyframe frameY = Keyframe.ofFloat((float)kf.percent, (float)HummerStyleUtils.convertNumber(array[1]));
            frameXArray[i] = frameX;
            frameYArray[i] = frameY;
        }
        PropertyValuesHolder frameXHolder = PropertyValuesHolder.ofKeyframe((String)"translationX", (Keyframe[])frameXArray);
        PropertyValuesHolder frameYHolder = PropertyValuesHolder.ofKeyframe((String)"translationY", (Keyframe[])frameYArray);
        ObjectAnimator anim = ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{frameXHolder, frameYHolder});
        this.animator = anim;
        anim.setDuration(HummerAnimationUtils.getAnimDuration(this.duration));
        anim.setRepeatCount(this.toRawRepeatCount(this.repeatCount));
        anim.setRepeatMode(this.toRawRepeatMode(this.repeatMode));
        anim.setStartDelay((long)HummerAnimationUtils.getAnimDelay(this.delay));
        anim.setInterpolator(HummerAnimationUtils.getInterpolator(this.easing));
        anim.addListener((Animator.AnimatorListener)this.animatorListener);
        anim.start();
    }

    protected void animScale(View view, int direction) {
        ObjectAnimator anim;
        if (this.keyframes == null) {
            return;
        }
        Keyframe[] frameArray = new Keyframe[this.keyframes.size()];
        for (int i = 0; i < this.keyframes.size(); ++i) {
            Keyframe frame;
            KeyFrame kf = this.keyframes.get(i);
            frameArray[i] = frame = Keyframe.ofFloat((float)kf.percent, (float)HummerStyleUtils.convertNumber(kf.value, false));
        }
        switch (direction) {
            case 11: {
                PropertyValuesHolder holderX = PropertyValuesHolder.ofKeyframe((String)"scaleX", (Keyframe[])frameArray);
                anim = ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{holderX});
                break;
            }
            case 12: {
                PropertyValuesHolder holderY = PropertyValuesHolder.ofKeyframe((String)"scaleY", (Keyframe[])frameArray);
                anim = ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{holderY});
                break;
            }
            default: {
                PropertyValuesHolder holderX = PropertyValuesHolder.ofKeyframe((String)"scaleX", (Keyframe[])frameArray);
                PropertyValuesHolder holderY = PropertyValuesHolder.ofKeyframe((String)"scaleY", (Keyframe[])frameArray);
                anim = ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{holderX, holderY});
                break;
            }
        }
        this.animator = anim;
        anim.setDuration(HummerAnimationUtils.getAnimDuration(this.duration));
        anim.setRepeatCount(this.toRawRepeatCount(this.repeatCount));
        anim.setRepeatMode(this.toRawRepeatMode(this.repeatMode));
        anim.setStartDelay((long)HummerAnimationUtils.getAnimDelay(this.delay));
        anim.setInterpolator(HummerAnimationUtils.getInterpolator(this.easing));
        anim.addListener((Animator.AnimatorListener)this.animatorListener);
        anim.start();
    }

    protected void animRotation(View view, int axis) {
        String animName;
        if (this.keyframes == null) {
            return;
        }
        switch (axis) {
            case 1: {
                animName = "rotationX";
                break;
            }
            case 2: {
                animName = "rotationY";
                break;
            }
            default: {
                animName = "rotation";
            }
        }
        Keyframe[] frameArray = new Keyframe[this.keyframes.size()];
        for (int i = 0; i < this.keyframes.size(); ++i) {
            Keyframe frame;
            KeyFrame kf = this.keyframes.get(i);
            frameArray[i] = frame = Keyframe.ofFloat((float)kf.percent, (float)HummerStyleUtils.convertNumber(kf.value, false));
        }
        PropertyValuesHolder frameHolder = PropertyValuesHolder.ofKeyframe((String)animName, (Keyframe[])frameArray);
        ObjectAnimator anim = ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{frameHolder});
        this.animator = anim;
        anim.setDuration(HummerAnimationUtils.getAnimDuration(this.duration));
        anim.setRepeatCount(this.toRawRepeatCount(this.repeatCount));
        anim.setRepeatMode(this.toRawRepeatMode(this.repeatMode));
        anim.setStartDelay((long)HummerAnimationUtils.getAnimDelay(this.delay));
        anim.setInterpolator(HummerAnimationUtils.getInterpolator(this.easing));
        anim.addListener((Animator.AnimatorListener)this.animatorListener);
        anim.addListener((Animator.AnimatorListener)this.animatorListener);
        anim.start();
    }

    protected void animAlpha(View view) {
        if (this.keyframes == null) {
            return;
        }
        Keyframe[] frameArray = new Keyframe[this.keyframes.size()];
        for (int i = 0; i < this.keyframes.size(); ++i) {
            Keyframe frame;
            KeyFrame kf = this.keyframes.get(i);
            frameArray[i] = frame = Keyframe.ofFloat((float)kf.percent, (float)HummerStyleUtils.convertNumber(kf.value, false));
        }
        PropertyValuesHolder frameHolder = PropertyValuesHolder.ofKeyframe((String)"alpha", (Keyframe[])frameArray);
        ObjectAnimator anim = ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{frameHolder});
        this.animator = anim;
        anim.setDuration(HummerAnimationUtils.getAnimDuration(this.duration));
        anim.setRepeatCount(this.toRawRepeatCount(this.repeatCount));
        anim.setRepeatMode(this.toRawRepeatMode(this.repeatMode));
        anim.setStartDelay((long)HummerAnimationUtils.getAnimDelay(this.delay));
        anim.setInterpolator(HummerAnimationUtils.getInterpolator(this.easing));
        anim.addListener((Animator.AnimatorListener)this.animatorListener);
        anim.start();
    }

    protected void animBackgroundColor(HMBase base) {
        if (this.keyframes == null) {
            return;
        }
        Keyframe[] frameArray = new Keyframe[this.keyframes.size()];
        for (int i = 0; i < this.keyframes.size(); ++i) {
            Keyframe frame;
            KeyFrame kf = this.keyframes.get(i);
            frameArray[i] = frame = Keyframe.ofInt((float)kf.percent, (int)YogaAttrUtils.parseColor(String.valueOf(kf.value)));
        }
        PropertyValuesHolder frameHolder = PropertyValuesHolder.ofKeyframe((String)"backgroundColor", (Keyframe[])frameArray);
        ObjectAnimator anim = ObjectAnimator.ofPropertyValuesHolder((Object)base.getBackgroundHelper(), (PropertyValuesHolder[])new PropertyValuesHolder[]{frameHolder});
        this.animator = anim;
        anim.setEvaluator((TypeEvaluator)new ArgbEvaluator());
        anim.setDuration(HummerAnimationUtils.getAnimDuration(this.duration));
        anim.setRepeatCount(this.toRawRepeatCount(this.repeatCount));
        anim.setRepeatMode(this.toRawRepeatMode(this.repeatMode));
        anim.setStartDelay((long)HummerAnimationUtils.getAnimDelay(this.delay));
        anim.setInterpolator(HummerAnimationUtils.getInterpolator(this.easing));
        anim.addListener((Animator.AnimatorListener)this.animatorListener);
        anim.start();
    }

    protected void animWidth(HMBase base) {
        if (this.keyframes == null) {
            return;
        }
        Keyframe[] frameArray = new Keyframe[this.keyframes.size()];
        for (int i = 0; i < this.keyframes.size(); ++i) {
            Keyframe frame;
            KeyFrame kf = this.keyframes.get(i);
            frameArray[i] = frame = Keyframe.ofInt((float)kf.percent, (int)((int)HummerStyleUtils.convertNumber(kf.value)));
        }
        PropertyValuesHolder frameHolder = PropertyValuesHolder.ofKeyframe((String)"width", (Keyframe[])frameArray);
        ObjectAnimator anim = ObjectAnimator.ofPropertyValuesHolder((Object)new AnimViewWrapper(base), (PropertyValuesHolder[])new PropertyValuesHolder[]{frameHolder});
        this.animator = anim;
        anim.setDuration(HummerAnimationUtils.getAnimDuration(this.duration));
        anim.setRepeatCount(this.toRawRepeatCount(this.repeatCount));
        anim.setRepeatMode(this.toRawRepeatMode(this.repeatMode));
        anim.setStartDelay((long)HummerAnimationUtils.getAnimDelay(this.delay));
        anim.setInterpolator(HummerAnimationUtils.getInterpolator(this.easing));
        anim.addListener((Animator.AnimatorListener)this.animatorListener);
        anim.start();
    }

    protected void animHeight(HMBase base) {
        if (this.keyframes == null) {
            return;
        }
        Keyframe[] frameArray = new Keyframe[this.keyframes.size()];
        for (int i = 0; i < this.keyframes.size(); ++i) {
            Keyframe frame;
            KeyFrame kf = this.keyframes.get(i);
            frameArray[i] = frame = Keyframe.ofInt((float)kf.percent, (int)((int)HummerStyleUtils.convertNumber(kf.value)));
        }
        PropertyValuesHolder frameHolder = PropertyValuesHolder.ofKeyframe((String)"height", (Keyframe[])frameArray);
        ObjectAnimator anim = ObjectAnimator.ofPropertyValuesHolder((Object)new AnimViewWrapper(base), (PropertyValuesHolder[])new PropertyValuesHolder[]{frameHolder});
        this.animator = anim;
        anim.setDuration(HummerAnimationUtils.getAnimDuration(this.duration));
        anim.setRepeatCount(this.toRawRepeatCount(this.repeatCount));
        anim.setRepeatMode(this.toRawRepeatMode(this.repeatMode));
        anim.setStartDelay((long)HummerAnimationUtils.getAnimDelay(this.delay));
        anim.setInterpolator(HummerAnimationUtils.getInterpolator(this.easing));
        anim.addListener((Animator.AnimatorListener)this.animatorListener);
        anim.start();
    }

    protected void animSkew(HMBase base) {
        if (this.keyframes == null) {
            return;
        }
        Keyframe[] frameXArray = new Keyframe[this.keyframes.size()];
        Keyframe[] frameYArray = new Keyframe[this.keyframes.size()];
        for (int i = 0; i < this.keyframes.size(); ++i) {
            KeyFrame kf = this.keyframes.get(i);
            Object[] array = KeyframeAnimation.trans2Array(kf.value);
            Keyframe frameX = Keyframe.ofFloat((float)kf.percent, (float)((float)Math.tan(Math.toRadians(HummerStyleUtils.convertNumber(array[0], false)))));
            Keyframe frameY = Keyframe.ofFloat((float)kf.percent, (float)((float)Math.tan(Math.toRadians(HummerStyleUtils.convertNumber(array[1], false)))));
            frameXArray[i] = frameX;
            frameYArray[i] = frameY;
        }
        PropertyValuesHolder holderX = PropertyValuesHolder.ofKeyframe((String)"skewX", (Keyframe[])frameXArray);
        PropertyValuesHolder holderY = PropertyValuesHolder.ofKeyframe((String)"skewY", (Keyframe[])frameYArray);
        ObjectAnimator anim = ObjectAnimator.ofPropertyValuesHolder((Object)new AnimViewWrapper(base), (PropertyValuesHolder[])new PropertyValuesHolder[]{holderX, holderY});
        this.animator = anim;
        anim.setDuration(HummerAnimationUtils.getAnimDuration(this.duration));
        anim.setRepeatCount(this.toRawRepeatCount(this.repeatCount));
        anim.setRepeatMode(this.toRawRepeatMode(this.repeatMode));
        anim.setStartDelay((long)HummerAnimationUtils.getAnimDelay(this.delay));
        anim.setInterpolator(HummerAnimationUtils.getInterpolator(this.easing));
        anim.addListener((Animator.AnimatorListener)this.animatorListener);
        anim.start();
    }

    public class KeyFrame
    implements Serializable {
        public float percent;
        public Object value;
    }
}

