/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.render.component.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.didi.hummer.render.utility.RTLUtil;
import java.util.Arrays;

public class BackgroundDrawable
extends Drawable {
    private boolean needRTL = false;
    private Drawable drawable;
    private GradientDrawable gradientDrawable;
    private int color = 0;
    private Border border = new Border();
    private Shadow shadow;
    private Rect shadowOuterBounds = new Rect();
    private RectF shadowInnerBounds = new RectF();
    private final Paint mBgPaint = new Paint(1);
    private final Paint mBorderPaint = new Paint(1);
    private final Paint mShadowPaint = new Paint(1);
    private final Path mOuterBoundsPath = new Path();
    private final Path mInnerBoundsPath = new Path();
    private final Path mWholeBorderPath = new Path();
    private final Path mEachBorderPath = new Path();
    private final RectF mOuterBoundsRect = new RectF();
    private final RectF mInnerBoundsRect = new RectF();
    private final RectF mStrokeBoundsRect = new RectF();
    private final RectF extendInnerRect = new RectF();
    private final float[] mOuterRadii = new float[8];
    private final float[] mInnerRadii = new float[8];
    private final float[] mStrokeRadii = new float[8];

    public BackgroundDrawable() {
    }

    public BackgroundDrawable(boolean needRTL) {
        this.needRTL = needRTL;
    }

    public void draw(@NonNull Canvas canvas) {
        if (!this.border.hasBorder()) {
            this.drawShadowIfNeed(canvas);
            this.drawBackground(canvas);
        } else {
            this.initBorderData();
            this.drawShadowIfNeed(canvas);
            this.drawBackgroundWithBorder(canvas);
        }
    }

    private void initBorderData() {
        this.fixedBorderWidth();
        RectF width = this.border.width;
        BorderRadius radius = this.border.radius;
        radius.fillWithPercent(this.getBounds());
        if (this.needRTL) {
            this.border.toRTL();
        }
        this.mOuterBoundsRect.set(this.getBounds());
        this.mInnerBoundsRect.set(this.getBounds());
        this.mInnerBoundsRect.left += width.left;
        this.mInnerBoundsRect.top += width.top;
        this.mInnerBoundsRect.right -= width.right;
        this.mInnerBoundsRect.bottom -= width.bottom;
        this.mStrokeBoundsRect.set(this.getBounds());
        this.mStrokeBoundsRect.left += width.left / 2.0f;
        this.mStrokeBoundsRect.top += width.top / 2.0f;
        this.mStrokeBoundsRect.right -= width.right / 2.0f;
        this.mStrokeBoundsRect.bottom -= width.bottom / 2.0f;
        this.mOuterRadii[0] = radius.topLeftX;
        this.mOuterRadii[1] = radius.topLeftY;
        this.mOuterRadii[2] = radius.topRightX;
        this.mOuterRadii[3] = radius.topRightY;
        this.mOuterRadii[4] = radius.bottomRightX;
        this.mOuterRadii[5] = radius.bottomRightY;
        this.mOuterRadii[6] = radius.bottomLeftX;
        this.mOuterRadii[7] = radius.bottomLeftY;
        this.mInnerRadii[0] = Math.max(radius.topLeftX - width.left, 0.0f);
        this.mInnerRadii[1] = Math.max(radius.topLeftY - width.top, 0.0f);
        this.mInnerRadii[2] = Math.max(radius.topRightX - width.right, 0.0f);
        this.mInnerRadii[3] = Math.max(radius.topRightY - width.top, 0.0f);
        this.mInnerRadii[4] = Math.max(radius.bottomRightX - width.right, 0.0f);
        this.mInnerRadii[5] = Math.max(radius.bottomRightY - width.bottom, 0.0f);
        this.mInnerRadii[6] = Math.max(radius.bottomLeftX - width.left, 0.0f);
        this.mInnerRadii[7] = Math.max(radius.bottomLeftY - width.bottom, 0.0f);
        this.mStrokeRadii[0] = Math.max(radius.topLeftX - width.left / 2.0f, 0.0f);
        this.mStrokeRadii[1] = Math.max(radius.topLeftY - width.top / 2.0f, 0.0f);
        this.mStrokeRadii[2] = Math.max(radius.topRightX - width.right / 2.0f, 0.0f);
        this.mStrokeRadii[3] = Math.max(radius.topRightY - width.top / 2.0f, 0.0f);
        this.mStrokeRadii[4] = Math.max(radius.bottomRightX - width.right / 2.0f, 0.0f);
        this.mStrokeRadii[5] = Math.max(radius.bottomRightY - width.bottom / 2.0f, 0.0f);
        this.mStrokeRadii[6] = Math.max(radius.bottomLeftX - width.left / 2.0f, 0.0f);
        this.mStrokeRadii[7] = Math.max(radius.bottomLeftY - width.bottom / 2.0f, 0.0f);
    }

    private void fixedBorderWidth() {
        Rect bounds = this.getBounds();
        if (bounds.width() > 0 && this.border.width.left + this.border.width.right > (float)bounds.width()) {
            this.border.width.left = (float)bounds.width() * this.border.width.left / (this.border.width.left + this.border.width.right);
            this.border.width.right = (float)bounds.width() - this.border.width.left;
        }
        if (bounds.height() > 0 && this.border.width.top + this.border.width.bottom > (float)bounds.height()) {
            this.border.width.top = (float)bounds.height() * this.border.width.top / (this.border.width.top + this.border.width.bottom);
            this.border.width.bottom = (float)bounds.height() - this.border.width.top;
        }
    }

    private void drawBackground(Canvas canvas) {
        if (this.drawable != null) {
            this.drawable.setBounds(this.getBounds());
            this.drawable.draw(canvas);
        } else if (this.gradientDrawable != null) {
            this.gradientDrawable.setBounds(this.getBounds());
            this.gradientDrawable.draw(canvas);
        } else if (this.color != 0) {
            this.mBgPaint.setColor(this.color);
            this.mBgPaint.setStyle(Paint.Style.FILL);
            canvas.drawRect(this.getBounds(), this.mBgPaint);
        }
    }

    private void drawBackgroundWithBorder(Canvas canvas) {
        if (this.drawable != null) {
            if (this.border.hasRadius()) {
                this.clipOuterRoundBounds(canvas);
            }
            this.drawable.setBounds(this.getBounds());
            this.drawable.draw(canvas);
        } else if (this.gradientDrawable != null) {
            if (this.border.hasRadius()) {
                this.clipOuterRoundBounds(canvas);
            }
            this.gradientDrawable.setBounds(this.getBounds());
            this.gradientDrawable.draw(canvas);
        } else if (this.color != 0) {
            this.mBgPaint.setColor(this.color);
            this.mBgPaint.setStyle(Paint.Style.FILL);
            if (this.border.hasRadius() && !this.border.hasStyleWidthColor()) {
                this.mOuterBoundsPath.reset();
                this.mOuterBoundsPath.addRoundRect(this.mOuterBoundsRect, this.mOuterRadii, Path.Direction.CW);
                canvas.drawPath(this.mOuterBoundsPath, this.mBgPaint);
            } else {
                if (this.border.hasRadius()) {
                    this.clipOuterRoundBounds(canvas);
                }
                canvas.drawRect(this.getBounds(), this.mBgPaint);
            }
        } else if (this.border.hasRadius()) {
            this.clipOuterRoundBounds(canvas);
        }
        if (this.border.hasStyleWidthColor()) {
            this.drawBorders(canvas, this.border);
        }
    }

    private void drawBorders(Canvas canvas, Border border) {
        if (border.isAllBorderSame()) {
            this.drawSameBorders(canvas, border);
        } else {
            this.drawEachBorders(canvas, border);
        }
    }

    private void drawSameBorders(Canvas canvas, Border border) {
        int borderStyle = border.style.left;
        float borderWidth = border.width.left;
        int borderColor = border.color.left;
        this.mBorderPaint.reset();
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setStrokeWidth(borderWidth);
        this.mBorderPaint.setColor(borderColor);
        this.mBorderPaint.setPathEffect(this.makePathEffect(borderStyle, borderWidth));
        this.mWholeBorderPath.reset();
        if (border.hasRadius()) {
            this.mWholeBorderPath.addRoundRect(this.mStrokeBoundsRect, this.mStrokeRadii, Path.Direction.CW);
        } else {
            this.mWholeBorderPath.addRect(this.mStrokeBoundsRect, Path.Direction.CW);
        }
        canvas.drawPath(this.mWholeBorderPath, this.mBorderPaint);
    }

    private void drawEachBorders(Canvas canvas, Border border) {
        float y3;
        float x3;
        float y2;
        float x2;
        float y1;
        float x1;
        float y0;
        float x0;
        canvas.save();
        if (border.hasRadius()) {
            this.clipBorderInnerRoundBounds(canvas);
        } else {
            this.clipBorderInnerRectBounds(canvas);
        }
        if (border.hasRadius()) {
            if (this.mInnerBoundsRect.width() > this.mInnerBoundsRect.height()) {
                float offsetY = this.mInnerBoundsRect.height() * border.width.top / (border.width.top + border.width.bottom);
                float offsetXL = offsetY * (float)Math.tan((double)(border.width.left / (border.width.top + border.width.left)) * Math.PI / 2.0);
                float offsetXR = offsetY * (float)Math.tan((double)(border.width.right / (border.width.top + border.width.right)) * Math.PI / 2.0);
                this.extendInnerRect.left = this.mInnerBoundsRect.left + offsetXL;
                this.extendInnerRect.right = this.mInnerBoundsRect.right - offsetXR;
                this.extendInnerRect.bottom = this.extendInnerRect.top = this.mInnerBoundsRect.top + offsetY;
            } else {
                float offsetX = this.mInnerBoundsRect.width() * border.width.left / (border.width.left + border.width.right);
                float offsetYT = offsetX * (float)Math.tan((double)(border.width.top / (border.width.left + border.width.top)) * Math.PI / 2.0);
                float offsetYB = offsetX * (float)Math.tan((double)(border.width.bottom / (border.width.left + border.width.bottom)) * Math.PI / 2.0);
                this.extendInnerRect.right = this.extendInnerRect.left = this.mInnerBoundsRect.left + offsetX;
                this.extendInnerRect.top = this.mInnerBoundsRect.top + offsetYT;
                this.extendInnerRect.bottom = this.mInnerBoundsRect.bottom - offsetYB;
            }
        } else {
            this.extendInnerRect.set(this.mInnerBoundsRect);
        }
        RectF bounds = this.mOuterBoundsRect;
        if (border.style.left != 0 && border.width.left > 0.0f && border.color.left != 0) {
            x0 = bounds.left;
            y0 = bounds.top;
            x1 = x0;
            y1 = bounds.bottom;
            x2 = this.extendInnerRect.left;
            y2 = this.extendInnerRect.bottom;
            x3 = this.extendInnerRect.left;
            y3 = this.extendInnerRect.top;
            this.drawEachBorder(canvas, border.color.left, x0, y0, x1, y1, x2, y2, x3, y3);
        }
        if (border.style.top != 0 && border.width.top > 0.0f && border.color.top != 0) {
            x0 = bounds.left;
            y0 = bounds.top;
            x1 = bounds.right;
            y1 = y0;
            x2 = this.extendInnerRect.right;
            y2 = this.extendInnerRect.top;
            x3 = this.extendInnerRect.left;
            y3 = this.extendInnerRect.top;
            this.drawEachBorder(canvas, border.color.top, x0, y0, x1, y1, x2, y2, x3, y3);
        }
        if (border.style.right != 0 && border.width.right > 0.0f && border.color.right != 0) {
            x0 = bounds.right;
            y0 = bounds.top;
            x1 = x0;
            y1 = bounds.bottom;
            x2 = this.extendInnerRect.right;
            y2 = this.extendInnerRect.bottom;
            x3 = this.extendInnerRect.right;
            y3 = this.extendInnerRect.top;
            this.drawEachBorder(canvas, border.color.right, x0, y0, x1, y1, x2, y2, x3, y3);
        }
        if (border.style.bottom != 0 && border.width.bottom > 0.0f && border.color.bottom != 0) {
            x0 = bounds.left;
            y0 = bounds.bottom;
            x1 = bounds.right;
            y1 = y0;
            x2 = this.extendInnerRect.right;
            y2 = this.extendInnerRect.bottom;
            x3 = this.extendInnerRect.left;
            y3 = this.extendInnerRect.bottom;
            this.drawEachBorder(canvas, border.color.bottom, x0, y0, x1, y1, x2, y2, x3, y3);
        }
        canvas.restore();
    }

    private void drawEachBorder(Canvas canvas, int color, float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
        this.mBorderPaint.reset();
        this.mBorderPaint.setStyle(Paint.Style.FILL);
        this.mBorderPaint.setColor(color);
        this.mEachBorderPath.reset();
        this.mEachBorderPath.moveTo(x0, y0);
        this.mEachBorderPath.lineTo(x1, y1);
        this.mEachBorderPath.lineTo(x2, y2);
        this.mEachBorderPath.lineTo(x3, y3);
        this.mEachBorderPath.lineTo(x0, y0);
        canvas.drawPath(this.mEachBorderPath, this.mBorderPaint);
    }

    private void drawShadowIfNeed(Canvas canvas) {
        if (this.shadow == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            this.drawShadow(canvas);
        } else {
            this.drawShadowBelow_9_0(canvas);
        }
    }

    private void drawShadow(Canvas canvas) {
        this.mShadowPaint.setColor(-1);
        this.mShadowPaint.setStyle(Paint.Style.FILL);
        this.mShadowPaint.setShadowLayer(this.shadow.radius, this.shadow.dx, this.shadow.dy, this.shadow.color);
        if (this.border.hasRadius()) {
            this.mOuterBoundsPath.reset();
            this.mOuterBoundsPath.addRoundRect(this.mOuterBoundsRect, this.mOuterRadii, Path.Direction.CW);
            canvas.drawPath(this.mOuterBoundsPath, this.mShadowPaint);
        } else {
            canvas.drawRect(this.getBounds(), this.mShadowPaint);
        }
    }

    private void drawShadowBelow_9_0(Canvas canvas) {
        Bitmap shadowBitmap;
        int offset = (int)(this.shadow.radius * 2.4f);
        this.shadowOuterBounds.set(this.getBounds());
        this.shadowOuterBounds.inset(-offset, -offset);
        try {
            shadowBitmap = Bitmap.createBitmap((int)this.shadowOuterBounds.width(), (int)this.shadowOuterBounds.height(), (Bitmap.Config)Bitmap.Config.ARGB_4444);
        }
        catch (Throwable tr) {
            tr.printStackTrace();
            return;
        }
        Canvas shadowCanvas = new Canvas(shadowBitmap);
        shadowCanvas.translate(-this.shadow.dx + (float)offset, -this.shadow.dy + (float)offset);
        this.mShadowPaint.setColor(-1);
        this.mShadowPaint.setStyle(Paint.Style.FILL);
        this.mShadowPaint.setShadowLayer(this.shadow.radius, this.shadow.dx, this.shadow.dy, this.shadow.color);
        if (this.border.hasRadius()) {
            this.shadowInnerBounds.set(this.mOuterBoundsRect);
            this.shadowInnerBounds.inset(1.0f, 1.0f);
            this.mOuterBoundsPath.reset();
            this.mOuterBoundsPath.addRoundRect(this.shadowInnerBounds, this.mOuterRadii, Path.Direction.CW);
            shadowCanvas.drawPath(this.mOuterBoundsPath, this.mShadowPaint);
        } else {
            this.shadowInnerBounds.set(this.getBounds());
            this.shadowInnerBounds.inset(1.0f, 1.0f);
            shadowCanvas.drawRect(this.shadowInnerBounds, this.mShadowPaint);
        }
        canvas.drawBitmap(shadowBitmap, this.shadow.dx - (float)offset, this.shadow.dy - (float)offset, null);
        if (!shadowBitmap.isRecycled()) {
            shadowBitmap.recycle();
        }
    }

    private void clipOuterRoundBounds(Canvas canvas) {
        this.mOuterBoundsPath.reset();
        this.mOuterBoundsPath.addRoundRect(this.mOuterBoundsRect, this.mOuterRadii, Path.Direction.CW);
        canvas.clipPath(this.mOuterBoundsPath);
    }

    private void clipBorderInnerRectBounds(Canvas canvas) {
        this.mInnerBoundsPath.reset();
        this.mInnerBoundsPath.addRect(this.mInnerBoundsRect, Path.Direction.CW);
        canvas.clipPath(this.mInnerBoundsPath, Region.Op.DIFFERENCE);
    }

    private void clipBorderInnerRoundBounds(Canvas canvas) {
        this.mInnerBoundsPath.reset();
        this.mInnerBoundsPath.addRoundRect(this.mInnerBoundsRect, this.mInnerRadii, Path.Direction.CW);
        canvas.clipPath(this.mInnerBoundsPath, Region.Op.DIFFERENCE);
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -2;
    }

    public void setDrawable(Drawable drawable) {
        this.drawable = drawable;
        this.invalidateSelf();
    }

    public void setColor(int color) {
        this.color = color;
        this.gradientDrawable = null;
        this.drawable = null;
        this.invalidateSelf();
    }

    public void setColor(int deg, int[] colors) {
        if (colors != null && colors.length > 0) {
            this.gradientDrawable = new GradientDrawable(this.transOrientation(deg), colors);
            this.color = 0;
            this.drawable = null;
            this.invalidateSelf();
        }
    }

    public void setColor(Object color) {
        if (color instanceof Integer) {
            this.setColor((Integer)color);
        } else if (color instanceof int[]) {
            int[] array = (int[])color;
            int deg = array[0];
            int[] colors = Arrays.copyOfRange(array, 1, array.length);
            this.setColor(deg, colors);
        }
    }

    public int getColor() {
        return this.color;
    }

    private GradientDrawable.Orientation transOrientation(int deg) {
        GradientDrawable.Orientation orientation;
        switch (deg %= 360) {
            default: {
                orientation = GradientDrawable.Orientation.BOTTOM_TOP;
                break;
            }
            case 45: {
                orientation = GradientDrawable.Orientation.BL_TR;
                break;
            }
            case 90: {
                orientation = GradientDrawable.Orientation.LEFT_RIGHT;
                break;
            }
            case 135: {
                orientation = GradientDrawable.Orientation.TL_BR;
                break;
            }
            case 180: {
                orientation = GradientDrawable.Orientation.TOP_BOTTOM;
                break;
            }
            case 225: {
                orientation = GradientDrawable.Orientation.TR_BL;
                break;
            }
            case 270: {
                orientation = GradientDrawable.Orientation.RIGHT_LEFT;
                break;
            }
            case 315: {
                orientation = GradientDrawable.Orientation.BR_TL;
            }
        }
        return orientation;
    }

    @Nullable
    private PathEffect makePathEffect(@BorderStyle int style, float borderWidth) {
        switch (style) {
            default: {
                return null;
            }
            case 2: {
                return new DashPathEffect(new float[]{borderWidth * 3.0f, borderWidth * 3.0f, borderWidth * 3.0f, borderWidth * 3.0f}, 0.0f);
            }
            case 3: 
        }
        return new DashPathEffect(new float[]{borderWidth, borderWidth, borderWidth, borderWidth}, 0.0f);
    }

    public void setBorder(float width, int color, float radius, @BorderStyle int style) {
        this.border = new Border(width, color, radius, style);
        this.invalidateSelf();
    }

    public void setBorder(Border border) {
        this.border = border;
        this.invalidateSelf();
    }

    public void setBorderStyle(@BorderStyle int style) {
        this.border.style.set(style, style, style, style);
        this.invalidateSelf();
    }

    public void setBorderLeftStyle(@BorderStyle int style) {
        this.border.style.left = style;
        this.invalidateSelf();
    }

    public void setBorderTopStyle(@BorderStyle int style) {
        this.border.style.top = style;
        this.invalidateSelf();
    }

    public void setBorderRightStyle(@BorderStyle int style) {
        this.border.style.right = style;
        this.invalidateSelf();
    }

    public void setBorderBottomStyle(@BorderStyle int style) {
        this.border.style.bottom = style;
        this.invalidateSelf();
    }

    public void setBorderStyle(String style) {
        this.setBorderStyle(Border.getStyle(style));
    }

    public void setBorderLeftStyle(String style) {
        this.setBorderLeftStyle(Border.getStyle(style));
    }

    public void setBorderTopStyle(String style) {
        this.setBorderTopStyle(Border.getStyle(style));
    }

    public void setBorderRightStyle(String style) {
        this.setBorderRightStyle(Border.getStyle(style));
    }

    public void setBorderBottomStyle(String style) {
        this.setBorderBottomStyle(Border.getStyle(style));
    }

    public void setBorderWidth(float width) {
        this.border.width.set(width, width, width, width);
        this.invalidateSelf();
    }

    public void setBorderLeftWidth(float width) {
        this.border.width.left = width;
        this.invalidateSelf();
    }

    public void setBorderTopWidth(float width) {
        this.border.width.top = width;
        this.invalidateSelf();
    }

    public void setBorderRightWidth(float width) {
        this.border.width.right = width;
        this.invalidateSelf();
    }

    public void setBorderBottomWidth(float width) {
        this.border.width.bottom = width;
        this.invalidateSelf();
    }

    public void setBorderColor(int color) {
        this.border.color.set(color, color, color, color);
        this.invalidateSelf();
    }

    public void setBorderLeftColor(int color) {
        this.border.color.left = color;
        this.invalidateSelf();
    }

    public void setBorderTopColor(int color) {
        this.border.color.top = color;
        this.invalidateSelf();
    }

    public void setBorderRightColor(int color) {
        this.border.color.right = color;
        this.invalidateSelf();
    }

    public void setBorderBottomColor(int color) {
        this.border.color.bottom = color;
        this.invalidateSelf();
    }

    public void setBorderRadius(float radius) {
        this.border.radius.set(radius, radius, radius, radius, radius, radius, radius, radius);
        this.invalidateSelf();
    }

    public void setBorderTopLeftRadius(float radius) {
        this.border.radius.topLeftX = radius;
        this.border.radius.topLeftY = radius;
        this.invalidateSelf();
    }

    public void setBorderTopRightRadius(float radius) {
        this.border.radius.topRightX = radius;
        this.border.radius.topRightY = radius;
        this.invalidateSelf();
    }

    public void setBorderBottomRightRadius(float radius) {
        this.border.radius.bottomRightX = radius;
        this.border.radius.bottomRightY = radius;
        this.invalidateSelf();
    }

    public void setBorderBottomLeftRadius(float radius) {
        this.border.radius.bottomLeftX = radius;
        this.border.radius.bottomLeftY = radius;
        this.invalidateSelf();
    }

    public void setBorderRadiusPercent(float radiusPercent) {
        this.border.radius.topLeftPercent = radiusPercent;
        this.border.radius.topRightPercent = radiusPercent;
        this.border.radius.bottomRightPercent = radiusPercent;
        this.border.radius.bottomLeftPercent = radiusPercent;
        this.invalidateSelf();
    }

    public void setBorderTopLeftRadiusPercent(float radiusPercent) {
        this.border.radius.topLeftPercent = radiusPercent;
        this.invalidateSelf();
    }

    public void setBorderTopRightRadiusPercent(float radiusPercent) {
        this.border.radius.topRightPercent = radiusPercent;
        this.invalidateSelf();
    }

    public void setBorderBottomRightRadiusPercent(float radiusPercent) {
        this.border.radius.bottomRightPercent = radiusPercent;
        this.invalidateSelf();
    }

    public void setBorderBottomLeftRadiusPercent(float radiusPercent) {
        this.border.radius.bottomLeftPercent = radiusPercent;
        this.invalidateSelf();
    }

    public Border getBorder() {
        return this.border;
    }

    public float[] getBorderRadii() {
        return this.mOuterRadii;
    }

    public void setShadow(float radius, float dx, float dy, int color) {
        this.shadow = new Shadow(radius, dx, dy, color);
        this.invalidateSelf();
    }

    public static class Shadow {
        public float radius;
        public float dx;
        public float dy;
        public int color;

        public Shadow(float radius, float dx, float dy, int color) {
            this.radius = radius;
            this.dx = dx;
            this.dy = dy;
            this.color = color;
        }
    }

    public static class Border {
        public Rect style;
        public RectF width;
        public Rect color;
        public BorderRadius radius;

        public Border() {
            this.style = new Rect(1, 1, 1, 1);
            this.width = new RectF();
            this.color = new Rect(-16777216, -16777216, -16777216, -16777216);
            this.radius = new BorderRadius();
        }

        public Border(float width, int color, float radius) {
            this(width, color, radius, 1);
        }

        public Border(float width, int color, float radius, @BorderStyle int style) {
            this.style = new Rect(style, style, style, style);
            this.width = new RectF(width, width, width, width);
            this.color = new Rect(color, color, color, color);
            this.radius = new BorderRadius(radius, radius, radius, radius, radius, radius, radius, radius);
        }

        public boolean hasBorder() {
            return this.hasStyleWidthColor() || this.hasRadius();
        }

        public boolean hasStyleWidthColor() {
            return this.hasStyle() && this.hasWidth() && this.hasColor();
        }

        public boolean hasStyle() {
            return this.style != null && (this.style.left != 0 || this.style.top != 0 || this.style.right != 0 || this.style.bottom != 0);
        }

        public boolean hasWidth() {
            return this.width != null && (this.width.left > 0.0f || this.width.top > 0.0f || this.width.right > 0.0f || this.width.bottom > 0.0f);
        }

        public boolean hasColor() {
            return this.color != null && (this.color.left != 0 || this.color.top != 0 || this.color.right != 0 || this.color.bottom != 0);
        }

        public boolean hasRadius() {
            return this.radius != null && this.radius.isValid();
        }

        public boolean isAllBorderSame() {
            return this.style.left == this.style.top && this.style.left == this.style.right && this.style.left == this.style.bottom && this.width.left == this.width.top && this.width.left == this.width.right && this.width.left == this.width.bottom && this.color.left == this.color.top && this.color.left == this.color.right && this.color.left == this.color.bottom;
        }

        @BorderStyle
        public static int getStyle(String styleName) {
            if (TextUtils.isEmpty((CharSequence)styleName)) {
                return 1;
            }
            switch (styleName.toUpperCase()) {
                case "SOLID": {
                    return 1;
                }
                case "DASHED": {
                    return 2;
                }
                case "DOTTED": {
                    return 3;
                }
            }
            return 0;
        }

        public void toRTL() {
            RTLUtil.toRTLRect(this.style);
            RTLUtil.toRTLRect(this.width);
            RTLUtil.toRTLRect(this.color);
            this.radius.toRTL();
        }
    }

    public static class BorderRadius {
        float topLeftX;
        float topLeftY;
        float topRightX;
        float topRightY;
        float bottomRightX;
        float bottomRightY;
        float bottomLeftX;
        float bottomLeftY;
        float topLeftPercent;
        float topRightPercent;
        float bottomRightPercent;
        float bottomLeftPercent;

        public BorderRadius() {
        }

        public BorderRadius(float topLeftX, float topLeftY, float topRightX, float topRightY, float bottomRightX, float bottomRightY, float bottomLeftX, float bottomLeftY) {
            this.set(topLeftX, topLeftY, topRightX, topRightY, bottomRightX, bottomRightY, bottomLeftX, bottomLeftY);
        }

        public void set(float topLeftX, float topLeftY, float topRightX, float topRightY, float bottomRightX, float bottomRightY, float bottomLeftX, float bottomLeftY) {
            this.topLeftX = topLeftX;
            this.topLeftY = topLeftY;
            this.topRightX = topRightX;
            this.topRightY = topRightY;
            this.bottomRightX = bottomRightX;
            this.bottomRightY = bottomRightY;
            this.bottomLeftX = bottomLeftX;
            this.bottomLeftY = bottomLeftY;
        }

        public boolean isValid() {
            return this.topLeftX > 0.0f || this.topLeftY > 0.0f || this.topRightX > 0.0f || this.topRightY > 0.0f || this.bottomRightX > 0.0f || this.bottomRightY > 0.0f || this.bottomLeftX > 0.0f || this.bottomLeftY > 0.0f || this.topLeftPercent > 0.0f || this.topRightPercent > 0.0f || this.bottomRightPercent > 0.0f || this.bottomLeftPercent > 0.0f;
        }

        public void fillWithPercent(Rect bounds) {
            if (bounds == null || bounds.isEmpty()) {
                return;
            }
            if (this.topLeftPercent > 0.0f) {
                if (this.topLeftX <= 0.0f) {
                    this.topLeftX = (float)bounds.width() * this.topLeftPercent / 100.0f;
                }
                if (this.topLeftY <= 0.0f) {
                    this.topLeftY = (float)bounds.height() * this.topLeftPercent / 100.0f;
                }
            }
            if (this.topRightPercent > 0.0f && this.topRightX <= 0.0f && this.topRightY <= 0.0f) {
                if (this.topRightX <= 0.0f) {
                    this.topRightX = (float)bounds.width() * this.topRightPercent / 100.0f;
                }
                if (this.topRightY <= 0.0f) {
                    this.topRightY = (float)bounds.height() * this.topRightPercent / 100.0f;
                }
            }
            if (this.bottomRightPercent > 0.0f && this.bottomRightX <= 0.0f && this.bottomRightY <= 0.0f) {
                if (this.bottomRightX <= 0.0f) {
                    this.bottomRightX = (float)bounds.width() * this.bottomRightPercent / 100.0f;
                }
                if (this.bottomRightY <= 0.0f) {
                    this.bottomRightY = (float)bounds.height() * this.bottomRightPercent / 100.0f;
                }
            }
            if (this.bottomLeftPercent > 0.0f && this.bottomLeftX <= 0.0f && this.bottomLeftY <= 0.0f) {
                if (this.bottomLeftX <= 0.0f) {
                    this.bottomLeftX = (float)bounds.width() * this.bottomLeftPercent / 100.0f;
                }
                if (this.bottomLeftY <= 0.0f) {
                    this.bottomLeftY = (float)bounds.height() * this.bottomLeftPercent / 100.0f;
                }
            }
        }

        public void toRTL() {
            float t = this.topLeftX;
            this.topLeftX = this.topRightX;
            this.topRightX = t;
            t = this.topLeftY;
            this.topLeftY = this.topRightY;
            this.topRightY = t;
            t = this.bottomLeftX;
            this.bottomLeftX = this.bottomRightX;
            this.bottomRightX = t;
            t = this.bottomLeftY;
            this.bottomLeftY = this.bottomRightY;
            this.bottomRightY = t;
            t = this.topLeftPercent;
            this.topLeftPercent = this.topRightPercent;
            this.topRightPercent = t;
            t = this.bottomLeftPercent;
            this.bottomLeftPercent = this.bottomRightPercent;
            this.bottomRightPercent = t;
        }
    }

    public static @interface BorderStyle {
        public static final int NONE = 0;
        public static final int SOLID = 1;
        public static final int DASHED = 2;
        public static final int DOTTED = 3;
    }
}

