/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.render.component.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import com.didi.hummer.HummerSDK;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.render.component.view.BackgroundDrawable;
import com.didi.hummer.render.utility.RTLUtil;
import com.didi.hummer.render.utility.YogaDrawableUtil;

public class BackgroundHelper {
    private Context context;
    private View view;
    private BackgroundDrawable backgroundDrawable;

    public BackgroundHelper(Context context, View view) {
        this.context = context;
        this.view = view;
    }

    private BackgroundDrawable getBgDrawable() {
        if (this.backgroundDrawable == null) {
            boolean supportRTL = this.context instanceof HummerContext && HummerSDK.isSupportRTL(((HummerContext)this.context).getNamespace());
            boolean needRTL = supportRTL && RTLUtil.isRTL(this.context);
            this.backgroundDrawable = new BackgroundDrawable(needRTL);
            if (this.view != null) {
                this.view.setBackground((Drawable)this.backgroundDrawable);
            }
        }
        return this.backgroundDrawable;
    }

    public void setBackgroundColor(int color) {
        this.getBgDrawable().setColor(color);
    }

    public int getBackgroundColor() {
        return this.getBgDrawable().getColor();
    }

    public void setBackgroundColor(Object color) {
        this.getBgDrawable().setColor(color);
    }

    public void setBackgroundImage(String image) {
        YogaDrawableUtil.renderDrawable((HummerContext)this.context, this.getBgDrawable(), image);
    }

    public void setBorderStyle(String style) {
        this.getBgDrawable().setBorderStyle(style);
    }

    public void setBorderLeftStyle(String style) {
        this.getBgDrawable().setBorderLeftStyle(style);
    }

    public void setBorderTopStyle(String style) {
        this.getBgDrawable().setBorderTopStyle(style);
    }

    public void setBorderRightStyle(String style) {
        this.getBgDrawable().setBorderRightStyle(style);
    }

    public void setBorderBottomStyle(String style) {
        this.getBgDrawable().setBorderBottomStyle(style);
    }

    public void setBorderWidth(float width) {
        this.getBgDrawable().setBorderWidth(width);
    }

    public void setBorderLeftWidth(float width) {
        this.getBgDrawable().setBorderLeftWidth(width);
    }

    public void setBorderTopWidth(float width) {
        this.getBgDrawable().setBorderTopWidth(width);
    }

    public void setBorderRightWidth(float width) {
        this.getBgDrawable().setBorderRightWidth(width);
    }

    public void setBorderBottomWidth(float width) {
        this.getBgDrawable().setBorderBottomWidth(width);
    }

    public void setBorderColor(int color) {
        this.getBgDrawable().setBorderColor(color);
    }

    public void setBorderLeftColor(int color) {
        this.getBgDrawable().setBorderLeftColor(color);
    }

    public void setBorderTopColor(int color) {
        this.getBgDrawable().setBorderTopColor(color);
    }

    public void setBorderRightColor(int color) {
        this.getBgDrawable().setBorderRightColor(color);
    }

    public void setBorderBottomColor(int color) {
        this.getBgDrawable().setBorderBottomColor(color);
    }

    public void setBorderRadius(float radius) {
        this.getBgDrawable().setBorderRadius(radius);
    }

    public void setBorderTopLeftRadius(float radius) {
        this.getBgDrawable().setBorderTopLeftRadius(radius);
    }

    public void setBorderTopRightRadius(float radius) {
        this.getBgDrawable().setBorderTopRightRadius(radius);
    }

    public void setBorderBottomRightRadius(float radius) {
        this.getBgDrawable().setBorderBottomRightRadius(radius);
    }

    public void setBorderBottomLeftRadius(float radius) {
        this.getBgDrawable().setBorderBottomLeftRadius(radius);
    }

    public void setBorderRadiusPercent(float radiusPercent) {
        this.getBgDrawable().setBorderRadiusPercent(radiusPercent);
    }

    public void setBorderTopLeftRadiusPercent(float radiusPercent) {
        this.getBgDrawable().setBorderTopLeftRadiusPercent(radiusPercent);
    }

    public void setBorderTopRightRadiusPercent(float radiusPercent) {
        this.getBgDrawable().setBorderTopRightRadiusPercent(radiusPercent);
    }

    public void setBorderBottomRightRadiusPercent(float radiusPercent) {
        this.getBgDrawable().setBorderBottomRightRadiusPercent(radiusPercent);
    }

    public void setBorderBottomLeftRadiusPercent(float radiusPercent) {
        this.getBgDrawable().setBorderBottomLeftRadiusPercent(radiusPercent);
    }

    BackgroundDrawable.Border getBorder() {
        return this.getBgDrawable().getBorder();
    }

    public float[] getBorderRadii() {
        return this.getBgDrawable().getBorderRadii();
    }

    public void setShadow(float radius, float dx, float dy, int color) {
        this.getBgDrawable().setShadow(radius, dx, dy, color);
    }

    public Drawable getBackgroundDrawable() {
        if (this.view == null) {
            return null;
        }
        return this.view.getBackground();
    }

    public void setBackgroundDrawable(Drawable drawable) {
        if (this.view == null) {
            return;
        }
        this.view.setBackground(drawable);
    }
}

