/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.render.component.view;

import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSCallback;
import com.didi.hummer.core.engine.JSValue;
import com.didi.hummer.core.util.HMJsonUtil;
import com.didi.hummer.lifecycle.ILifeCycle;
import com.didi.hummer.pool.ObjectPool;
import com.didi.hummer.render.component.anim.BasicAnimation;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.component.view.Invoker;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class BaseInvoker<T>
implements Invoker {
    protected HummerContext mHummerContext;
    protected ObjectPool mInstanceManager;

    protected abstract T createInstance(JSValue var1, Object ... var2);

    protected abstract Object invoke(T var1, String var2, Object ... var3);

    @Override
    public Object onInvoke(HummerContext context, long objectID, String methodName, Object ... params) {
        this.mHummerContext = context;
        this.mInstanceManager = context.getObjectPool();
        T instance = this.getInstance(objectID, methodName, params);
        Object ret = instance instanceof HMBase ? this.invokeHMBase(instance, methodName, params) : this.invoke(instance, methodName, params);
        return ret;
    }

    private Object invokeHMBase(T instance, String methodName, Object ... params) {
        HMBase base = (HMBase)instance;
        Object ret = null;
        switch (methodName) {
            case "setStyle": {
                Map styleMap = HMJsonUtil.toMap((String)String.valueOf(params[0]));
                base.setStyle(this.getSortedMap(styleMap));
                break;
            }
            case "setEnabled": {
                base.setEnabled((Boolean)params[0]);
                break;
            }
            case "setAccessible": {
                base.setAccessible((Boolean)params[0]);
                break;
            }
            case "setAccessibilityLabel": {
                base.setAccessibilityLabel(String.valueOf(params[0]));
                break;
            }
            case "setAccessibilityHint": {
                base.setAccessibilityHint(String.valueOf(params[0]));
                break;
            }
            case "setAccessibilityRole": {
                base.setAccessibilityRole(String.valueOf(params[0]));
                break;
            }
            case "setAccessibilityState": {
                Map stateMap = HMJsonUtil.toMap((String)String.valueOf(params[0]));
                base.setAccessibilityState(stateMap);
                break;
            }
            case "addEventListener": {
                String eventName = String.valueOf(params[0]);
                JSCallback callback = (JSCallback)params[1];
                base.addEventListener(eventName, callback);
                break;
            }
            case "removeEventListener": {
                String eventName = String.valueOf(params[0]);
                JSCallback callback = params.length > 1 ? (JSCallback)params[1] : null;
                base.removeEventListener(eventName, callback);
                break;
            }
            case "addAnimation": {
                long objId = ((Number)params[0]).longValue();
                BasicAnimation anim = (BasicAnimation)this.mInstanceManager.get(objId);
                String id = (String)params[1];
                base.addAnimation(anim, id);
                break;
            }
            case "removeAnimationForKey": {
                String id = String.valueOf(params[0]);
                base.removeAnimationForKey(id);
                break;
            }
            case "removeAllAnimation": {
                base.removeAllAnimation();
                break;
            }
            case "getRect": {
                base.getRect((JSCallback)params[0]);
                break;
            }
            case "resetStyle": {
                base.resetStyle();
                break;
            }
            case "dbg_highlight": {
                base.dbg_highlight(params.length > 0 ? params[0] : null);
                break;
            }
            case "dbg_getDescription": {
                JSCallback callback = params.length > 0 ? (JSCallback)params[0] : null;
                int depth = params.length > 1 ? ((Number)params[1]).intValue() : 0;
                base.dbg_getDescription(callback, depth);
                break;
            }
            case "recycle": {
                break;
            }
            default: {
                ret = this.invoke(instance, methodName, params);
            }
        }
        return ret;
    }

    private T getInstance(long objectID, String methodName, Object ... params) {
        if (objectID <= 0L) {
            return null;
        }
        Object instance = this.mInstanceManager.get(objectID);
        if (instance == null && "constructor".equals(methodName)) {
            JSValue jsValue;
            JSValue jSValue = jsValue = params.length > 0 ? (JSValue)params[0] : null;
            if (jsValue != null) {
                if (params.length > 1) {
                    Object[] parameters = Arrays.copyOfRange(params, 1, params.length);
                    instance = this.createInstance(jsValue, parameters);
                } else {
                    instance = this.createInstance(jsValue, new Object[0]);
                }
                if (instance instanceof ILifeCycle) {
                    ((ILifeCycle)instance).onCreate();
                }
                this.mInstanceManager.put(objectID, instance);
            }
        }
        return instance;
    }

    private Map<String, Object> getSortedMap(Map<String, Object> srcMap) {
        Object displayValue;
        if (!srcMap.containsKey("position") && !srcMap.containsKey("display")) {
            return srcMap;
        }
        LinkedHashMap<String, Object> sortedMap = new LinkedHashMap<String, Object>();
        Object posValue = srcMap.remove("position");
        if (posValue != null) {
            sortedMap.put("position", posValue);
        }
        if ((displayValue = srcMap.remove("display")) != null) {
            sortedMap.put("display", displayValue);
        }
        sortedMap.putAll(srcMap);
        return sortedMap;
    }
}

