/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.render.component.view;

import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.text.TextUtils;
import android.view.View;
import com.didi.hummer.annotation.JsAttribute;
import com.didi.hummer.annotation.JsMethod;
import com.didi.hummer.annotation.JsProperty;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSCallback;
import com.didi.hummer.core.engine.JSValue;
import com.didi.hummer.core.util.DebugUtil;
import com.didi.hummer.debug.Highlight;
import com.didi.hummer.lifecycle.ILifeCycle;
import com.didi.hummer.render.component.anim.AnimViewWrapper;
import com.didi.hummer.render.component.anim.BasicAnimation;
import com.didi.hummer.render.component.anim.HummerAnimationUtils;
import com.didi.hummer.render.component.anim.Transition;
import com.didi.hummer.render.component.view.BackgroundHelper;
import com.didi.hummer.render.component.view.HMGestureEventDetector;
import com.didi.hummer.render.component.view.InlineBox;
import com.didi.hummer.render.event.EventManager;
import com.didi.hummer.render.style.HummerLayoutExtendUtils;
import com.didi.hummer.render.style.HummerNode;
import com.didi.hummer.render.style.HummerStyleUtils;
import com.didi.hummer.render.utility.DPUtil;
import com.didi.hummer.render.utility.YogaAttrUtils;
import com.didi.hummer.sdk.R;
import com.didi.hummer.utils.ScreenUtils;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaNode;
import com.facebook.yoga.YogaPositionType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class HMBase<T extends View>
implements ILifeCycle {
    private HummerContext context;
    private T mTargetView;
    protected HummerNode hummerNode;
    private Map<String, BasicAnimation> animMap = new HashMap<String, BasicAnimation>();
    protected BackgroundHelper backgroundHelper;
    protected EventManager mEventManager;
    protected HMGestureEventDetector hmGestureEventDetector;
    protected JSValue mJSValue;
    private String boxSizing = "none";
    private InlineBox inlineBox;
    private PositionChangedListener positionChangedListener;
    private DisplayChangedListener displayChangedListener;
    private HummerLayoutExtendUtils.Position position = HummerLayoutExtendUtils.Position.YOGA;
    private HummerLayoutExtendUtils.Display display = HummerLayoutExtendUtils.Display.YOGA;
    private AnimViewWrapper animViewWrapper;
    private static final String BOX_SIZING_NONE = "none";
    private static final String BOX_SIZING_BORDER_BOX = "border-box";
    private static final String BOX_SIZING_CONTENT_BOX = "content-box";
    @JsProperty(value="style")
    public Map<String, Object> style = new HashMap<String, Object>();
    @JsProperty(value="enabled")
    public boolean enabled;
    @JsProperty(value="accessible")
    public boolean accessible;
    @JsProperty(value="accessibilityLabel")
    public String accessibilityLabel;
    @JsProperty(value="accessibilityHint")
    public String accessibilityHint;
    @JsProperty(value="accessibilityRole")
    public String accessibilityRole;
    @JsProperty(value="accessibilityState")
    public Map<String, Object> accessibilityState;
    public static final String VISIBILITY_VISIBLE = "visible";
    public static final String VISIBILITY_HIDDEN = "hidden";
    private List<Transition> transitions = new ArrayList<Transition>();
    List<Double> durationList = new ArrayList<Double>();
    double transitionDelay = 0.0;
    String transitionTimingFunction = null;
    List<ObjectAnimator> objectAnimatorList = new ArrayList<ObjectAnimator>();

    public HMBase(HummerContext context, JSValue jsValue, String viewID) {
        this.context = context;
        this.mJSValue = jsValue;
        this.mTargetView = this.createView(context.getContext());
        this.hummerNode = new HummerNode(this, viewID);
        this.backgroundHelper = new BackgroundHelper((Context)context, (View)this.mTargetView);
        this.animViewWrapper = new AnimViewWrapper(this);
        ViewCompat.setAccessibilityDelegate(this.mTargetView, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                ArrayList<String> contents = new ArrayList<String>();
                if (HMBase.this.accessibilityLabel != null) {
                    contents.add(HMBase.this.accessibilityLabel);
                }
                if (HMBase.this.accessibilityHint != null) {
                    if (HMBase.this.accessibilityLabel == null && info.getText() != null) {
                        contents.add(info.getText().toString());
                    }
                    contents.add(HMBase.this.accessibilityHint);
                }
                if (!contents.isEmpty()) {
                    info.setContentDescription((CharSequence)TextUtils.join((CharSequence)", ", contents));
                }
                if (HMBase.this.accessibilityRole != null) {
                    info.setRoleDescription((CharSequence)HMBase.this.accessibilityRole);
                }
                if (HMBase.this.accessibilityState != null) {
                    for (String key : HMBase.this.accessibilityState.keySet()) {
                        Object value = HMBase.this.accessibilityState.get(key);
                        if ("selected".equalsIgnoreCase(key)) {
                            if (!(value instanceof Boolean)) continue;
                            info.setSelected(((Boolean)value).booleanValue());
                            continue;
                        }
                        if (!"disabled".equalsIgnoreCase(key) || !(value instanceof Boolean)) continue;
                        info.setEnabled((Boolean)value == false);
                    }
                }
            }
        });
    }

    @Override
    public void onCreate() {
        this.mEventManager = new EventManager();
        this.mEventManager.onCreate();
        this.hmGestureEventDetector = new HMGestureEventDetector(this);
    }

    @Override
    public void onDestroy() {
        if (this.animMap != null) {
            this.animMap.clear();
            this.animMap = null;
        }
        if (this.mEventManager != null) {
            this.getView().post(() -> this.mEventManager.onDestroy());
        }
    }

    public JSValue getJSValue() {
        return this.mJSValue;
    }

    public String getViewID() {
        return this.hummerNode.getId();
    }

    public YogaNode getYogaNode() {
        return this.hummerNode.getYogaNode();
    }

    public HummerNode getNode() {
        return this.hummerNode;
    }

    private final T createView(Context context) {
        T view = this.createViewInstance(context);
        if (view == null) {
            throw new RuntimeException("createViewInstance must return a view");
        }
        return view;
    }

    protected abstract T createViewInstance(Context var1);

    public T getView() {
        return this.mTargetView;
    }

    public AnimViewWrapper getAnimViewWrapper() {
        return this.animViewWrapper;
    }

    public EventManager getEventManager() {
        return this.mEventManager;
    }

    public void setStyle(Map<String, Object> style) {
        this.style = style;
        this.hummerNode.setStyle(style);
        this.onStyleUpdated(style);
    }

    protected void onStyleUpdated(Map<String, Object> newStyle) {
    }

    public BackgroundHelper getBackgroundHelper() {
        return this.backgroundHelper;
    }

    public void setEnabled(boolean enabled) {
        this.getView().setEnabled(enabled);
    }

    public boolean getEnabled() {
        return this.getView().isEnabled();
    }

    public void setAccessible(boolean accessible) {
        this.getView().setImportantForAccessibility(accessible ? 1 : 2);
    }

    public void setAccessibilityLabel(String label) {
        this.accessibilityLabel = label;
    }

    public void setAccessibilityHint(String hint) {
        this.accessibilityHint = hint;
    }

    public void setAccessibilityRole(String role) {
        Resources r = this.getContext().getResources();
        this.accessibilityRole = BOX_SIZING_NONE.equalsIgnoreCase(role) ? "" : ("text".equalsIgnoreCase(role) ? r.getString(R.string.accessibility_role_text) : ("button".equalsIgnoreCase(role) ? r.getString(R.string.accessibility_role_button) : ("image".equalsIgnoreCase(role) ? r.getString(R.string.accessibility_role_image) : ("switch".equalsIgnoreCase(role) ? r.getString(R.string.accessibility_role_switch) : ("input".equalsIgnoreCase(role) ? r.getString(R.string.accessibility_role_input) : ("link".equalsIgnoreCase(role) ? r.getString(R.string.accessibility_role_link) : ("search".equalsIgnoreCase(role) ? r.getString(R.string.accessibility_role_search) : ("key".equalsIgnoreCase(role) ? r.getString(R.string.accessibility_role_key) : role))))))));
    }

    public void setAccessibilityState(Map<String, Object> state) {
        this.accessibilityState = state;
        if (this.accessibilityState != null) {
            for (String key : this.accessibilityState.keySet()) {
                Object value = this.accessibilityState.get(key);
                if (!"selected".equalsIgnoreCase(key) || !(value instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
                this.getView().post(() -> this.getView().sendAccessibilityEvent(32768));
            }
        }
    }

    @JsMethod(value="addEventListener")
    public void addEventListener(String eventName, JSCallback callback) {
        this.mEventManager.addEventListener(eventName, callback);
        this.hmGestureEventDetector.initClickListener(eventName);
    }

    @JsMethod(value="removeEventListener")
    public void removeEventListener(String eventName, JSCallback callback) {
        if (callback == null) {
            this.mEventManager.clearEventListeners(eventName);
        } else {
            this.mEventManager.removeEventListener(eventName, callback);
        }
    }

    @JsMethod(value="addAnimation")
    public void addAnimation(BasicAnimation anim, String id) {
        this.animMap.put(id, anim);
        anim.start(this);
    }

    @JsMethod(value="removeAnimationForKey")
    public void removeAnimationForKey(String id) {
        if (this.animMap.containsKey(id)) {
            BasicAnimation anim = this.animMap.get(id);
            anim.stop();
            this.animMap.remove(id);
        }
    }

    @JsMethod(value="removeAllAnimation")
    public void removeAllAnimation() {
        Iterator<Map.Entry<String, BasicAnimation>> iterator = this.animMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, BasicAnimation> entry = iterator.next();
            BasicAnimation animation = entry.getValue();
            animation.stop();
            iterator.remove();
        }
    }

    @JsMethod(value="getRect")
    public void getRect(JSCallback callback) {
        if (callback == null) {
            return;
        }
        this.getView().post(() -> {
            Rect rect = new Rect();
            int[] floats = ScreenUtils.getViewLocationOnScreen(this.getView());
            this.getView().getHitRect(rect);
            HashMap<String, Float> values = new HashMap<String, Float>();
            values.put("width", Float.valueOf(DPUtil.px2dpF((Context)this.context, this.getView().getWidth())));
            values.put("height", Float.valueOf(DPUtil.px2dpF((Context)this.context, this.getView().getHeight())));
            values.put("left", Float.valueOf(DPUtil.px2dpF((Context)this.context, rect.left)));
            values.put("right", Float.valueOf(DPUtil.px2dpF((Context)this.context, rect.right)));
            values.put("top", Float.valueOf(DPUtil.px2dpF((Context)this.context, rect.top)));
            values.put("bottom", Float.valueOf(DPUtil.px2dpF((Context)this.context, rect.bottom)));
            values.put("windowLeft", Float.valueOf(DPUtil.px2dpF((Context)this.context, floats[0])));
            values.put("windowRight", Float.valueOf(DPUtil.px2dpF((Context)this.context, floats[0] + this.getView().getWidth())));
            values.put("windowTop", Float.valueOf(DPUtil.px2dpF((Context)this.context, floats[1])));
            values.put("windowBottom", Float.valueOf(DPUtil.px2dpF((Context)this.context, floats[1] + this.getView().getHeight())));
            callback.call(new Object[]{values});
        });
    }

    @Deprecated
    @JsMethod(value="resetStyle")
    public void resetStyle() {
        this.hummerNode.resetStyle();
        this.setBackgroundColor(0);
        this.setBackgroundImage(null);
        this.setBorderWidth(0.0f);
        this.setBorderColor(0);
        this.setBorderRadius(0);
        this.setBorderStyle(null);
        this.setShadow(null);
        this.setOpacity(1.0f);
        this.setVisibility(VISIBILITY_VISIBLE);
    }

    @JsMethod(value="dbg_highlight")
    public void dbg_highlight(Object config) {
        if (config == null) {
            Highlight.show(this.getView());
            return;
        }
        if (config instanceof Boolean) {
            boolean enable = (Boolean)config;
            if (enable) {
                Highlight.show(this.getView());
            } else {
                Highlight.clear();
            }
        } else if (config instanceof Map) {
            // empty if block
        }
    }

    @JsMethod(value="dbg_getDescription")
    public void dbg_getDescription(JSCallback callback, int depth) {
        if (!DebugUtil.isDebuggable() || callback == null) {
            return;
        }
        if (depth <= 0) {
            depth = Integer.MAX_VALUE;
        }
        int fDepth = depth;
        this.getView().post(() -> {
            JSValue node = this.getNode().getJSNodeTree(fDepth);
            callback.call(new Object[]{node});
        });
    }

    @JsAttribute(value={"visibility"})
    public void setVisibility(String hidden) {
        this.getView().setVisibility(VISIBILITY_HIDDEN.equals(hidden) ? 4 : 0);
    }

    @JsAttribute(value={"backgroundColor"})
    public void setBackgroundColor(Object color) {
        this.backgroundHelper.setBackgroundColor(color);
    }

    @JsAttribute(value={"backgroundImage"})
    public void setBackgroundImage(String image) {
        this.backgroundHelper.setBackgroundImage(image);
    }

    @JsAttribute(value={"borderStyle"})
    public void setBorderStyle(String style) {
        this.backgroundHelper.setBorderStyle(style);
    }

    @JsAttribute(value={"borderLeftStyle"})
    public void setBorderLeftStyle(String style) {
        this.backgroundHelper.setBorderLeftStyle(style);
    }

    @JsAttribute(value={"borderTopStyle"})
    public void setBorderTopStyle(String style) {
        this.backgroundHelper.setBorderTopStyle(style);
    }

    @JsAttribute(value={"borderRightStyle"})
    public void setBorderRightStyle(String style) {
        this.backgroundHelper.setBorderRightStyle(style);
    }

    @JsAttribute(value={"borderBottomStyle"})
    public void setBorderBottomStyle(String style) {
        this.backgroundHelper.setBorderBottomStyle(style);
    }

    @JsAttribute(value={"borderWidth"})
    public void setBorderWidth(float width) {
        this.backgroundHelper.setBorderWidth(width);
        this.refreshBoxSizing();
    }

    @JsAttribute(value={"borderLeftWidth"})
    public void setBorderLeftWidth(float width) {
        this.backgroundHelper.setBorderLeftWidth(width);
        this.refreshBoxSizing();
    }

    @JsAttribute(value={"borderTopWidth"})
    public void setBorderTopWidth(float width) {
        this.backgroundHelper.setBorderTopWidth(width);
        this.refreshBoxSizing();
    }

    @JsAttribute(value={"borderRightWidth"})
    public void setBorderRightWidth(float width) {
        this.backgroundHelper.setBorderRightWidth(width);
        this.refreshBoxSizing();
    }

    @JsAttribute(value={"borderBottomWidth"})
    public void setBorderBottomWidth(float width) {
        this.backgroundHelper.setBorderBottomWidth(width);
        this.refreshBoxSizing();
    }

    @JsAttribute(value={"borderColor"})
    public void setBorderColor(int color) {
        this.backgroundHelper.setBorderColor(color);
    }

    @JsAttribute(value={"borderLeftColor"})
    public void setBorderLeftColor(int color) {
        this.backgroundHelper.setBorderLeftColor(color);
    }

    @JsAttribute(value={"borderTopColor"})
    public void setBorderTopColor(int color) {
        this.backgroundHelper.setBorderTopColor(color);
    }

    @JsAttribute(value={"borderRightColor"})
    public void setBorderRightColor(int color) {
        this.backgroundHelper.setBorderRightColor(color);
    }

    @JsAttribute(value={"borderBottomColor"})
    public void setBorderBottomColor(int color) {
        this.backgroundHelper.setBorderBottomColor(color);
    }

    @JsAttribute(value={"borderRadius"})
    public void setBorderRadius(Object radius) {
        if (HummerStyleUtils.isPercentValue(radius)) {
            this.backgroundHelper.setBorderRadiusPercent(HummerStyleUtils.toPercent(radius));
        } else if (radius instanceof Float) {
            this.backgroundHelper.setBorderRadius(((Float)radius).floatValue());
        }
    }

    @JsAttribute(value={"borderTopLeftRadius"})
    public void setBorderTopLeftRadius(Object radius) {
        if (HummerStyleUtils.isPercentValue(radius)) {
            this.backgroundHelper.setBorderTopLeftRadiusPercent(HummerStyleUtils.toPercent(radius));
        } else if (radius instanceof Float) {
            this.backgroundHelper.setBorderTopLeftRadius(((Float)radius).floatValue());
        }
    }

    @JsAttribute(value={"borderTopRightRadius"})
    public void setBorderTopRightRadius(Object radius) {
        if (HummerStyleUtils.isPercentValue(radius)) {
            this.backgroundHelper.setBorderTopRightRadiusPercent(HummerStyleUtils.toPercent(radius));
        } else if (radius instanceof Float) {
            this.backgroundHelper.setBorderTopRightRadius(((Float)radius).floatValue());
        }
    }

    @JsAttribute(value={"borderBottomRightRadius"})
    public void setBorderBottomRightRadius(Object radius) {
        if (HummerStyleUtils.isPercentValue(radius)) {
            this.backgroundHelper.setBorderBottomRightRadiusPercent(HummerStyleUtils.toPercent(radius));
        } else if (radius instanceof Float) {
            this.backgroundHelper.setBorderBottomRightRadius(((Float)radius).floatValue());
        }
    }

    @JsAttribute(value={"borderBottomLeftRadius"})
    public void setBorderBottomLeftRadius(Object radius) {
        if (HummerStyleUtils.isPercentValue(radius)) {
            this.backgroundHelper.setBorderBottomLeftRadiusPercent(HummerStyleUtils.toPercent(radius));
        } else if (radius instanceof Float) {
            this.backgroundHelper.setBorderBottomLeftRadius(((Float)radius).floatValue());
        }
    }

    @JsAttribute(value={"boxSizing"})
    public void setBoxSizing(String boxSizing) {
        this.boxSizing = boxSizing.toLowerCase();
        this.refreshBoxSizing();
    }

    @JsAttribute(value={"shadow"})
    public void setShadow(String shadow) {
        if (TextUtils.isEmpty((CharSequence)shadow)) {
            return;
        }
        String[] parts = shadow.split(" ");
        if (parts.length != 4) {
            return;
        }
        float[] values = new float[3];
        for (int i = 0; i < 3; ++i) {
            values[i] = HummerStyleUtils.convertNumber(parts[i]);
        }
        int color = YogaAttrUtils.parseColor(parts[3]);
        this.backgroundHelper.setShadow(values[2], values[0], values[1], color);
    }

    @JsAttribute(value={"opacity"})
    public void setOpacity(float opacity) {
        this.getView().setAlpha(opacity);
    }

    @JsAttribute(value={"zIndex"})
    public void setZIndex(int zIndex) {
        ViewCompat.setElevation(this.getView(), (float)zIndex);
    }

    public HummerLayoutExtendUtils.Position getPosition() {
        return this.position;
    }

    public HummerLayoutExtendUtils.Display getDisplay() {
        return this.display;
    }

    public void setInlineBox(InlineBox hmBase) {
        this.inlineBox = hmBase;
    }

    public InlineBox getInlineBox() {
        return this.inlineBox;
    }

    public void setPositionChangedListener(PositionChangedListener listener) {
        this.positionChangedListener = listener;
    }

    public void setDisplayChangedListener(DisplayChangedListener listener) {
        this.displayChangedListener = listener;
    }

    public Context getContext() {
        return this.context;
    }

    public boolean setStyle(String key, Object value) {
        return false;
    }

    public final boolean setHummerStyle(String key, Object value) {
        if (TextUtils.isEmpty((CharSequence)key) || value == null) {
            return false;
        }
        if (this.setStyle(key, value)) {
            return true;
        }
        switch (key) {
            case "backgroundColor": {
                this.setBackgroundColor(value);
                break;
            }
            case "backgroundImage": {
                this.setBackgroundImage(String.valueOf(value));
                break;
            }
            case "borderStyle": {
                this.setBorderStyle(String.valueOf(value));
                break;
            }
            case "borderLeftStyle": {
                this.setBorderLeftStyle(String.valueOf(value));
                break;
            }
            case "borderTopStyle": {
                this.setBorderTopStyle(String.valueOf(value));
                break;
            }
            case "borderRightStyle": {
                this.setBorderRightStyle(String.valueOf(value));
                break;
            }
            case "borderBottomStyle": {
                this.setBorderBottomStyle(String.valueOf(value));
                break;
            }
            case "borderWidth": {
                this.setBorderWidth(((Float)value).floatValue());
                break;
            }
            case "borderLeftWidth": {
                this.setBorderLeftWidth(((Float)value).floatValue());
                break;
            }
            case "borderTopWidth": {
                this.setBorderTopWidth(((Float)value).floatValue());
                break;
            }
            case "borderRightWidth": {
                this.setBorderRightWidth(((Float)value).floatValue());
                break;
            }
            case "borderBottomWidth": {
                this.setBorderBottomWidth(((Float)value).floatValue());
                break;
            }
            case "borderColor": {
                this.setBorderColor((Integer)value);
                break;
            }
            case "borderLeftColor": {
                this.setBorderLeftColor((Integer)value);
                break;
            }
            case "borderTopColor": {
                this.setBorderTopColor((Integer)value);
                break;
            }
            case "borderRightColor": {
                this.setBorderRightColor((Integer)value);
                break;
            }
            case "borderBottomColor": {
                this.setBorderBottomColor((Integer)value);
                break;
            }
            case "borderRadius": {
                this.setBorderRadius(value);
                break;
            }
            case "borderTopLeftRadius": {
                this.setBorderTopLeftRadius(value);
                break;
            }
            case "borderTopRightRadius": {
                this.setBorderTopRightRadius(value);
                break;
            }
            case "borderBottomRightRadius": {
                this.setBorderBottomRightRadius(value);
                break;
            }
            case "borderBottomLeftRadius": {
                this.setBorderBottomLeftRadius(value);
                break;
            }
            case "boxSizing": {
                this.setBoxSizing(String.valueOf(value));
                break;
            }
            case "shadow": {
                this.setShadow(String.valueOf(value));
                break;
            }
            case "opacity": {
                this.setOpacity(((Float)value).floatValue());
                break;
            }
            case "visibility": {
                this.setVisibility(String.valueOf(value));
                break;
            }
            case "zIndex": {
                this.setZIndex((int)((Float)value).floatValue());
                break;
            }
            case "position": 
            case "positionType": {
                if (HummerLayoutExtendUtils.Position.FIXED.value().equals(value)) {
                    this.getYogaNode().setPositionType(YogaPositionType.ABSOLUTE);
                }
                return this.setPosition((String)value);
            }
            case "display": {
                if (HummerLayoutExtendUtils.Display.BLOCK.value().equals(value) || HummerLayoutExtendUtils.Display.INLINE.value().equals(value) || HummerLayoutExtendUtils.Display.INLINE_BLOCK.value().equals(value)) {
                    HummerLayoutExtendUtils.markExtendCssView(this);
                }
                HummerLayoutExtendUtils.applyDisplayStyle(this, (String)value);
                return this.setDisplay((String)value);
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void refreshBoxSizing() {
        if (BOX_SIZING_BORDER_BOX.equals(this.boxSizing)) {
            RectF borderWidth = this.backgroundHelper.getBorder().width;
            this.getYogaNode().setBorder(YogaEdge.LEFT, borderWidth.left);
            this.getYogaNode().setBorder(YogaEdge.TOP, borderWidth.top);
            this.getYogaNode().setBorder(YogaEdge.RIGHT, borderWidth.right);
            this.getYogaNode().setBorder(YogaEdge.BOTTOM, borderWidth.bottom);
        } else {
            this.getYogaNode().setBorder(YogaEdge.LEFT, 0.0f);
            this.getYogaNode().setBorder(YogaEdge.TOP, 0.0f);
            this.getYogaNode().setBorder(YogaEdge.RIGHT, 0.0f);
            this.getYogaNode().setBorder(YogaEdge.BOTTOM, 0.0f);
        }
    }

    public final boolean setTransitionStyle(String key, Object value) {
        switch (key) {
            case "transitionDuration": {
                this.setTransitionDuration(value);
                break;
            }
            case "transitionDelay": {
                this.setTransitionDelay(value);
                break;
            }
            case "transitionTimingFunction": {
                this.setTransitionTimingFunction((String)value);
                break;
            }
            case "transitionProperty": {
                this.setTransitionProperty(value);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void setTransitionDuration(Object transitionDuration) {
        this.durationList = new ArrayList<Double>();
        if (transitionDuration instanceof List) {
            for (Object durationObj : (ArrayList)transitionDuration) {
                float duration = HummerStyleUtils.convertNumber(durationObj, false);
                this.durationList.add(Double.valueOf(duration));
            }
        } else if (transitionDuration instanceof String) {
            String[] durationStrList;
            String durationStr = (String)transitionDuration;
            durationStr = durationStr.replace(" ", "");
            for (String duration : durationStrList = durationStr.split(",")) {
                this.durationList.add(Double.valueOf(HummerStyleUtils.convertNumber(duration, false)));
            }
        } else if (transitionDuration instanceof Number) {
            this.durationList.add(Double.valueOf(HummerStyleUtils.convertNumber(transitionDuration, false)));
        }
        if (this.durationList.size() > 0 && this.transitions != null) {
            for (int i = 0; i < this.transitions.size(); ++i) {
                Transition transition = this.transitions.get(i);
                transition.setDuration(this.durationList.get(i % this.durationList.size()));
            }
        }
    }

    public void setTransitionDelay(Object delay) {
        this.transitionDelay = HummerStyleUtils.convertNumber(delay, false);
        if (this.transitions != null) {
            for (int i = 0; i < this.transitions.size(); ++i) {
                Transition transition = this.transitions.get(i);
                transition.setDelay(this.transitionDelay);
            }
        }
    }

    public void setTransitionTimingFunction(String timingFunction) {
        this.transitionTimingFunction = timingFunction;
        if (this.transitions != null) {
            for (int i = 0; i < this.transitions.size(); ++i) {
                Transition transition = this.transitions.get(i);
                transition.setTimingFunction(this.transitionTimingFunction);
            }
        }
    }

    public void setTransitionProperty(Object transitionProperty) {
        block5: {
            ArrayList propertyList;
            block4: {
                this.transitions = new ArrayList<Transition>();
                if (!(transitionProperty instanceof String)) break block4;
                String propertyStr = (String)transitionProperty;
                propertyStr = propertyStr.replace(" ", "");
                String[] propertyStrList = propertyStr.split(",");
                for (int i = 0; i < propertyStrList.length; ++i) {
                    String property = propertyStrList[i];
                    Transition transition = new Transition(property);
                    transition.setDelay(this.transitionDelay);
                    transition.setTimingFunction(this.transitionTimingFunction);
                    if (this.durationList.size() > 0) {
                        transition.setDuration(this.durationList.get(i % this.durationList.size()));
                    }
                    this.transitions.add(transition);
                }
                break block5;
            }
            if (!(transitionProperty instanceof List) || (propertyList = (ArrayList)transitionProperty).isEmpty()) break block5;
            for (int i = 0; i < propertyList.size(); ++i) {
                String property = (String)propertyList.get(i);
                Transition transition = new Transition(property);
                transition.setDelay(this.transitionDelay);
                transition.setTimingFunction(this.transitionTimingFunction);
                if (this.durationList.size() > 0) {
                    transition.setDuration(this.durationList.get(i % this.durationList.size()));
                }
                this.transitions.add(transition);
            }
        }
    }

    public Transition getTransition(String property) {
        Transition result = null;
        for (Transition transition : this.transitions) {
            if (property.equals(transition.getProperty())) {
                result = transition;
                continue;
            }
            if (!"all".equals(transition.getProperty())) continue;
            result = transition;
            break;
        }
        if ("transform".equals(property) && result == null) {
            result = new Transition(property);
        }
        return result;
    }

    public boolean supportTransitionStyle(String style) {
        for (Transition transition : this.transitions) {
            if (!style.equals(transition.getProperty())) continue;
            return true;
        }
        return false;
    }

    private boolean setPosition(String value) {
        HummerLayoutExtendUtils.Position resultPosition = HummerLayoutExtendUtils.Position.YOGA;
        if (HummerLayoutExtendUtils.Position.FIXED.value().equals(value)) {
            resultPosition = HummerLayoutExtendUtils.Position.FIXED;
        }
        if (resultPosition != this.position && this.positionChangedListener != null) {
            this.positionChangedListener.dispatchChildPositionChanged(this, this.position, resultPosition);
        }
        this.position = resultPosition;
        return resultPosition != HummerLayoutExtendUtils.Position.YOGA;
    }

    private boolean setDisplay(String value) {
        HummerLayoutExtendUtils.Display resultDisplay = HummerLayoutExtendUtils.Display.YOGA;
        if (HummerLayoutExtendUtils.Display.BLOCK.value().equals(value)) {
            resultDisplay = HummerLayoutExtendUtils.Display.BLOCK;
        }
        if (HummerLayoutExtendUtils.Display.INLINE.value().equals(value)) {
            resultDisplay = HummerLayoutExtendUtils.Display.INLINE;
        }
        if (HummerLayoutExtendUtils.Display.INLINE_BLOCK.value().equals(value)) {
            resultDisplay = HummerLayoutExtendUtils.Display.INLINE_BLOCK;
        }
        if (resultDisplay != this.display && this.displayChangedListener != null) {
            this.displayChangedListener.dispatchChildDisplayChanged(this, this.display, resultDisplay);
        }
        this.display = resultDisplay;
        return resultDisplay != HummerLayoutExtendUtils.Display.YOGA;
    }

    public void handleTransitionStyle(String key, Object value) {
        ArrayList<PropertyValuesHolder> propertyValuesHolderList = new ArrayList<PropertyValuesHolder>();
        if ("transform".equals(key)) {
            String transformStr = value.toString().trim();
            transformStr = transformStr.replace("),", ");");
            String[] transformProperty = transformStr.split(";");
            for (int i = 0; i < transformProperty.length; ++i) {
                String property = transformProperty[i];
                int leftIndex = property.indexOf("(");
                int rightIndex = property.indexOf(")");
                String animType = property.substring(0, leftIndex).trim();
                Object params = HummerStyleUtils.transformValue(property.substring(leftIndex + 1, rightIndex));
                propertyValuesHolderList.addAll(HummerAnimationUtils.parser(animType, params));
            }
        } else {
            propertyValuesHolderList.addAll(HummerAnimationUtils.parser(key, value));
        }
        ObjectAnimator anim = ObjectAnimator.ofPropertyValuesHolder((Object)new AnimViewWrapper(this), (PropertyValuesHolder[])propertyValuesHolderList.toArray(new PropertyValuesHolder[propertyValuesHolderList.size()]));
        this.getTransition(key).warpAnim(anim);
        if (this.objectAnimatorList == null) {
            this.objectAnimatorList = new ArrayList<ObjectAnimator>();
        }
        this.objectAnimatorList.add(anim);
    }

    public void runAnimator() {
        if (this.objectAnimatorList != null) {
            this.getView().post(new Runnable(){

                @Override
                public void run() {
                    for (ObjectAnimator objectAnimator : HMBase.this.objectAnimatorList) {
                        objectAnimator.start();
                    }
                    HMBase.this.objectAnimatorList.clear();
                }
            });
        }
    }

    public static interface DisplayChangedListener {
        public void dispatchChildDisplayChanged(HMBase var1, HummerLayoutExtendUtils.Display var2, HummerLayoutExtendUtils.Display var3);
    }

    public static interface PositionChangedListener {
        public void dispatchChildPositionChanged(HMBase var1, HummerLayoutExtendUtils.Position var2, HummerLayoutExtendUtils.Position var3);
    }
}

