/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.render.component.view;

import android.content.Context;
import android.os.Looper;
import android.text.TextUtils;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.event.EventManager;
import com.didi.hummer.render.event.base.TraceEvent;
import com.didi.hummer.render.event.guesture.LongPressEvent;
import com.didi.hummer.render.event.guesture.PanEvent;
import com.didi.hummer.render.event.guesture.PinchEvent;
import com.didi.hummer.render.event.guesture.SwipeEvent;
import com.didi.hummer.render.event.guesture.TapEvent;
import com.didi.hummer.render.event.guesture.TouchEvent;
import com.didi.hummer.render.event.guesture.common.GestureUtils;
import com.didi.hummer.tools.EventTracer;
import java.util.Map;

class HMGestureEventDetector {
    private Context context;
    private HummerContext hummerContext;
    private View view;
    private String viewId;
    private EventManager eventManager;
    private GestureDetector mGestureDetector;
    private ScaleGestureDetector mScaleGestureDetector;
    private MotionEvent latestMotionEvent;

    public HMGestureEventDetector(HMBase base) {
        if (base == null || base.getView() == null) {
            return;
        }
        this.hummerContext = (HummerContext)base.getContext();
        this.eventManager = base.getEventManager();
        this.view = base.getView();
        this.viewId = base.getViewID();
        this.context = this.view.getContext();
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            this.init();
        } else {
            this.view.post(this::init);
        }
    }

    private void init() {
        this.mGestureDetector = new GestureDetector(this.context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                if (HMGestureEventDetector.this.eventManager.contains("swipe")) {
                    SwipeEvent event = HMGestureEventDetector.this.makeSwipeEvent(e2);
                    float minMove = 120.0f;
                    float minVelocity = 0.0f;
                    float beginX = e1.getX();
                    float endX = e2.getX();
                    float beginY = e1.getY();
                    float endY = e2.getY();
                    if (beginX - endX > minMove && Math.abs(velocityX) > minVelocity) {
                        event.setDirection(2);
                    } else if (endX - beginX > minMove && Math.abs(velocityX) > minVelocity) {
                        event.setDirection(1);
                    } else if (beginY - endY > minMove && Math.abs(velocityY) > minVelocity) {
                        event.setDirection(4);
                    } else if (endY - beginY > minMove && Math.abs(velocityY) > minVelocity) {
                        event.setDirection(8);
                    }
                    HMGestureEventDetector.this.eventManager.dispatchEvent("swipe", event);
                    return true;
                }
                return false;
            }
        });
        this.mScaleGestureDetector = new ScaleGestureDetector(this.context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleGestureDetector.SimpleOnScaleGestureListener(){

            public boolean onScale(ScaleGestureDetector detector) {
                if (HMGestureEventDetector.this.eventManager.contains("pinch")) {
                    float scale = Math.max(0.1f, Math.min(detector.getScaleFactor(), 5.0f));
                    PinchEvent event = HMGestureEventDetector.this.makePinchEvent(HMGestureEventDetector.this.latestMotionEvent);
                    event.setScale(scale);
                    HMGestureEventDetector.this.eventManager.dispatchEvent("pinch", event);
                    return true;
                }
                return false;
            }
        });
        View.OnTouchListener touchListener = new View.OnTouchListener(){
            private float downX = 0.0f;
            private float downY = 0.0f;

            public boolean onTouch(View v, MotionEvent event) {
                boolean isClickable;
                Map<String, Object> params = TraceEvent.makeTraceGestureEvent("touch", HMGestureEventDetector.this.view, HMGestureEventDetector.this.viewId);
                EventTracer.traceEvent(HMGestureEventDetector.this.hummerContext.getNamespace(), "hummer_sdk_trace_event", params);
                TouchEvent touchEvent = null;
                if (HMGestureEventDetector.this.eventManager.contains("touch")) {
                    touchEvent = HMGestureEventDetector.this.makeTouchEvent(v.getContext(), event);
                }
                PanEvent panEvent = null;
                if (HMGestureEventDetector.this.eventManager.contains("pan")) {
                    panEvent = HMGestureEventDetector.this.makePanEvent(event);
                }
                switch (event.getAction()) {
                    case 0: {
                        HMGestureEventDetector.this.latestMotionEvent = MotionEvent.obtain((MotionEvent)event);
                        if (panEvent == null) break;
                        this.downX = event.getRawX();
                        this.downY = event.getRawY();
                        break;
                    }
                    case 2: {
                        if (panEvent == null) break;
                        float moveX = event.getRawX();
                        float moveY = event.getRawY();
                        panEvent.setTranslation(GestureUtils.findTranslationInMotionEvent(HMGestureEventDetector.this.context, moveX - this.downX, moveY - this.downY));
                        this.downX = moveX;
                        this.downY = moveY;
                        break;
                    }
                    default: {
                        HMGestureEventDetector.this.latestMotionEvent = MotionEvent.obtain((MotionEvent)event);
                    }
                }
                boolean isTouchConsumed = false;
                if (touchEvent != null) {
                    isTouchConsumed = true;
                    HMGestureEventDetector.this.eventManager.dispatchEvent("touch", touchEvent);
                }
                if (panEvent != null) {
                    isTouchConsumed = true;
                    HMGestureEventDetector.this.eventManager.dispatchEvent("pan", panEvent);
                }
                boolean bl = isClickable = HMGestureEventDetector.this.eventManager.contains("tap") || HMGestureEventDetector.this.eventManager.contains("longPress");
                if (isClickable) {
                    return false;
                }
                if (HMGestureEventDetector.this.eventManager.contains("swipe")) {
                    HMGestureEventDetector.this.mGestureDetector.onTouchEvent(event);
                    isTouchConsumed = true;
                }
                if (HMGestureEventDetector.this.eventManager.contains("pinch")) {
                    HMGestureEventDetector.this.mScaleGestureDetector.onTouchEvent(event);
                    isTouchConsumed = true;
                }
                return isTouchConsumed;
            }
        };
        this.view.setOnTouchListener(touchListener);
    }

    public void initClickListener(String eventName) {
        if (this.hummerContext == null || this.eventManager == null || this.view == null || TextUtils.isEmpty((CharSequence)eventName)) {
            return;
        }
        if (eventName.equals("tap")) {
            this.view.setOnClickListener(v -> {
                Map<String, Object> params = TraceEvent.makeTraceGestureEvent("tap", this.view, this.viewId);
                EventTracer.traceEvent(this.hummerContext.getNamespace(), "hummer_sdk_trace_event", params);
                if (this.eventManager.contains("tap")) {
                    TapEvent event = this.makeTapEvent(this.view.getContext(), this.latestMotionEvent);
                    this.eventManager.dispatchEvent("tap", event);
                }
            });
        }
        if (eventName.equals("longPress")) {
            this.view.setOnLongClickListener(v -> {
                Map<String, Object> params = TraceEvent.makeTraceGestureEvent("longPress", this.view, this.viewId);
                EventTracer.traceEvent(this.hummerContext.getNamespace(), "hummer_sdk_trace_event", params);
                if (this.eventManager.contains("longPress")) {
                    LongPressEvent event = this.makeLongPressEvent(this.view.getContext(), this.latestMotionEvent);
                    this.eventManager.dispatchEvent("longPress", event);
                }
                return true;
            });
        }
    }

    private TouchEvent makeTouchEvent(Context context, MotionEvent event) {
        TouchEvent e = new TouchEvent();
        e.setTimestamp(System.currentTimeMillis());
        e.setType("touch");
        e.setState(GestureUtils.findStateInMotionEvent(event));
        e.setPosition(GestureUtils.findPositionInMotionEvent(context, event));
        return e;
    }

    private PanEvent makePanEvent(MotionEvent event) {
        PanEvent e = new PanEvent();
        e.setTimestamp(System.currentTimeMillis());
        e.setType("pan");
        e.setState(GestureUtils.findStateInMotionEvent(event));
        return e;
    }

    private SwipeEvent makeSwipeEvent(MotionEvent event) {
        SwipeEvent e = new SwipeEvent();
        e.setTimestamp(System.currentTimeMillis());
        e.setType("swipe");
        e.setState(GestureUtils.findStateInMotionEvent(event));
        return e;
    }

    private PinchEvent makePinchEvent(MotionEvent event) {
        PinchEvent e = new PinchEvent();
        e.setTimestamp(System.currentTimeMillis());
        e.setType("pinch");
        e.setState(GestureUtils.findStateInMotionEvent(event));
        return e;
    }

    private TapEvent makeTapEvent(Context context, MotionEvent event) {
        TapEvent e = new TapEvent();
        e.setTimestamp(System.currentTimeMillis());
        e.setType("tap");
        e.setState(GestureUtils.findStateInMotionEvent(event));
        e.setPosition(GestureUtils.findPositionInMotionEvent(context, event));
        return e;
    }

    private LongPressEvent makeLongPressEvent(Context context, MotionEvent event) {
        LongPressEvent e = new LongPressEvent();
        e.setTimestamp(System.currentTimeMillis());
        e.setType("longPress");
        e.setState(GestureUtils.findStateInMotionEvent(event));
        e.setPosition(GestureUtils.findPositionInMotionEvent(context, event));
        return e;
    }
}

