/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.render.component.view;

import android.content.Context;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSValue;
import com.didi.hummer.render.component.view.FixedNoneBox;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.component.view.InlineBox;
import com.didi.hummer.render.style.HummerLayout;
import com.didi.hummer.render.style.HummerLayoutExtendUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class HummerLayoutExtendView
extends HMBase<HummerLayout>
implements HMBase.PositionChangedListener,
HMBase.DisplayChangedListener {
    private HummerContext hummerContext;
    private List<InlineBox> inlineBoxes = new ArrayList<InlineBox>();
    private Map<HMBase, FixedNoneBox> fixedNoneBoxMap = new HashMap<HMBase, FixedNoneBox>();
    private List<HMBase> children = new LinkedList<HMBase>();

    public HummerLayoutExtendView(HummerContext context, JSValue jsValue, String viewID) {
        super(context, jsValue, viewID);
        this.hummerContext = context;
    }

    @Override
    protected HummerLayout createViewInstance(Context context) {
        return new HummerLayout(context);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        ((HummerLayout)((Object)this.getView())).setCornerRadiiGetter(() -> this.backgroundHelper.getBorderRadii());
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        ((HummerLayout)((Object)this.getView())).post(() -> {
            if (!this.children.isEmpty()) {
                for (HMBase child : this.children) {
                    if (child == null || child.getJSValue() == null) continue;
                    child.getJSValue().unprotect();
                }
                this.children.clear();
            }
        });
    }

    public void appendChild(HMBase child) {
        if (child == null) {
            return;
        }
        child.getJSValue().protect();
        child.setPositionChangedListener(this);
        child.setDisplayChangedListener(this);
        this.children.add(child);
        HMBase finalChild = child;
        if (child.getPosition() == HummerLayoutExtendUtils.Position.FIXED) {
            this.hummerContext.getContainer().addView(child);
            FixedNoneBox fixedNoneBox = new FixedNoneBox(this.hummerContext);
            this.fixedNoneBoxMap.put(child, fixedNoneBox);
            finalChild = fixedNoneBox;
        }
        if (this.getDisplay() == HummerLayoutExtendUtils.Display.BLOCK) {
            HummerLayoutExtendUtils.markExtendCssView(child);
            if (child.getDisplay() == HummerLayoutExtendUtils.Display.INLINE || child.getDisplay() == HummerLayoutExtendUtils.Display.INLINE_BLOCK) {
                HMBase lastChild = ((HummerLayout)((Object)this.getView())).getLastChild();
                if (lastChild instanceof InlineBox) {
                    child.setInlineBox((InlineBox)lastChild);
                    ((InlineBox)lastChild).add(child);
                    finalChild = null;
                } else {
                    InlineBox box = new InlineBox(this.hummerContext);
                    child.setInlineBox(box);
                    box.add(child);
                    this.inlineBoxes.add(box);
                    finalChild = box;
                }
            }
        }
        if (HummerLayoutExtendUtils.isExtendCssView(child)) {
            HummerLayoutExtendUtils.applyChildDisplayStyle(this.getDisplay().value(), child);
        }
        if (finalChild != null) {
            ((HummerLayout)((Object)this.getView())).addView(finalChild);
        }
    }

    public void removeChild(HMBase child) {
        if (child == null) {
            return;
        }
        child.getJSValue().unprotect();
        child.setPositionChangedListener(null);
        child.setDisplayChangedListener(null);
        this.children.remove(child);
        if (child.getInlineBox() != null) {
            InlineBox inlineBox = child.getInlineBox();
            inlineBox.remove(child);
            if (inlineBox.isChildrenEmpty()) {
                this.inlineBoxes.remove(inlineBox);
                ((HummerLayout)((Object)this.getView())).removeView(inlineBox);
            }
            return;
        }
        if (this.fixedNoneBoxMap.containsKey(child)) {
            FixedNoneBox noneBox = this.fixedNoneBoxMap.remove(child);
            this.hummerContext.getContainer().removeView(child);
            ((HummerLayout)((Object)this.getView())).removeView(noneBox);
            return;
        }
        ((HummerLayout)((Object)this.getView())).removeView(child);
        if (this.getDisplay() == HummerLayoutExtendUtils.Display.BLOCK) {
            this.mergeInlineBox();
        }
    }

    public void removeAll() {
        this.inlineBoxes.clear();
        for (Map.Entry<HMBase, FixedNoneBox> entry : this.fixedNoneBoxMap.entrySet()) {
            HMBase hmBase = entry.getKey();
            FixedNoneBox noneBox = entry.getValue();
            this.hummerContext.getContainer().removeView(hmBase);
            ((HummerLayout)((Object)this.getView())).removeView(noneBox);
        }
        this.fixedNoneBoxMap.clear();
        for (HMBase hmBase : this.children) {
            hmBase.getJSValue().unprotect();
            hmBase.setPositionChangedListener(null);
            hmBase.setDisplayChangedListener(null);
        }
        this.children.clear();
        ((HummerLayout)((Object)this.getView())).removeAllViews();
    }

    public void insertBefore(HMBase child, HMBase existing) {
        if (child == null || existing == null) {
            return;
        }
        child.getJSValue().protect();
        child.setPositionChangedListener(this);
        child.setDisplayChangedListener(this);
        this.children.add(child);
        HMBase finalChild = child;
        HMBase finalExisting = existing;
        if (child.getPosition() == HummerLayoutExtendUtils.Position.FIXED) {
            this.hummerContext.getContainer().addView(child);
            FixedNoneBox fixedNoneBox = new FixedNoneBox(this.hummerContext);
            this.fixedNoneBoxMap.put(child, fixedNoneBox);
            finalChild = fixedNoneBox;
        }
        if (this.fixedNoneBoxMap.containsKey(existing)) {
            finalExisting = this.fixedNoneBoxMap.get(existing);
        }
        if (this.getDisplay() == HummerLayoutExtendUtils.Display.BLOCK) {
            HummerLayoutExtendUtils.markExtendCssView(child);
            if (child.getDisplay() == HummerLayoutExtendUtils.Display.INLINE || child.getDisplay() == HummerLayoutExtendUtils.Display.INLINE_BLOCK) {
                if (existing.getInlineBox() != null) {
                    child.setInlineBox(existing.getInlineBox());
                    existing.getInlineBox().insertBefore(child, existing);
                    finalChild = null;
                } else {
                    InlineBox box = new InlineBox(this.hummerContext);
                    child.setInlineBox(box);
                    box.add(child);
                    this.inlineBoxes.add(box);
                    finalChild = box;
                }
            }
        }
        if (this.getDisplay() == HummerLayoutExtendUtils.Display.BLOCK && child.getDisplay() != HummerLayoutExtendUtils.Display.INLINE && child.getDisplay() != HummerLayoutExtendUtils.Display.INLINE_BLOCK && existing.getInlineBox() != null) {
            InlineBox oldInlineBox = existing.getInlineBox();
            int indexM = oldInlineBox.getChildren().indexOf(existing);
            InlineBox inlineBox1 = new InlineBox(this.hummerContext);
            InlineBox inlineBox2 = new InlineBox(this.hummerContext);
            int index = 0;
            while (!oldInlineBox.isChildrenEmpty()) {
                HMBase hmBase = oldInlineBox.getChildren().get(0);
                if (index < indexM) {
                    oldInlineBox.remove(hmBase);
                    inlineBox1.add(hmBase);
                    hmBase.setInlineBox(inlineBox1);
                } else {
                    oldInlineBox.remove(hmBase);
                    inlineBox2.add(hmBase);
                    hmBase.setInlineBox(inlineBox2);
                }
                ++index;
            }
            int oldIndex = this.getYogaNode().indexOf(oldInlineBox.getYogaNode());
            ((HummerLayout)((Object)this.getView())).removeView(oldInlineBox);
            ((HummerLayout)((Object)this.getView())).addView(inlineBox2, oldIndex);
            ((HummerLayout)((Object)this.getView())).addView(inlineBox1, oldIndex);
            this.inlineBoxes.add(inlineBox1);
            this.inlineBoxes.add(inlineBox2);
            finalExisting = inlineBox2;
        }
        if (HummerLayoutExtendUtils.isExtendCssView(child)) {
            HummerLayoutExtendUtils.applyChildDisplayStyle(this.getDisplay().value(), child);
        }
        if (finalChild != null) {
            ((HummerLayout)((Object)this.getView())).insertBefore(finalChild, finalExisting);
        }
        if (this.getDisplay() == HummerLayoutExtendUtils.Display.BLOCK) {
            this.mergeInlineBox();
        }
    }

    public void replaceChild(HMBase child, HMBase old) {
        if (child == null || old == null) {
            return;
        }
        child.getJSValue().protect();
        child.setPositionChangedListener(this);
        child.setDisplayChangedListener(this);
        old.getJSValue().unprotect();
        old.setPositionChangedListener(null);
        old.setDisplayChangedListener(null);
        this.children.add(child);
        this.children.remove(old);
        HMBase finalChild = child;
        HMBase finalOld = old;
        if (child.getPosition() == HummerLayoutExtendUtils.Position.FIXED) {
            this.hummerContext.getContainer().addView(child);
            FixedNoneBox fixedNoneBox = new FixedNoneBox(this.hummerContext);
            this.fixedNoneBoxMap.put(child, fixedNoneBox);
            finalChild = fixedNoneBox;
        }
        if (this.fixedNoneBoxMap.containsKey(old)) {
            this.hummerContext.getContainer().removeView(old);
            finalOld = this.fixedNoneBoxMap.get(old);
        }
        if (this.getDisplay() == HummerLayoutExtendUtils.Display.BLOCK) {
            HummerLayoutExtendUtils.markExtendCssView(child);
            if (child.getDisplay() == HummerLayoutExtendUtils.Display.INLINE || child.getDisplay() == HummerLayoutExtendUtils.Display.INLINE_BLOCK) {
                if (old.getInlineBox() != null) {
                    child.setInlineBox(old.getInlineBox());
                    old.getInlineBox().replace(child, old);
                    finalChild = null;
                } else {
                    InlineBox box = new InlineBox(this.hummerContext);
                    child.setInlineBox(box);
                    box.add(child);
                    this.inlineBoxes.add(box);
                    finalChild = box;
                }
            }
        }
        if (child.getDisplay() != HummerLayoutExtendUtils.Display.INLINE && child.getDisplay() != HummerLayoutExtendUtils.Display.INLINE_BLOCK && old.getInlineBox() != null) {
            InlineBox oldInlineBox = old.getInlineBox();
            int indexM = oldInlineBox.getChildren().indexOf(old);
            InlineBox inlineBox1 = new InlineBox(this.hummerContext);
            InlineBox inlineBox2 = new InlineBox(this.hummerContext);
            int index = 0;
            while (!oldInlineBox.isChildrenEmpty()) {
                HMBase hmBase = oldInlineBox.getChildren().get(0);
                if (index < indexM) {
                    oldInlineBox.remove(hmBase);
                    inlineBox1.add(hmBase);
                    hmBase.setInlineBox(inlineBox1);
                } else if (index > indexM) {
                    oldInlineBox.remove(hmBase);
                    inlineBox2.add(hmBase);
                    hmBase.setInlineBox(inlineBox2);
                } else {
                    oldInlineBox.remove(hmBase);
                }
                ++index;
            }
            int oldIndex = this.getYogaNode().indexOf(oldInlineBox.getYogaNode());
            ((HummerLayout)((Object)this.getView())).removeView(oldInlineBox);
            ((HummerLayout)((Object)this.getView())).addView(inlineBox2, oldIndex);
            ((HummerLayout)((Object)this.getView())).addView(old, oldIndex);
            ((HummerLayout)((Object)this.getView())).addView(inlineBox1, oldIndex);
            this.inlineBoxes.add(inlineBox1);
            this.inlineBoxes.add(inlineBox2);
            finalOld = old;
        }
        if (HummerLayoutExtendUtils.isExtendCssView(child)) {
            HummerLayoutExtendUtils.applyChildDisplayStyle(this.getDisplay().value(), child);
        }
        if (finalChild != null) {
            ((HummerLayout)((Object)this.getView())).replaceView(finalChild, finalOld);
        }
        if (this.getDisplay() == HummerLayoutExtendUtils.Display.BLOCK) {
            this.mergeInlineBox();
        }
    }

    public HMBase getElementById(String viewID) {
        HMBase result = ((HummerLayout)((Object)this.getView())).getViewById(viewID);
        if (result == null) {
            InlineBox inlineBox;
            Iterator<Object> iterator = this.inlineBoxes.iterator();
            while (iterator.hasNext() && (result = (inlineBox = (InlineBox)iterator.next()).getSubview(viewID)) == null) {
            }
        }
        if (result == null) {
            for (Map.Entry entry : this.fixedNoneBoxMap.entrySet()) {
                HMBase hmBase = (HMBase)entry.getKey();
                if (!hmBase.getViewID().equals(viewID)) continue;
                result = hmBase;
                break;
            }
        }
        if (result != null) {
            result.getJSValue().protect();
        }
        return result;
    }

    @Override
    public void dispatchChildPositionChanged(HMBase child, HummerLayoutExtendUtils.Position origin, HummerLayoutExtendUtils.Position replace) {
        FixedNoneBox fixedNoneBox;
        if (origin == HummerLayoutExtendUtils.Position.FIXED && replace == HummerLayoutExtendUtils.Position.YOGA && this.fixedNoneBoxMap.containsKey(child)) {
            fixedNoneBox = this.fixedNoneBoxMap.remove(child);
            this.hummerContext.getContainer().removeView(child);
            ((HummerLayout)((Object)this.getView())).replaceView(child, fixedNoneBox);
        }
        if (origin == HummerLayoutExtendUtils.Position.YOGA && replace == HummerLayoutExtendUtils.Position.FIXED) {
            fixedNoneBox = new FixedNoneBox(this.hummerContext);
            this.fixedNoneBoxMap.put(child, fixedNoneBox);
            ((HummerLayout)((Object)this.getView())).replaceView(fixedNoneBox, child);
            this.hummerContext.getContainer().addView(child);
        }
        if (this.getDisplay() == HummerLayoutExtendUtils.Display.BLOCK) {
            this.mergeInlineBox();
        }
    }

    @Override
    public void dispatchChildDisplayChanged(HMBase child, HummerLayoutExtendUtils.Display origin, HummerLayoutExtendUtils.Display replace) {
        if (this.getDisplay() == HummerLayoutExtendUtils.Display.BLOCK) {
            if (!(origin != HummerLayoutExtendUtils.Display.BLOCK && origin != HummerLayoutExtendUtils.Display.YOGA || replace != HummerLayoutExtendUtils.Display.INLINE && replace != HummerLayoutExtendUtils.Display.INLINE_BLOCK)) {
                InlineBox box = new InlineBox(this.hummerContext);
                this.inlineBoxes.add(box);
                ((HummerLayout)((Object)this.getView())).replaceView(box, child);
                child.setInlineBox(box);
                box.add(child);
            } else if (!(origin != HummerLayoutExtendUtils.Display.INLINE && origin != HummerLayoutExtendUtils.Display.INLINE_BLOCK || replace != HummerLayoutExtendUtils.Display.BLOCK && replace != HummerLayoutExtendUtils.Display.YOGA || child.getInlineBox() == null)) {
                InlineBox inlineBox0 = child.getInlineBox();
                int indexM = inlineBox0.getChildren().indexOf(child);
                InlineBox inlineBox1 = new InlineBox(this.hummerContext);
                InlineBox inlineBox2 = new InlineBox(this.hummerContext);
                int index = 0;
                while (!inlineBox0.isChildrenEmpty()) {
                    HMBase hmBase = inlineBox0.getChildren().get(0);
                    if (index < indexM) {
                        inlineBox0.remove(hmBase);
                        inlineBox1.add(hmBase);
                        hmBase.setInlineBox(inlineBox1);
                    } else if (index > indexM) {
                        inlineBox0.remove(hmBase);
                        inlineBox2.add(hmBase);
                        hmBase.setInlineBox(inlineBox2);
                    } else {
                        inlineBox0.remove(hmBase);
                    }
                    ++index;
                }
                int oldIndex = this.getYogaNode().indexOf(inlineBox0.getYogaNode());
                ((HummerLayout)((Object)this.getView())).removeView(inlineBox0);
                ((HummerLayout)((Object)this.getView())).addView(inlineBox2, oldIndex);
                ((HummerLayout)((Object)this.getView())).addView(child, oldIndex);
                ((HummerLayout)((Object)this.getView())).addView(inlineBox1, oldIndex);
                this.inlineBoxes.add(inlineBox1);
                this.inlineBoxes.add(inlineBox2);
            }
        }
        if (this.getDisplay() == HummerLayoutExtendUtils.Display.BLOCK) {
            this.mergeInlineBox();
        }
    }

    public List<HMBase> getChildren() {
        return this.children;
    }

    private void mergeInlineBox() {
        Collections.sort(this.inlineBoxes, new Comparator<InlineBox>(){

            @Override
            public int compare(InlineBox o1, InlineBox o2) {
                int i1 = HummerLayoutExtendView.this.getYogaNode().indexOf(o1.getYogaNode());
                int i2 = HummerLayoutExtendView.this.getYogaNode().indexOf(o2.getYogaNode());
                return i1 - i2;
            }
        });
        Iterator<InlineBox> it = this.inlineBoxes.iterator();
        while (it.hasNext()) {
            InlineBox box = it.next();
            if (!box.isChildrenEmpty()) continue;
            ((HummerLayout)((Object)this.getView())).removeView(box);
            it.remove();
        }
        ArrayList mergeInlineBoxes = new ArrayList();
        ArrayList<InlineBox> curMergeInlineBox = new ArrayList<InlineBox>();
        mergeInlineBoxes.add(curMergeInlineBox);
        int preIndex = 0x3FFFFFFF;
        for (InlineBox box : this.inlineBoxes) {
            int curIndex = this.getYogaNode().indexOf(box.getYogaNode());
            if (curIndex - preIndex == 1) {
                curMergeInlineBox.add(box);
            } else {
                curMergeInlineBox = new ArrayList();
                mergeInlineBoxes.add(curMergeInlineBox);
                curMergeInlineBox.add(box);
            }
            preIndex = curIndex;
        }
        for (List list : mergeInlineBoxes) {
            if (list.size() < 2) continue;
            InlineBox mergeInlineBox = new InlineBox(this.hummerContext);
            this.inlineBoxes.add(mergeInlineBox);
            for (int i = 0; i < list.size(); ++i) {
                InlineBox inlineBox = (InlineBox)list.get(i);
                if (i == 0) {
                    ((HummerLayout)((Object)this.getView())).insertBefore(mergeInlineBox, inlineBox);
                }
                while (!inlineBox.isChildrenEmpty()) {
                    HMBase child = inlineBox.getChildren().get(0);
                    inlineBox.remove(child);
                    mergeInlineBox.add(child);
                    child.setInlineBox(mergeInlineBox);
                }
                this.inlineBoxes.remove(inlineBox);
                ((HummerLayout)((Object)this.getView())).removeView(inlineBox);
            }
        }
    }
}

