/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.render.component.view;

import android.content.Context;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.style.HummerLayout;
import com.facebook.yoga.YogaFlexDirection;
import java.util.ArrayList;
import java.util.List;

public class InlineBox
extends HMBase<HummerLayout> {
    private List<HMBase> children = new ArrayList<HMBase>();

    public InlineBox(HummerContext context) {
        super(context, null, null);
        this.onCreate();
    }

    @Override
    protected HummerLayout createViewInstance(Context context) {
        return new HummerLayout(context);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        ((HummerLayout)((Object)this.getView())).setClipChildren(false);
        this.getYogaNode().setFlexDirection(YogaFlexDirection.ROW);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.getView() != null) {
            ((HummerLayout)((Object)this.getView())).removeAllViews();
        }
    }

    public void add(HMBase child) {
        ((HummerLayout)((Object)this.getView())).addView(child);
        ((HummerLayout)((Object)this.getView())).setClipChildren(true);
        this.children.add(child);
    }

    public void remove(HMBase child) {
        ((HummerLayout)((Object)this.getView())).removeView(child);
        this.children.remove(child);
    }

    public boolean isChildrenEmpty() {
        return this.children.size() == 0;
    }

    public void insertBefore(HMBase child, HMBase existing) {
        ((HummerLayout)((Object)this.getView())).insertBefore(child, existing);
        int index = this.children.indexOf(existing);
        this.children.add(index, child);
    }

    public void replace(HMBase child, HMBase old) {
        ((HummerLayout)((Object)this.getView())).replaceView(child, old);
        int index = this.children.indexOf(old);
        this.children.set(index, child);
    }

    public HMBase getSubview(String viewID) {
        return ((HummerLayout)((Object)this.getView())).getViewById(viewID);
    }

    public List<HMBase> getChildren() {
        return this.children;
    }
}

