/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.render.event;

import com.didi.hummer.core.engine.JSCallback;
import com.didi.hummer.lifecycle.ILifeCycle;
import com.didi.hummer.render.event.IEventListener;
import com.didi.hummer.render.event.base.Event;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class EventManager
implements ILifeCycle,
IEventListener {
    public HashMap<String, List<JSCallback>> mEventListeners;

    @Override
    public void onCreate() {
        this.mEventListeners = new HashMap();
    }

    @Override
    public void onDestroy() {
        if (this.mEventListeners != null) {
            for (List<JSCallback> callbackList : this.mEventListeners.values()) {
                if (callbackList == null) continue;
                for (JSCallback callback : callbackList) {
                    if (callback == null) continue;
                    callback.release();
                }
                callbackList.clear();
            }
            this.mEventListeners.clear();
        }
    }

    @Override
    public void addEventListener(String eventName, JSCallback callback) {
        if (this.mEventListeners.containsKey(eventName)) {
            List<JSCallback> callbacks = this.mEventListeners.get(eventName);
            if (callbacks.contains(callback)) {
                return;
            }
            callbacks.add(callback);
        } else {
            ArrayList<JSCallback> callbacks = new ArrayList<JSCallback>();
            callbacks.add(callback);
            this.mEventListeners.put(eventName, callbacks);
        }
    }

    @Override
    public void removeEventListener(String eventName, JSCallback callback) {
        if (!this.mEventListeners.containsKey(eventName) || callback == null) {
            return;
        }
        List<JSCallback> callbacks = this.mEventListeners.get(eventName);
        JSCallback cbToRemove = null;
        for (JSCallback cb : callbacks) {
            if (cb == null || !cb.equals(callback)) continue;
            cbToRemove = cb;
            break;
        }
        if (cbToRemove != null) {
            cbToRemove.release();
            callbacks.remove(cbToRemove);
        }
    }

    @Override
    public void clearEventListeners(String eventName) {
        if (!this.mEventListeners.containsKey(eventName)) {
            return;
        }
        List<JSCallback> callbacks = this.mEventListeners.get(eventName);
        for (JSCallback cb : callbacks) {
            if (cb == null) continue;
            cb.release();
        }
        callbacks.clear();
    }

    public void dispatchEvent(String eventName, Event event) {
        if (!this.mEventListeners.containsKey(eventName)) {
            return;
        }
        List<JSCallback> callbacks = this.mEventListeners.get(eventName);
        for (JSCallback callback : callbacks) {
            callback.call(new Object[]{event});
        }
    }

    public boolean contains(String event) {
        return this.mEventListeners.containsKey(event);
    }

    public boolean isEmpty() {
        return this.mEventListeners == null || this.mEventListeners.isEmpty();
    }
}

