/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.render.event.guesture.common;

import android.content.Context;
import android.view.MotionEvent;
import com.didi.hummer.render.utility.DPUtil;
import java.util.HashMap;
import java.util.Map;

public class GestureUtils {
    public static int findStateInMotionEvent(MotionEvent e) {
        int ret = 0;
        if (e == null) {
            return ret;
        }
        switch (e.getAction()) {
            case 0: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return ret;
    }

    public static Map<String, Float> findPositionInMotionEvent(Context context, MotionEvent e) {
        HashMap<String, Float> ret = new HashMap<String, Float>();
        if (e == null) {
            ret.put("x", Float.valueOf(0.0f));
            ret.put("y", Float.valueOf(0.0f));
            ret.put("rawX", Float.valueOf(0.0f));
            ret.put("rawY", Float.valueOf(0.0f));
            return ret;
        }
        ret.put("x", Float.valueOf(DPUtil.px2dpF(context, e.getX())));
        ret.put("y", Float.valueOf(DPUtil.px2dpF(context, e.getY())));
        ret.put("rawX", Float.valueOf(DPUtil.px2dpF(context, e.getRawX())));
        ret.put("rawY", Float.valueOf(DPUtil.px2dpF(context, e.getRawY())));
        return ret;
    }

    public static HashMap<String, Float> findTranslationInMotionEvent(Context context, float distanceX, float distanceY) {
        HashMap<String, Float> ret = new HashMap<String, Float>();
        ret.put("deltaX", Float.valueOf(DPUtil.px2dpF(context, distanceX)));
        ret.put("deltaY", Float.valueOf(DPUtil.px2dpF(context, distanceY)));
        return ret;
    }
}

