/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.render.style;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.didi.hummer.render.component.view.HMBase;
import com.facebook.yoga.YogaNode;
import com.facebook.yoga.android.YogaLayout;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public class HummerLayout
extends YogaLayout {
    private Map<String, HMBase> children = new HashMap<String, HMBase>();
    private RectF mClipBounds = new RectF();
    private Path mViewPath = new Path();
    private Callable<float[]> cornerRadiiGetter;
    private HMBase lastChild;
    private boolean needClipChildren;
    private OnSizeChangeListener onSizeChangeListener;

    public HummerLayout(Context context) {
        this(context, null);
    }

    public HummerLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HummerLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.setClipChildren(false);
    }

    public void setOnSizeChangeListener(OnSizeChangeListener listener) {
        this.onSizeChangeListener = listener;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.onSizeChangeListener != null) {
            this.onSizeChangeListener.onSizeChanged(w, h, oldw, oldh);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (!(this.getParent() instanceof YogaLayout)) {
            this.createLayout(View.MeasureSpec.makeMeasureSpec((int)(r - l), (int)0), View.MeasureSpec.makeMeasureSpec((int)(b - t), (int)0));
        }
        this.applyLayoutRecursive(this.getYogaNode(), 0.0f, 0.0f);
    }

    private void createLayout(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (heightMode == 0x40000000) {
            this.getYogaNode().setHeight((float)heightSize);
        }
        if (widthMode == 0x40000000) {
            this.getYogaNode().setWidth((float)widthSize);
        }
        if (heightMode == Integer.MIN_VALUE) {
            this.getYogaNode().setMaxHeight((float)heightSize);
        }
        if (widthMode == Integer.MIN_VALUE) {
            this.getYogaNode().setMaxWidth((float)widthSize);
        }
        this.getYogaNode().calculateLayout(Float.NaN, Float.NaN);
    }

    private void applyLayoutRecursive(YogaNode node, float xOffset, float yOffset) {
        View view = (View)node.getData();
        if (view != null && view != this) {
            if (view.getVisibility() == 8) {
                return;
            }
            int left = Math.round(xOffset + node.getLayoutX());
            int top = Math.round(yOffset + node.getLayoutY());
            view.measure(View.MeasureSpec.makeMeasureSpec((int)Math.round(node.getLayoutWidth()), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)Math.round(node.getLayoutHeight()), (int)0x40000000));
            view.layout(left, top, left + view.getMeasuredWidth(), top + view.getMeasuredHeight());
        }
        int childrenCount = node.getChildCount();
        for (int i = 0; i < childrenCount; ++i) {
            if (((Object)((Object)this)).equals(view)) {
                this.applyLayoutRecursive(node.getChildAt(i), xOffset, yOffset);
                continue;
            }
            if (!(view instanceof YogaLayout)) continue;
        }
    }

    public void setCornerRadiiGetter(Callable<float[]> cornerRadiiGetter) {
        this.cornerRadiiGetter = cornerRadiiGetter;
    }

    public void setNeedClipChildren(boolean needClipChildren) {
        this.needClipChildren = needClipChildren;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.needClipChildren) {
            this.mClipBounds.set(0.0f, 0.0f, (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight());
            this.mViewPath.reset();
            float[] cornerRadii = null;
            try {
                if (this.cornerRadiiGetter != null) {
                    cornerRadii = this.cornerRadiiGetter.call();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (cornerRadii != null) {
                this.mViewPath.addRoundRect(this.mClipBounds, cornerRadii, Path.Direction.CW);
            } else {
                this.mViewPath.addRect(this.mClipBounds, Path.Direction.CW);
            }
            canvas.clipPath(this.mViewPath);
        }
    }

    public void addView(@NonNull HMBase subview) {
        this.addView(subview, -1);
    }

    public void addView(@NonNull HMBase subview, int index) {
        if (subview == null) {
            return;
        }
        ViewParent parent = subview.getView().getParent();
        if (parent instanceof ViewGroup) {
            ((ViewGroup)parent).removeView(subview.getView());
        }
        this.addView((View)subview.getView(), subview.getYogaNode());
        if (subview.getYogaNode().getData() == null) {
            subview.getYogaNode().setData(subview.getView());
        }
        int childCount = this.getYogaNode().getChildCount();
        index = index < 0 ? childCount : index;
        this.getYogaNode().addChildAt(subview.getYogaNode(), index);
        this.children.put(subview.getViewID(), subview);
        if (index == childCount) {
            this.lastChild = subview;
        }
    }

    public void removeView(@NonNull HMBase subview) {
        if (subview == null) {
            return;
        }
        this.removeView((View)subview.getView());
        this.children.remove(subview.getViewID());
    }

    public void removeAllViews() {
        super.removeAllViews();
        this.children.clear();
    }

    public void insertBefore(@NonNull HMBase subview, @NonNull HMBase existingView) {
        if (subview == null || existingView == null) {
            return;
        }
        int index = this.getYogaNode().indexOf(existingView.getYogaNode());
        this.addView(subview, index);
    }

    public void replaceView(@NonNull HMBase newSubview, @NonNull HMBase oldSubview) {
        if (newSubview == null || oldSubview == null) {
            return;
        }
        int index = this.getYogaNode().indexOf(oldSubview.getYogaNode());
        this.removeView(oldSubview);
        this.addView(newSubview, index);
    }

    public HMBase getViewById(String viewId) {
        return this.children.get(viewId);
    }

    public HMBase getLastChild() {
        return this.lastChild;
    }

    public void layout() {
        this.getYogaNode().calculateLayout(0.0f, 0.0f);
    }

    public static interface OnSizeChangeListener {
        public void onSizeChanged(int var1, int var2, int var3, int var4);
    }
}

