/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.render.style;

import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.component.view.HummerLayoutExtendView;
import com.didi.hummer.render.style.HummerStyleUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class HummerLayoutExtendUtils {
    public static Map<HMBase, Map<String, Object>> hmBaseCssStyleMap = new WeakHashMap<HMBase, Map<String, Object>>();
    private static final List<String> BLOCK_INTERCEPT_STYLES = Arrays.asList("flexDirection", "flexBasis", "flexDirection", "flexGrow", "flexShrink", "flexWrap");
    private static final List<String> INLINE_BLOCK_INTERCEPT_STYLES = Arrays.asList("flexDirection", "flexBasis", "flexDirection", "flexGrow", "flexShrink", "flexWrap");
    private static final List<String> INLINE_INTERCEPT_STYLES = Arrays.asList("border", "borderAll", "borderLeft", "borderRight", "borderTop", "borderBottom", "borderStart", "borderEnd", "borderHorizontal", "borderVertical", "flexBasis", "flexDirection", "flexGrow", "flexShrink", "flexWrap", "width", "height", "maxWidth", "maxHeight", "minWidth", "minHeight", "margin", "marginAll", "marginLeft", "marginRight", "marginTop", "marginBottom", "marginStart", "marginEnd", "marginHorizontal", "marginVertical", "padding", "paddingAll", "paddingBottom", "paddingEnd", "paddingLeft", "paddingRight", "paddingStart", "paddingTop", "paddingHorizontal", "paddingVertical");

    public static void markExtendCssView(HMBase hmBase) {
        if (!hmBaseCssStyleMap.containsKey(hmBase)) {
            hmBaseCssStyleMap.put(hmBase, new HashMap());
        }
    }

    public static boolean isExtendCssView(HMBase hmBase) {
        return hmBaseCssStyleMap.containsKey(hmBase);
    }

    public static Map<String, Object> getExtendCssViewStyle(HMBase hmBase) {
        return hmBaseCssStyleMap.get(hmBase);
    }

    public static void applyChildDisplayStyle(String parentDisplay, HMBase hmChild) {
        if (!HummerLayoutExtendUtils.isExtendCssView(hmChild)) {
            return;
        }
        Map<String, Object> extendViewStyle = HummerLayoutExtendUtils.getExtendCssViewStyle(hmChild);
        if (Display.BLOCK.value().equals(parentDisplay)) {
            if (hmChild.getDisplay() == Display.BLOCK) {
                HashMap<String, String> cssStyleMap = new HashMap<String, String>();
                if (!(extendViewStyle.containsKey("width") || extendViewStyle.containsKey("maxWidth") || extendViewStyle.containsKey("minWidth"))) {
                    cssStyleMap.put("width", "100%");
                }
                HummerStyleUtils.applyStyle(false, hmChild, cssStyleMap);
            }
            HummerStyleUtils.applyStyle(false, hmChild, extendViewStyle);
        } else if (Display.YOGA.value().equals(parentDisplay)) {
            if (hmChild.getDisplay() == Display.BLOCK) {
                HashMap<String, String> cssStyleMap = new HashMap<String, String>();
                cssStyleMap.put("width", "auto");
                HummerStyleUtils.applyStyle(false, hmChild, cssStyleMap);
            }
            HummerStyleUtils.applyStyle(false, hmChild, extendViewStyle);
        }
    }

    public static void applyDisplayStyle(HMBase hmBase, String replace) {
        if (HummerLayoutExtendUtils.isExtendCssView(hmBase)) {
            Map<String, Object> extendViewStyle = HummerLayoutExtendUtils.getExtendCssViewStyle(hmBase);
            HummerStyleUtils.applyStyle(false, hmBase, extendViewStyle);
        }
        HashMap<String, String> addCssStyle = new HashMap<String, String>();
        if (Display.BLOCK.value().equals(replace)) {
            addCssStyle.put("flexDirection", "column");
        }
        if (Display.INLINE.value().equals(replace)) {
            addCssStyle.put("width", "auto");
            addCssStyle.put("maxWidth", "auto");
            addCssStyle.put("minWidth", "auto");
            addCssStyle.put("height", "auto");
            addCssStyle.put("maxHeight", "auto");
            addCssStyle.put("minHeight", "auto");
            addCssStyle.put("marginAll", "0%");
            addCssStyle.put("marginLeft", "0%");
            addCssStyle.put("marginRight", "0%");
            addCssStyle.put("marginTop", "0%");
            addCssStyle.put("marginBottom", "0%");
            addCssStyle.put("marginStart", "0%");
            addCssStyle.put("marginEnd", "0%");
            addCssStyle.put("marginHorizontal", "0%");
            addCssStyle.put("marginVertical", "0%");
            addCssStyle.put("paddingAll", "0%");
            addCssStyle.put("paddingBottom", "0%");
            addCssStyle.put("paddingEnd", "0%");
            addCssStyle.put("paddingLeft", "0%");
            addCssStyle.put("paddingRight", "0%");
            addCssStyle.put("paddingStart", "0%");
            addCssStyle.put("paddingTop", "0%");
            addCssStyle.put("paddingHorizontal", "0%");
            addCssStyle.put("paddingVertical", "0%");
        }
        if (Display.INLINE_BLOCK.value().equals(replace)) {
            addCssStyle.put("flexDirection", "column");
        }
        HummerStyleUtils.applyStyle(false, hmBase, addCssStyle);
        if (hmBase instanceof HummerLayoutExtendView) {
            List<HMBase> children = ((HummerLayoutExtendView)hmBase).getChildren();
            for (HMBase child : children) {
                HummerLayoutExtendUtils.applyChildDisplayStyle(replace, child);
            }
        }
    }

    public static boolean interceptDisplayStyle(HMBase hmBase, String key, Object value) {
        if (!"display".equals(key) && HummerLayoutExtendUtils.isExtendCssView(hmBase)) {
            Map<String, Object> extendViewStyle = HummerLayoutExtendUtils.getExtendCssViewStyle(hmBase);
            extendViewStyle.put(key, value);
        }
        if (hmBase.getDisplay() == Display.INLINE) {
            return INLINE_INTERCEPT_STYLES.contains(key);
        }
        if (hmBase.getDisplay() == Display.BLOCK) {
            return BLOCK_INTERCEPT_STYLES.contains(key);
        }
        if (hmBase.getDisplay() == Display.INLINE_BLOCK) {
            return INLINE_BLOCK_INTERCEPT_STYLES.contains(key);
        }
        return false;
    }

    public static enum Display {
        YOGA("flex"),
        BLOCK("block"),
        INLINE("inline"),
        INLINE_BLOCK("inline-block");

        private String value;

        private Display(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }
    }

    public static enum Position {
        YOGA("flex"),
        FIXED("fixed");

        private String value;

        private Position(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }
    }
}

