/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.render.style;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.didi.hummer.core.engine.JSContext;
import com.didi.hummer.core.engine.JSValue;
import com.didi.hummer.core.util.DebugUtil;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.style.HummerStyleUtils;
import com.didi.hummer.render.utility.YogaNodeUtil;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaNode;
import com.facebook.yoga.android.YogaLayout;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HummerNode
implements Serializable {
    private transient HMBase linkView;
    private transient YogaNode yogaNode;
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="objId")
    private long objId;
    @SerializedName(value="tagName")
    private String name;
    @SerializedName(value="alias")
    private String alias;
    @SerializedName(value="content")
    private String content;
    @SerializedName(value="style")
    private Map<String, Object> style = new HashMap<String, Object>();
    @SerializedName(value="children")
    private List<HummerNode> children = new LinkedList<HummerNode>();

    public HummerNode(@NonNull HMBase linkView, @Nullable String nodeId) {
        this.linkView = linkView;
        this.id = TextUtils.isEmpty((CharSequence)nodeId) ? this.createNodeId() : nodeId;
        this.yogaNode = this.getYogaNode(linkView);
        if (DebugUtil.isDebuggable() && linkView.getJSValue() != null) {
            this.name = linkView.getJSValue().getString("className");
            this.objId = linkView.getJSValue().getLong("objID");
        }
    }

    private String createNodeId() {
        return "hm_node_" + System.currentTimeMillis();
    }

    private YogaNode getYogaNode(HMBase linkView) {
        YogaNode node;
        Object view = linkView.getView();
        if (view instanceof YogaLayout) {
            node = ((YogaLayout)view).getYogaNode();
        } else {
            node = YogaNodeUtil.createYogaNode();
            node.setData(view);
            node.setMeasureFunction((YogaMeasureFunction)new YogaLayout.ViewMeasureFunction());
        }
        return node;
    }

    public void setStyle(Map<String, Object> style) {
        this.style.putAll(style);
        HummerStyleUtils.applyStyle(this.linkView, style);
    }

    public void resetStyle() {
        HummerStyleUtils.resetYogaStyle(this.linkView);
    }

    public HMBase getLinkView() {
        return this.linkView;
    }

    public YogaNode getYogaNode() {
        return this.yogaNode;
    }

    public String getId() {
        return this.id;
    }

    public long getObjId() {
        return this.objId;
    }

    public Map<String, Object> getStyle() {
        return this.style;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public List<HummerNode> getChildren() {
        return this.children;
    }

    public void appendChild(HummerNode node) {
        this.children.add(node);
    }

    public void removeChild(HummerNode node) {
        this.children.remove(node);
    }

    public void removeAll() {
        this.children.clear();
    }

    public void insertBefore(HummerNode newNode, HummerNode oldNode) {
        int index = this.children.lastIndexOf(oldNode);
        if (index > 0) {
            this.children.add(index, newNode);
        }
    }

    public void replaceChild(HummerNode newNode, HummerNode oldNode) {
        int index = this.children.lastIndexOf(oldNode);
        if (index > 0) {
            this.children.remove(oldNode);
            this.children.add(index, newNode);
        }
    }

    public JSValue getJSNodeTree(int depth) {
        if (this.linkView == null || this.linkView.getJSValue() == null) {
            return null;
        }
        JSContext jsContext = this.linkView.getJSValue().getJSContext();
        JSValue jsNode = (JSValue)jsContext.evaluateJavaScript("new Object();");
        jsNode.set("id", (Number)this.objId);
        jsNode.set("tagName", this.name);
        jsNode.set("alias", this.alias);
        jsNode.set("content", this.content);
        jsNode.set("element", this.linkView.getJSValue());
        if (depth > 0 && !this.children.isEmpty()) {
            JSValue children = (JSValue)jsContext.evaluateJavaScript("new Array();");
            for (HummerNode n : this.children) {
                children.callFunction("push", new Object[]{n.getJSNodeTree(--depth)});
            }
            jsNode.set("children", children);
        }
        return jsNode;
    }
}

