/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.render.style;

import android.content.Context;
import com.didi.hummer.HummerSDK;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSContext;
import com.didi.hummer.core.engine.jsc.jni.HummerException;
import com.didi.hummer.core.util.ExceptionUtil;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.style.HummerLayoutExtendUtils;
import com.didi.hummer.render.utility.DPUtil;
import com.didi.hummer.render.utility.RTLUtil;
import com.didi.hummer.render.utility.RemUtil;
import com.didi.hummer.render.utility.YogaAttrUtils;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaDisplay;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaFlexDirection;
import com.facebook.yoga.YogaJustify;
import com.facebook.yoga.YogaNode;
import com.facebook.yoga.YogaPositionType;
import com.facebook.yoga.YogaWrap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HummerStyleUtils {
    private static final List<String> YOGA_STYLES = Arrays.asList("justifyContent", "alignContent", "alignItems", "alignSelf", "aspectRatio", "border", "borderAll", "borderLeft", "borderRight", "borderTop", "borderBottom", "borderStart", "borderEnd", "borderHorizontal", "borderVertical", "direction", "display", "flex", "flexBasis", "flexDirection", "flexGrow", "flexShrink", "flexWrap", "width", "height", "maxWidth", "maxHeight", "minWidth", "minHeight", "margin", "marginAll", "marginLeft", "marginRight", "marginTop", "marginBottom", "marginStart", "marginEnd", "marginHorizontal", "marginVertical", "padding", "paddingAll", "paddingLeft", "paddingRight", "paddingTop", "paddingBottom", "paddingStart", "paddingEnd", "paddingHorizontal", "paddingVertical", "position", "positionType", "positionAll", "positionLeft", "positionRight", "positionTop", "positionBottom", "positionStart", "positionEnd", "positionHorizontal", "positionVertical", "left", "right", "top", "bottom", "start", "end");
    private static final List<String> NON_DP_STYLES = new LinkedList<String>(Arrays.asList("aspectRatio", "flex", "flexGrow", "flexShrink", "opacity", "textLineClamp", "letterSpacing", "lineSpacingMulti", "maxLength", "column"));
    private static final List<String> TRANSITION_STYLES = new LinkedList<String>(Arrays.asList("width", "height", "backgroundColor", "opacity", "transform"));
    private static final String[] paramNames = new String[]{"x", "y", "z"};

    public static void addNonDpStyle(String styleName) {
        if (!NON_DP_STYLES.contains(styleName)) {
            NON_DP_STYLES.add(styleName);
        }
    }

    static void applyStyle(HMBase view, Map style) {
        HummerStyleUtils.applyStyle(true, view, style);
    }

    static void applyStyle(boolean needIntercept, HMBase view, Map style) {
        Object value;
        String key;
        if (view == null || style == null) {
            return;
        }
        HashMap transitionStyle = new HashMap();
        for (Object k : style.keySet()) {
            key = String.valueOf(k);
            value = style.get(k);
            if (needIntercept && HummerLayoutExtendUtils.interceptDisplayStyle(view, key, value)) continue;
            if ("position".equals(key) || "positionType".equals(key) || "display".equals(key)) {
                if (view.setHummerStyle(key, value)) {
                    continue;
                }
            } else if (key.startsWith("transition")) {
                transitionStyle.put(key, value);
                continue;
            }
            try {
                if ("transform".equals(key) || HummerStyleUtils.isTransitionStyle(key) && (view.supportTransitionStyle("all") || view.supportTransitionStyle(key))) {
                    view.handleTransitionStyle(key, value);
                    continue;
                }
                if (HummerStyleUtils.isYogaStyle(key)) {
                    key = HummerStyleUtils.toRTLStyleIfNeed(view.getContext(), key);
                    HummerStyleUtils.applyYogaStyle(view.getYogaNode(), key, value);
                    continue;
                }
                HummerStyleUtils.applyHummerStyle(view, key, value);
            }
            catch (Exception e) {
                String jsStack = ExceptionUtil.getJSErrorStack((JSContext)view.getJSValue().getJSContext());
                ExceptionUtil.addStackTrace((Exception)e, (StackTraceElement)new StackTraceElement("<<JS_Stack>>", "", "\n" + jsStack, -1));
                ExceptionUtil.addStackTrace((Exception)e, (StackTraceElement)new StackTraceElement("<<Style>>", "", String.format("%s: %s", key, value), -1));
                HummerException.nativeException((JSContext)view.getJSValue().getJSContext(), (Exception)e);
            }
        }
        view.getView().requestLayout();
        for (Object k : transitionStyle.keySet()) {
            key = String.valueOf(k);
            value = style.get(k);
            view.setTransitionStyle(key, value);
        }
        view.runAnimator();
    }

    public static Object transformValue(Object object) {
        if (object == null) {
            return object;
        }
        String value = object.toString();
        if (!value.contains(",")) {
            return object;
        }
        String[] params = value.split(",");
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < params.length; ++i) {
            map.put(paramNames[i], params[i]);
        }
        return map;
    }

    static void resetYogaStyle(HMBase view) {
        if (view == null) {
            return;
        }
        YogaNode node = view.getYogaNode();
        node.setJustifyContent(YogaJustify.FLEX_START);
        node.setAlignContent(YogaAlign.FLEX_START);
        node.setAlignContent(YogaAlign.FLEX_START);
        node.setAlignItems(YogaAlign.STRETCH);
        node.setAlignSelf(YogaAlign.AUTO);
        node.setBorder(YogaEdge.ALL, 0.0f);
        node.setDisplay(YogaDisplay.FLEX);
        node.setFlexBasisAuto();
        node.setFlexDirection(YogaFlexDirection.COLUMN);
        node.setFlexGrow(0.0f);
        node.setFlexShrink(1.0f);
        node.setWrap(YogaWrap.NO_WRAP);
        node.setWidthAuto();
        node.setHeightAuto();
        node.setMaxWidth(2.1474836E9f);
        node.setMaxHeight(2.1474836E9f);
        node.setMinWidth(0.0f);
        node.setMinHeight(0.0f);
        node.setMargin(YogaEdge.ALL, 0.0f);
        node.setPadding(YogaEdge.ALL, 0.0f);
        node.setPosition(YogaEdge.ALL, 0.0f);
        node.setPositionType(YogaPositionType.RELATIVE);
    }

    private static boolean isTransitionStyle(String key) {
        return TRANSITION_STYLES.contains(key);
    }

    private static boolean isYogaStyle(String key) {
        return YOGA_STYLES.contains(key);
    }

    private static boolean isDPStyle(String key) {
        return !NON_DP_STYLES.contains(key);
    }

    static String toRTLStyleIfNeed(Context context, String key) {
        boolean needRTL;
        boolean supportRTL = context instanceof HummerContext && HummerSDK.isSupportRTL(((HummerContext)context).getNamespace());
        boolean bl = needRTL = supportRTL && RTLUtil.isRTL(context);
        if (needRTL) {
            if (key.equals("left")) {
                key = "right";
            } else if (key.equals("right")) {
                key = "left";
            } else if (key.equals("positionLeft")) {
                key = "positionRight";
            } else if (key.equals("positionRight")) {
                key = "positionLeft";
            } else if (key.equals("marginLeft")) {
                key = "marginRight";
            } else if (key.equals("marginRight")) {
                key = "marginLeft";
            } else if (key.equals("paddingLeft")) {
                key = "paddingRight";
            } else if (key.equals("paddingRight")) {
                key = "paddingLeft";
            }
        }
        return key;
    }

    static void applyYogaStyle(YogaNode node, String key, Object value) {
        switch (key) {
            case "justifyContent": {
                node.setJustifyContent(YogaJustify.valueOf((String)HummerStyleUtils.toYogaEnumString(value)));
                break;
            }
            case "alignContent": {
                node.setAlignContent(YogaAlign.valueOf((String)HummerStyleUtils.toYogaEnumString(value)));
                break;
            }
            case "alignItems": {
                node.setAlignItems(YogaAlign.valueOf((String)HummerStyleUtils.toYogaEnumString(value)));
                break;
            }
            case "alignSelf": {
                node.setAlignSelf(YogaAlign.valueOf((String)HummerStyleUtils.toYogaEnumString(value)));
                break;
            }
            case "aspectRatio": {
                node.setAspectRatio(HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "border": 
            case "borderAll": {
                node.setBorder(YogaEdge.ALL, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "borderLeft": {
                node.setBorder(YogaEdge.LEFT, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "borderRight": {
                node.setBorder(YogaEdge.RIGHT, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "borderTop": {
                node.setBorder(YogaEdge.TOP, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "borderBottom": {
                node.setBorder(YogaEdge.BOTTOM, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "borderStart": {
                node.setBorder(YogaEdge.START, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "borderEnd": {
                node.setBorder(YogaEdge.END, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "borderHorizontal": {
                node.setBorder(YogaEdge.HORIZONTAL, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "borderVertical": {
                node.setBorder(YogaEdge.VERTICAL, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "direction": {
                node.setDirection(YogaDirection.valueOf((String)HummerStyleUtils.toYogaEnumString(value)));
                break;
            }
            case "display": {
                node.setDisplay(YogaDisplay.valueOf((String)HummerStyleUtils.toYogaEnumString(value)));
                break;
            }
            case "flex": {
                node.setFlex(HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "flexBasis": {
                if (HummerStyleUtils.isAutoValue(value)) {
                    node.setFlexBasisAuto();
                    break;
                }
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setFlexBasisPercent(HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setFlexBasis(HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "flexDirection": {
                node.setFlexDirection(YogaFlexDirection.valueOf((String)HummerStyleUtils.toYogaEnumString(value)));
                break;
            }
            case "flexGrow": {
                node.setFlexGrow(HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "flexShrink": {
                node.setFlexShrink(HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "flexWrap": {
                node.setWrap(YogaWrap.valueOf((String)HummerStyleUtils.toYogaEnumString(value)));
                break;
            }
            case "width": {
                if (HummerStyleUtils.isAutoValue(value)) {
                    node.setWidthAuto();
                    break;
                }
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setWidthPercent(HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setWidth(HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "height": {
                if (HummerStyleUtils.isAutoValue(value)) {
                    node.setHeightAuto();
                    break;
                }
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setHeightPercent(HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setHeight(HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "maxWidth": {
                if (HummerStyleUtils.isAutoValue(value)) {
                    node.setMaxWidth(2.1474836E9f);
                    break;
                }
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setMaxWidthPercent(HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setMaxWidth(HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "maxHeight": {
                if (HummerStyleUtils.isAutoValue(value)) {
                    node.setMaxHeight(2.1474836E9f);
                    break;
                }
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setMaxHeightPercent(HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setMaxHeight(HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "minWidth": {
                if (HummerStyleUtils.isAutoValue(value)) {
                    node.setMinWidth(0.0f);
                    break;
                }
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setMinWidthPercent(HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setMinWidth(HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "minHeight": {
                if (HummerStyleUtils.isAutoValue(value)) {
                    node.setMinHeight(0.0f);
                    break;
                }
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setMinHeightPercent(HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setMinHeight(HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "margin": 
            case "marginAll": {
                if (HummerStyleUtils.isAutoValue(value)) {
                    node.setMarginAuto(YogaEdge.ALL);
                    break;
                }
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setMarginPercent(YogaEdge.ALL, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setMargin(YogaEdge.ALL, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "marginLeft": {
                if (HummerStyleUtils.isAutoValue(value)) {
                    node.setMarginAuto(YogaEdge.LEFT);
                    break;
                }
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setMarginPercent(YogaEdge.LEFT, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setMargin(YogaEdge.LEFT, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "marginRight": {
                if (HummerStyleUtils.isAutoValue(value)) {
                    node.setMarginAuto(YogaEdge.RIGHT);
                    break;
                }
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setMarginPercent(YogaEdge.RIGHT, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setMargin(YogaEdge.RIGHT, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "marginTop": {
                if (HummerStyleUtils.isAutoValue(value)) {
                    node.setMarginAuto(YogaEdge.TOP);
                    break;
                }
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setMarginPercent(YogaEdge.TOP, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setMargin(YogaEdge.TOP, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "marginBottom": {
                if (HummerStyleUtils.isAutoValue(value)) {
                    node.setMarginAuto(YogaEdge.BOTTOM);
                    break;
                }
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setMarginPercent(YogaEdge.BOTTOM, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setMargin(YogaEdge.BOTTOM, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "marginStart": {
                if (HummerStyleUtils.isAutoValue(value)) {
                    node.setMarginAuto(YogaEdge.START);
                    break;
                }
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setMarginPercent(YogaEdge.START, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setMargin(YogaEdge.START, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "marginEnd": {
                if (HummerStyleUtils.isAutoValue(value)) {
                    node.setMarginAuto(YogaEdge.END);
                    break;
                }
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setMarginPercent(YogaEdge.END, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setMargin(YogaEdge.END, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "marginHorizontal": {
                if (HummerStyleUtils.isAutoValue(value)) {
                    node.setMarginAuto(YogaEdge.HORIZONTAL);
                    break;
                }
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setMarginPercent(YogaEdge.HORIZONTAL, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setMargin(YogaEdge.HORIZONTAL, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "marginVertical": {
                if (HummerStyleUtils.isAutoValue(value)) {
                    node.setMarginAuto(YogaEdge.VERTICAL);
                    break;
                }
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setMarginPercent(YogaEdge.VERTICAL, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setMargin(YogaEdge.VERTICAL, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "padding": 
            case "paddingAll": {
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setPaddingPercent(YogaEdge.ALL, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setPadding(YogaEdge.ALL, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "paddingLeft": {
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setPaddingPercent(YogaEdge.LEFT, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setPadding(YogaEdge.LEFT, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "paddingRight": {
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setPaddingPercent(YogaEdge.RIGHT, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setPadding(YogaEdge.RIGHT, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "paddingTop": {
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setPaddingPercent(YogaEdge.TOP, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setPadding(YogaEdge.TOP, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "paddingBottom": {
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setPaddingPercent(YogaEdge.BOTTOM, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setPadding(YogaEdge.BOTTOM, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "paddingStart": {
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setPaddingPercent(YogaEdge.START, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setPadding(YogaEdge.START, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "paddingEnd": {
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setPaddingPercent(YogaEdge.END, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setPadding(YogaEdge.END, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "paddingHorizontal": {
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setPaddingPercent(YogaEdge.HORIZONTAL, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setPadding(YogaEdge.HORIZONTAL, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "paddingVertical": {
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setPaddingPercent(YogaEdge.VERTICAL, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setPadding(YogaEdge.VERTICAL, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "position": 
            case "positionType": {
                node.setPositionType(YogaPositionType.valueOf((String)HummerStyleUtils.toYogaEnumString(value)));
                break;
            }
            case "positionAll": {
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setPositionPercent(YogaEdge.ALL, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setPosition(YogaEdge.ALL, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "left": 
            case "positionLeft": {
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setPositionPercent(YogaEdge.LEFT, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setPosition(YogaEdge.LEFT, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "right": 
            case "positionRight": {
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setPositionPercent(YogaEdge.RIGHT, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setPosition(YogaEdge.RIGHT, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "top": 
            case "positionTop": {
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setPositionPercent(YogaEdge.TOP, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setPosition(YogaEdge.TOP, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "bottom": 
            case "positionBottom": {
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setPositionPercent(YogaEdge.BOTTOM, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setPosition(YogaEdge.BOTTOM, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "start": 
            case "positionStart": {
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setPositionPercent(YogaEdge.START, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setPosition(YogaEdge.START, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "end": 
            case "positionEnd": {
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setPositionPercent(YogaEdge.END, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setPosition(YogaEdge.END, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "positionHorizontal": {
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setPositionPercent(YogaEdge.HORIZONTAL, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setPosition(YogaEdge.HORIZONTAL, HummerStyleUtils.toNumber(key, value));
                break;
            }
            case "positionVertical": {
                if (HummerStyleUtils.isPercentValue(value)) {
                    node.setPositionPercent(YogaEdge.VERTICAL, HummerStyleUtils.toPercent(value));
                    break;
                }
                node.setPosition(YogaEdge.VERTICAL, HummerStyleUtils.toNumber(key, value));
                break;
            }
        }
    }

    private static void applyHummerStyle(HMBase view, String key, Object value) {
        view.setHummerStyle(key, HummerStyleUtils.convertValue(key, value));
    }

    private static float toNumber(String key, Object value) {
        return HummerStyleUtils.convertNumber(value, HummerStyleUtils.isDPStyle(key));
    }

    private static String toYogaEnumString(Object value) {
        String enumStr = String.valueOf(value).toUpperCase();
        if (enumStr.equals("NOWRAP")) {
            return "NO_WRAP";
        }
        return enumStr.replace("-", "_");
    }

    public static float toPercent(Object value) {
        if (!HummerStyleUtils.isPercentValue(value)) {
            return 0.0f;
        }
        String percentStr = String.valueOf(value);
        return Float.parseFloat(percentStr.substring(0, percentStr.length() - 1));
    }

    public static Object convertValue(String key, Object value) {
        if (value instanceof String) {
            String strValue = (String)value;
            if (strValue.startsWith("#")) {
                value = YogaAttrUtils.parseColor(strValue);
            } else if (strValue.startsWith("linear-gradient")) {
                value = YogaAttrUtils.parseLinearGradientColor(strValue);
            } else {
                try {
                    value = Float.valueOf(HummerStyleUtils.convertNumber(value, HummerStyleUtils.isDPStyle(key)));
                }
                catch (Exception exception) {}
            }
        } else if (value instanceof Number) {
            value = Float.valueOf(HummerStyleUtils.convertNumber(value, HummerStyleUtils.isDPStyle(key)));
        }
        return value;
    }

    public static Object convertColor(Object color) {
        if (color instanceof String) {
            String strColor = (String)color;
            if (YogaAttrUtils.isColor(strColor)) {
                return YogaAttrUtils.parseColor(strColor);
            }
            if (YogaAttrUtils.isLinearGradientColor(strColor)) {
                return YogaAttrUtils.parseLinearGradientColor(strColor);
            }
        }
        return 0;
    }

    public static float convertNumber(Object number) {
        return HummerStyleUtils.convertNumber(number, true);
    }

    public static float convertNumber(Object number, boolean isDPStyle) throws RuntimeException {
        float value = 0.0f;
        if (number instanceof Number) {
            value = isDPStyle ? (float)DPUtil.dp2px(HummerSDK.appContext, ((Number)number).floatValue()) : ((Number)number).floatValue();
        } else if (number instanceof String) {
            String attr = (String)number;
            boolean isPx = false;
            boolean isHm = false;
            if (attr.endsWith("px") || attr.endsWith("PX")) {
                attr = attr.substring(0, attr.length() - 2);
                isPx = true;
            } else if (attr.endsWith("hm") || attr.endsWith("HM")) {
                attr = attr.substring(0, attr.length() - 2);
                isHm = true;
            }
            value = Float.parseFloat(attr);
            if (isHm) {
                value = RemUtil.rem2px(value);
            } else if (!isPx && isDPStyle) {
                value = DPUtil.dp2px(HummerSDK.appContext, value);
            }
        }
        return value;
    }

    public static boolean isColorValue(Object value) {
        if (value instanceof String) {
            String color = (String)value;
            return YogaAttrUtils.isColor(color) || YogaAttrUtils.isLinearGradientColor(color);
        }
        return false;
    }

    public static boolean isNumberValue(Object value) {
        if (value instanceof String) {
            String number = (String)value;
            return YogaAttrUtils.isNumeric(number) || YogaAttrUtils.isPxNumeric(number) || YogaAttrUtils.isHmNumeric(number);
        }
        return value instanceof Number;
    }

    public static boolean isAutoValue(Object value) {
        return value instanceof String && ((String)value).toLowerCase().equals("auto");
    }

    public static boolean isPercentValue(Object value) {
        return value instanceof String && ((String)value).endsWith("%");
    }

    public class Hummer {
        public static final String BACKGROUND_COLOR = "backgroundColor";
        public static final String BACKGROUND_IMAGE = "backgroundImage";
        public static final String BORDER_STYLE = "borderStyle";
        public static final String BORDER_STYLE_L = "borderLeftStyle";
        public static final String BORDER_STYLE_T = "borderTopStyle";
        public static final String BORDER_STYLE_R = "borderRightStyle";
        public static final String BORDER_STYLE_B = "borderBottomStyle";
        public static final String BORDER_WIDTH = "borderWidth";
        public static final String BORDER_WIDTH_L = "borderLeftWidth";
        public static final String BORDER_WIDTH_T = "borderTopWidth";
        public static final String BORDER_WIDTH_R = "borderRightWidth";
        public static final String BORDER_WIDTH_B = "borderBottomWidth";
        public static final String BORDER_COLOR = "borderColor";
        public static final String BORDER_COLOR_L = "borderLeftColor";
        public static final String BORDER_COLOR_T = "borderTopColor";
        public static final String BORDER_COLOR_R = "borderRightColor";
        public static final String BORDER_COLOR_B = "borderBottomColor";
        public static final String BORDER_RADIUS = "borderRadius";
        public static final String BORDER_RADIUS_TL = "borderTopLeftRadius";
        public static final String BORDER_RADIUS_TR = "borderTopRightRadius";
        public static final String BORDER_RADIUS_BR = "borderBottomRightRadius";
        public static final String BORDER_RADIUS_BL = "borderBottomLeftRadius";
        public static final String BOX_SIZING = "boxSizing";
        public static final String SHADOW = "shadow";
        public static final String OPACITY = "opacity";
        public static final String VISIBILITY = "visibility";
        public static final String Z_INDEX = "zIndex";
        public static final String POSITION = "position";
        public static final String POSITION_TYPE = "positionType";
        public static final String DISPLAY = "display";
        public static final String OVERFLOW = "overflow";
        public static final String COLOR = "color";
        public static final String FONT_SIZE = "fontSize";
        public static final String FONT_FAMILY = "fontFamily";
        public static final String FONT_WEIGHT = "fontWeight";
        public static final String FONT_STYLE = "fontStyle";
        public static final String TEXT_ALIGN = "textAlign";
        public static final String TEXT_VERTICAL_ALIGN = "textVerticalAlign";
        public static final String TEXT_DECORATION = "textDecoration";
        public static final String TEXT_OVERFLOW = "textOverflow";
        public static final String TEXT_LINE_CLAMP = "textLineClamp";
        public static final String LETTER_SPACING = "letterSpacing";
        public static final String LINE_SPACING_MULTI = "lineSpacingMulti";
        public static final String TYPE = "type";
        public static final String PLACEHOLDER_COLOR = "placeholderColor";
        public static final String PLACEHOLDER_FONT_SIZE = "placeholderFontSize";
        public static final String CURSOR_COLOR = "cursorColor";
        public static final String MAX_LENGTH = "maxLength";
        public static final String RETURN_KEY_TYPE = "returnKeyType";
        public static final String RESIZE = "resize";
        public static final String ON_COLOR = "onColor";
        public static final String OFF_COLOR = "offColor";
        public static final String THUMB_COLOR = "thumbColor";
        public static final String MODE = "mode";
        public static final String SCROLL_DIRECTION = "scrollDirection";
        public static final String COLUMN = "column";
        public static final String LINE_SPACING = "lineSpacing";
        public static final String ITEM_SPACING = "itemSpacing";
        public static final String LEFT_SPACING = "leftSpacing";
        public static final String RIGHT_SPACING = "rightSpacing";
        public static final String TOP_SPACING = "topSpacing";
        public static final String BOTTOM_SPACING = "bottomSpacing";
        public static final String TRANSFORM = "transform";
        public static final String TRANSITION = "transition";
        public static final String TRANSITION_DELAY = "transitionDelay";
        public static final String TRANSITION_DURATION = "transitionDuration";
        public static final String TRANSITION_PROPERTY = "transitionProperty";
        public static final String TRANSITION_TIMING_FUNCTION = "transitionTimingFunction";
    }

    class Yoga {
        static final String JUSTIFY_CONTENT = "justifyContent";
        static final String ALIGN_CONTENT = "alignContent";
        static final String ALIGN_ITEMS = "alignItems";
        static final String ALIGN_SELF = "alignSelf";
        static final String ASPECT_RATIO = "aspectRatio";
        static final String BORDER = "border";
        static final String BORDER_ALL = "borderAll";
        static final String BORDER_LEFT = "borderLeft";
        static final String BORDER_RIGHT = "borderRight";
        static final String BORDER_TOP = "borderTop";
        static final String BORDER_BOTTOM = "borderBottom";
        static final String BORDER_START = "borderStart";
        static final String BORDER_END = "borderEnd";
        static final String BORDER_HORIZONTAL = "borderHorizontal";
        static final String BORDER_VERTICAL = "borderVertical";
        static final String DIRECTION = "direction";
        static final String DISPLAY = "display";
        static final String FLEX = "flex";
        static final String FLEX_BASIS = "flexBasis";
        static final String FLEX_DIRECTION = "flexDirection";
        static final String FLEX_GROW = "flexGrow";
        static final String FLEX_SHRINK = "flexShrink";
        static final String FLEX_WRAP = "flexWrap";
        static final String WIDTH = "width";
        static final String HEIGHT = "height";
        static final String MAX_WIDTH = "maxWidth";
        static final String MAX_HEIGHT = "maxHeight";
        static final String MIN_WIDTH = "minWidth";
        static final String MIN_HEIGHT = "minHeight";
        static final String MARGIN = "margin";
        static final String MARGIN_ALL = "marginAll";
        static final String MARGIN_LEFT = "marginLeft";
        static final String MARGIN_RIGHT = "marginRight";
        static final String MARGIN_TOP = "marginTop";
        static final String MARGIN_BOTTOM = "marginBottom";
        static final String MARGIN_START = "marginStart";
        static final String MARGIN_END = "marginEnd";
        static final String MARGIN_HORIZONTAL = "marginHorizontal";
        static final String MARGIN_VERTICAL = "marginVertical";
        static final String PADDING = "padding";
        static final String PADDING_ALL = "paddingAll";
        static final String PADDING_BOTTOM = "paddingBottom";
        static final String PADDING_END = "paddingEnd";
        static final String PADDING_LEFT = "paddingLeft";
        static final String PADDING_RIGHT = "paddingRight";
        static final String PADDING_START = "paddingStart";
        static final String PADDING_TOP = "paddingTop";
        static final String PADDING_HORIZONTAL = "paddingHorizontal";
        static final String PADDING_VERTICAL = "paddingVertical";
        static final String POSITION = "position";
        static final String POSITION_TYPE = "positionType";
        static final String POSITION_ALL = "positionAll";
        static final String POSITION_LEFT = "positionLeft";
        static final String POSITION_RIGHT = "positionRight";
        static final String POSITION_TOP = "positionTop";
        static final String POSITION_BOTTOM = "positionBottom";
        static final String POSITION_START = "positionStart";
        static final String POSITION_END = "positionEnd";
        static final String POSITION_HORIZONTAL = "positionHorizontal";
        static final String POSITION_VERTICAL = "positionVertical";
        static final String LEFT = "left";
        static final String RIGHT = "right";
        static final String TOP = "top";
        static final String BOTTOM = "bottom";
        static final String START = "start";
        static final String END = "end";

        Yoga() {
        }
    }
}

