/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.render.utility;

import android.graphics.Color;
import com.didi.hummer.render.utility.YogaColorUtils;

public class YogaAttrUtils {
    public static boolean isNumeric(String value) {
        return value.matches("^-?\\d+(\\.\\d+)?$");
    }

    public static boolean isPxNumeric(String value) {
        return value.matches("^-?\\d+(\\.\\d+)?(px|PX)$");
    }

    public static boolean isHmNumeric(String value) {
        return value.matches("^-?\\d+(\\.\\d+)?(hm|HM)$");
    }

    public static boolean isColor(String color) {
        return color.charAt(0) == '#' && (color.length() == 7 || color.length() == 9);
    }

    public static boolean isColor24(String color) {
        return color.charAt(0) == '#' && color.length() == 7;
    }

    public static boolean isColor32(String value) {
        return value.charAt(0) == '#' && value.length() == 9;
    }

    public static boolean isLinearGradientColor(String color) {
        return color.startsWith("linear-gradient");
    }

    public static int parseColor(String strColor) {
        int color = 0;
        try {
            color = Color.parseColor((String)strColor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (strColor.length() == 9) {
            color = YogaColorUtils.rgba2argb(color);
        }
        return color;
    }

    public static int[] parseLinearGradientColor(String strColor) {
        strColor = strColor.replace("linear-gradient(", "");
        strColor = strColor.replace("deg", "");
        strColor = strColor.replace(")", "").trim();
        String[] array = strColor.split("\\s+");
        int[] colors = new int[array.length];
        colors[0] = Integer.parseInt(array[0]) % 360;
        for (int i = 1; i < colors.length; ++i) {
            colors[i] = YogaAttrUtils.parseColor(array[i]);
        }
        return colors;
    }
}

