/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.render.utility;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Base64;
import com.didi.hummer.adapter.HummerAdapter;
import com.didi.hummer.adapter.imageloader.DrawableCallback;
import com.didi.hummer.adapter.imageloader.IImageLoaderAdapter;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.render.component.view.BackgroundDrawable;
import com.didi.hummer.render.utility.YogaResUtils;
import com.didi.hummer.utils.JsSourceUtil;

public class YogaDrawableUtil {
    public static void renderDrawable(HummerContext context, BackgroundDrawable backgroundDrawable, String imageSrc) {
        if (backgroundDrawable != null) {
            YogaDrawableUtil.loadDrawable(context, imageSrc, backgroundDrawable::setDrawable);
        }
    }

    public static void loadDrawable(HummerContext context, String imageSrc, DrawableCallback callback) {
        if (TextUtils.isEmpty((CharSequence)imageSrc)) {
            if (callback != null) {
                callback.onDrawableLoaded(null);
            }
            return;
        }
        if (YogaDrawableUtil.isRemoteImage(imageSrc)) {
            YogaDrawableUtil.loadRemoteDrawable(context, imageSrc, callback);
        } else if (YogaDrawableUtil.isLocalAbsoluteImage(imageSrc)) {
            YogaDrawableUtil.loadLocalDrawable(context, imageSrc, callback);
        } else if (YogaDrawableUtil.isLocalRelativeImage(imageSrc)) {
            int jsSourceType = JsSourceUtil.getJsSourceType(context.getJsSourcePath());
            imageSrc = JsSourceUtil.getRealResourcePath(imageSrc, context.getJsSourcePath());
            switch (jsSourceType) {
                case 1: {
                    YogaDrawableUtil.loadAssetsDrawable(context, imageSrc, callback);
                    break;
                }
                case 2: {
                    YogaDrawableUtil.loadLocalDrawable(context, imageSrc, callback);
                    break;
                }
                case 3: {
                    YogaDrawableUtil.loadRemoteDrawable(context, imageSrc, callback);
                    break;
                }
            }
        } else if (YogaDrawableUtil.isBase64Image(imageSrc)) {
            YogaDrawableUtil.loadBase64Drawable(imageSrc, callback);
        } else {
            YogaDrawableUtil.loadResourceDrawable(context, imageSrc, callback);
        }
    }

    private static boolean isRemoteImage(String imageSrc) {
        return imageSrc != null && (imageSrc.startsWith("//") || imageSrc.toLowerCase().startsWith("http"));
    }

    private static boolean isLocalAbsoluteImage(String imageSrc) {
        return imageSrc != null && imageSrc.startsWith("/");
    }

    private static boolean isLocalRelativeImage(String imageSrc) {
        return imageSrc != null && imageSrc.startsWith("./");
    }

    private static boolean isBase64Image(String imageSrc) {
        return imageSrc != null && (imageSrc.contains("base64") || imageSrc.contains("BASE64"));
    }

    private static String fitRemoteUrl(String url) {
        if (!TextUtils.isEmpty((CharSequence)url) && url.startsWith("//")) {
            url = "https:" + url;
        }
        return url;
    }

    private static void loadRemoteDrawable(HummerContext context, String imageSrc, DrawableCallback callback) {
        if (TextUtils.isEmpty((CharSequence)imageSrc)) {
            return;
        }
        YogaDrawableUtil.getImageLoader(context).loadDrawable(YogaDrawableUtil.fitRemoteUrl(imageSrc), callback);
    }

    private static void loadLocalDrawable(HummerContext context, String imageSrc, DrawableCallback callback) {
        YogaDrawableUtil.getImageLoader(context).loadDrawable(imageSrc, callback);
    }

    private static void loadAssetsDrawable(HummerContext context, String imageSrc, DrawableCallback callback) {
        imageSrc = "file:///android_asset/" + imageSrc;
        YogaDrawableUtil.getImageLoader(context).loadDrawable(imageSrc, callback);
    }

    private static void loadBase64Drawable(String imageSrc, DrawableCallback callback) {
        BitmapDrawable drawable = null;
        try {
            byte[] bitmapArray = Base64.decode((String)imageSrc.split(",")[1], (int)0);
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])bitmapArray, (int)0, (int)bitmapArray.length);
            drawable = new BitmapDrawable(bitmap);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (callback != null) {
            callback.onDrawableLoaded((Drawable)drawable);
        }
    }

    private static void loadResourceDrawable(HummerContext context, String imageSrc, DrawableCallback callback) {
        int imageId = YogaResUtils.getResourceId(imageSrc, "drawable", null);
        YogaDrawableUtil.getImageLoader(context).loadDrawable(imageId, callback);
    }

    private static IImageLoaderAdapter getImageLoader(HummerContext context) {
        return HummerAdapter.getImageLoaderAdapter(context.getNamespace());
    }
}

