/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.thread;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;

public class JSThread
extends HandlerThread {
    private Handler mHandler;

    public JSThread(String name) {
        super(name);
        this.start();
        this.mHandler = new Handler(this.getLooper());
    }

    public JSThread(String name, int priority) {
        super(name, priority);
        this.start();
        this.mHandler = new Handler(this.getLooper());
    }

    public JSThread(String name, Handler.Callback callback) {
        super(name);
        this.start();
        this.mHandler = new Handler(this.getLooper(), JSThread.postCallback(callback));
    }

    public JSThread(String name, int priority, Handler.Callback callback) {
        super(name, priority);
        this.start();
        this.mHandler = new Handler(this.getLooper(), JSThread.postCallback(callback));
    }

    public static Runnable postRunnable(Runnable runnable) {
        if (runnable == null || runnable instanceof SafeRunnable) {
            return runnable;
        }
        return new SafeRunnable(runnable);
    }

    public static Handler.Callback postCallback(Handler.Callback callback) {
        if (callback == null || callback instanceof SafeCallback) {
            return callback;
        }
        return new SafeCallback(callback);
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    public boolean isThreadAlive() {
        return this.mHandler != null && this.getLooper() != null && this.isAlive();
    }

    public boolean quit() {
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        return super.quit();
    }

    static class SafeCallback
    implements Handler.Callback {
        final Handler.Callback mCallback;

        SafeCallback(Handler.Callback cb) {
            this.mCallback = cb;
        }

        public boolean handleMessage(Message msg) {
            boolean result = false;
            try {
                if (this.mCallback != null) {
                    result = this.mCallback.handleMessage(msg);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return result;
        }
    }

    static class SafeRunnable
    implements Runnable {
        final Runnable mTask;

        SafeRunnable(Runnable task) {
            this.mTask = task;
        }

        @Override
        public void run() {
            try {
                if (this.mTask != null) {
                    this.mTask.run();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

