/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.tools;

import com.didi.hummer.HummerSDK;
import com.didi.hummer.core.util.HMLog;

public class JSLogger {
    private static final String TAG = "HummerJS";

    public static void log(String namespace, String msg) {
        HMLog.v((String)TAG, (String)msg);
        JSLogger.printLog(namespace, 1, msg);
    }

    public static void debug(String namespace, String msg) {
        HMLog.d((String)TAG, (String)msg);
        JSLogger.printLog(namespace, 2, msg);
    }

    public static void info(String namespace, String msg) {
        HMLog.i((String)TAG, (String)msg);
        JSLogger.printLog(namespace, 3, msg);
    }

    public static void warn(String namespace, String msg) {
        HMLog.w((String)TAG, (String)msg);
        JSLogger.printLog(namespace, 4, msg);
    }

    public static void error(String namespace, String msg) {
        HMLog.e((String)TAG, (String)msg);
        JSLogger.printLog(namespace, 5, msg);
    }

    private static void printLog(String namespace, int level, String msg) {
        Logger logger = HummerSDK.getJSLogger(namespace);
        if (logger != null) {
            logger.log(level, msg);
        }
    }

    public static interface Logger {
        public static final int VERBOSE = 1;
        public static final int DEBUG = 2;
        public static final int INFO = 3;
        public static final int WARN = 4;
        public static final int ERROR = 5;

        public void log(int var1, String var2);
    }
}

