/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.utils;

import android.text.TextUtils;

public class JsSourceUtil {
    public static final String JS_SOURCE_PREFIX_ASSETS = "assets:///";
    public static final String JS_SOURCE_PREFIX_FILE = "file:///";
    public static final String JS_SOURCE_PREFIX_HTTP = "http";
    public static final int JS_SOURCE_TYPE_UNKNOWN = 0;
    public static final int JS_SOURCE_TYPE_ASSETS = 1;
    public static final int JS_SOURCE_TYPE_FILE = 2;
    public static final int JS_SOURCE_TYPE_HTTP = 3;

    public static int getJsSourceType(String jsSourcePath) {
        if (TextUtils.isEmpty((CharSequence)jsSourcePath)) {
            return 0;
        }
        if ((jsSourcePath = jsSourcePath.toLowerCase()).startsWith(JS_SOURCE_PREFIX_ASSETS)) {
            return 1;
        }
        if (jsSourcePath.startsWith(JS_SOURCE_PREFIX_FILE)) {
            return 2;
        }
        if (jsSourcePath.startsWith(JS_SOURCE_PREFIX_HTTP)) {
            return 3;
        }
        return 0;
    }

    public static String getPathDir(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return "";
        }
        int lastIndex = path.lastIndexOf("/");
        if (lastIndex < 0) {
            return "";
        }
        return path.substring(0, lastIndex + 1);
    }

    public static String relativePath2AbsolutePath(String relativePath, String referAbsolutePath) {
        if (TextUtils.isEmpty((CharSequence)relativePath) || TextUtils.isEmpty((CharSequence)referAbsolutePath)) {
            return relativePath;
        }
        if (!relativePath.startsWith("./")) {
            return relativePath;
        }
        String pathDir = JsSourceUtil.getPathDir(referAbsolutePath);
        if (TextUtils.isEmpty((CharSequence)pathDir)) {
            return relativePath.substring(2);
        }
        return pathDir + relativePath.substring(2);
    }

    public static String getRealResourcePath(String relativePath, String jsSourcePath) {
        if (TextUtils.isEmpty((CharSequence)relativePath) || TextUtils.isEmpty((CharSequence)jsSourcePath)) {
            return relativePath;
        }
        if (!relativePath.startsWith("./")) {
            return relativePath;
        }
        String jsSourceDir = JsSourceUtil.getPathDir(jsSourcePath);
        if (TextUtils.isEmpty((CharSequence)jsSourceDir)) {
            return relativePath;
        }
        String realPath = relativePath.substring(2);
        int jsSourceType = JsSourceUtil.getJsSourceType(jsSourcePath);
        switch (jsSourceType) {
            case 1: {
                jsSourceDir = jsSourceDir.substring(JS_SOURCE_PREFIX_ASSETS.length());
                realPath = jsSourceDir + realPath;
                break;
            }
            case 2: {
                jsSourceDir = jsSourceDir.substring(JS_SOURCE_PREFIX_FILE.length() - 1);
                realPath = jsSourceDir + realPath;
                break;
            }
            case 3: {
                realPath = jsSourceDir + realPath;
            }
        }
        return realPath;
    }
}

