/*
 * Decompiled with CFR 0.152.
 */
package com.diduweiwu.processor.contract;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.diduweiwu.processor.contract.ValueConsumer;
import com.diduweiwu.util.ExtractUtil;
import io.restassured.specification.RequestSpecification;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;

public interface IProcessor {
    default public void executeSingValue(Object api, AnnotatedElement element, Class<? extends Annotation> annotationType, ValueConsumer valueConsumer) {
        valueConsumer.execute(this.executeValue(api, element, annotationType));
    }

    default public Object executeValue(Object api, AnnotatedElement element, Class<? extends Annotation> annotationType) {
        AtomicReference atmoicValue = new AtomicReference();
        ExtractUtil.extractFieldValue(api, element, (fieldKey, fieldValue) -> {
            if (ObjectUtil.isNotEmpty((Object)fieldValue)) {
                atmoicValue.set(fieldValue);
            }
        });
        ExtractUtil.extractMethodValue(api, element, (methodKey, methodValue) -> {
            if (ObjectUtil.isNotEmpty((Object)methodValue)) {
                atmoicValue.set(methodValue);
            }
        });
        ExtractUtil.extractAnnotationFieldValue(element, annotationType, "value", (annotationKey, annotationValue) -> {
            if (ObjectUtil.isNotEmpty((Object)annotationValue)) {
                atmoicValue.set(annotationValue);
            }
        });
        Object value = atmoicValue.get();
        String annotationName = annotationType.getName();
        Assert.notNull(value, (String)"{} \u7684value\u914d\u7f6e\u9519\u8bef,\u8bf7\u68c0\u67e5", (Object[])new Object[]{annotationName});
        return value;
    }

    default public Object executeKey(Object api, AnnotatedElement element, Class<? extends Annotation> annotationType) {
        AtomicReference atmoicKey = new AtomicReference();
        ExtractUtil.extractFieldValue(api, element, (fieldKey, fieldValue) -> {
            if (ObjectUtil.isNotEmpty((Object)fieldKey)) {
                atmoicKey.set(fieldKey);
            }
        });
        ExtractUtil.extractMethodValue(api, element, (methodKey, methodValue) -> {
            if (ObjectUtil.isNotEmpty((Object)methodKey)) {
                atmoicKey.set(methodKey);
            }
        });
        ExtractUtil.extractAnnotationFieldValue(element, annotationType, "key", (annotationKey, annotationValue) -> {
            if (ObjectUtil.isNotEmpty((Object)annotationKey)) {
                atmoicKey.set(annotationKey);
            }
        });
        Object key = atmoicKey.get();
        String annotationName = annotationType.getName();
        Assert.notNull(key, (String)"{} \u7684Key\u914d\u7f6e\u9519\u8bef,\u8bf7\u68c0\u67e5", (Object[])new Object[]{annotationName});
        return key;
    }

    default public void execute(Object api, AnnotatedElement element, Class<? extends Annotation> annotationType, BiConsumer<String, Object> keyValueConsumer) {
        Object key = this.executeKey(api, element, annotationType);
        Object value = this.executeValue(api, element, annotationType);
        keyValueConsumer.accept(String.valueOf(key), value);
    }

    default public void execute(Object api, AnnotatedElement element, Class<? extends Annotation> clazzAnnotation, RequestSpecification request) {
    }
}

