/*
 * Decompiled with CFR 0.152.
 */
package com.diduweiwu.util;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.util.ReflectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.BiConsumer;

public class ExtractUtil {
    public static void extractFieldValue(Object api, AnnotatedElement element, BiConsumer<String, Object> fieldValueConsumer) {
        String fieldName = "";
        Object fieldValue = null;
        if (element instanceof Field) {
            Field field = (Field)element;
            fieldName = field.getName();
            fieldValue = ReflectUtil.getFieldValue((Object)api, (String)fieldName);
        }
        fieldValueConsumer.accept(fieldName, fieldValue);
    }

    public static void extractMethodValue(Object api, AnnotatedElement element, BiConsumer<String, Object> methodValueConsumer) {
        String methodName = "";
        Object methodValue = null;
        if (element instanceof Method) {
            Method method = (Method)element;
            methodValue = ReflectUtil.invoke((Object)api, (Method)method, (Object[])new Object[0]);
        }
        methodValueConsumer.accept(methodName, methodValue);
    }

    public static void extractAnnotationFieldValue(AnnotatedElement element, Class<? extends Annotation> annotationType, String fieldName, BiConsumer<String, Object> annotationValueConsumer) {
        Map annotationValueMap = AnnotationUtil.getAnnotationValueMap((AnnotatedElement)element, annotationType);
        Object annotationValue = annotationValueMap.get(fieldName);
        annotationValueConsumer.accept(fieldName, annotationValue);
    }
}

