/*
 * Decompiled with CFR 0.152.
 */
package com.diduweiwu.util;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ReflectUtil;
import com.diduweiwu.annotation.Delete;
import com.diduweiwu.annotation.Get;
import com.diduweiwu.annotation.IAnnotation;
import com.diduweiwu.annotation.Options;
import com.diduweiwu.annotation.Post;
import com.diduweiwu.annotation.Put;
import com.diduweiwu.processor.contract.IPostCheck;
import com.diduweiwu.processor.contract.IProcessor;
import com.diduweiwu.processor.contract.ISetUp;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RequestUtil {
    public static Response send(Object api) {
        return RequestUtil.sendWithSetUps(api, Collections.emptyList());
    }

    public static Response send(Object api, ISetUp iSetUp) {
        return RequestUtil.sendWithSetUps(api, ListUtil.of((Object[])new ISetUp[]{iSetUp}));
    }

    public static Response send(Object api, IPostCheck iPostCheck) {
        return RequestUtil.send(api, ListUtil.empty(), ListUtil.of((Object[])new IPostCheck[]{iPostCheck}));
    }

    public static Response sendWithChecks(Object api, List<IPostCheck> iPostChecks) {
        return RequestUtil.send(api, ListUtil.empty(), iPostChecks);
    }

    public static Response send(Object api, ISetUp iSetUp, IPostCheck iPostCheck) {
        return RequestUtil.send(api, ListUtil.of((Object[])new ISetUp[]{iSetUp}), ListUtil.of((Object[])new IPostCheck[]{iPostCheck}));
    }

    public static Response send(Object api, List<ISetUp> iSetUps, List<IPostCheck> iPostChecks) {
        Response response = RequestUtil.sendWithSetUps(api, iSetUps);
        if (CollectionUtil.isNotEmpty(iPostChecks)) {
            iPostChecks.forEach(postCheck -> postCheck.execute(response));
        }
        return response;
    }

    public static Response sendWithSetUps(Object api, List<ISetUp> iSetUps) {
        Class<?> clazz = api.getClass();
        if (AnnotationUtil.hasAnnotation(clazz, Get.class)) {
            return RequestUtil.get(api, iSetUps);
        }
        if (AnnotationUtil.hasAnnotation(clazz, Post.class)) {
            return RequestUtil.post(api, iSetUps);
        }
        if (AnnotationUtil.hasAnnotation(clazz, Put.class)) {
            return RequestUtil.put(api, iSetUps);
        }
        if (AnnotationUtil.hasAnnotation(clazz, Delete.class)) {
            return RequestUtil.delete(api, iSetUps);
        }
        if (AnnotationUtil.hasAnnotation(clazz, Options.class)) {
            return RequestUtil.options(api, iSetUps);
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u7c7b\u578b");
    }

    public static RequestSpecification composeRequest(Object api, List<ISetUp> iSetUps) {
        Assert.notNull((Object)api, (String)"\u63a5\u53e3\u5bf9\u8c61\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        RequestSpecification request = RestAssured.given();
        RequestUtil.analyzeClazz(api, request);
        RequestUtil.analyzeFields(api, request);
        RequestUtil.analyzeMethods(api, request);
        if (CollectionUtil.isNotEmpty(iSetUps)) {
            iSetUps.forEach(setUp -> setUp.execute(request));
        }
        return request;
    }

    public static Response get(Object api, List<ISetUp> iSetUps) {
        return (Response)RequestUtil.composeRequest(api, iSetUps).get();
    }

    public static Response post(Object api, List<ISetUp> iSetUps) {
        return (Response)RequestUtil.composeRequest(api, iSetUps).post();
    }

    public static Response put(Object api, List<ISetUp> iSetUps) {
        return (Response)RequestUtil.composeRequest(api, iSetUps).put();
    }

    public static Response delete(Object api, List<ISetUp> iSetUps) {
        return (Response)RequestUtil.composeRequest(api, iSetUps).delete();
    }

    public static Response options(Object api, List<ISetUp> iSetUps) {
        return (Response)RequestUtil.composeRequest(api, iSetUps).options();
    }

    public static Response get(Object api) {
        return (Response)RequestUtil.composeRequest(api, Collections.emptyList()).get();
    }

    public static Response post(Object api) {
        return (Response)RequestUtil.composeRequest(api, Collections.emptyList()).post();
    }

    public static Response put(Object api) {
        return (Response)RequestUtil.composeRequest(api, Collections.emptyList()).put();
    }

    public static Response delete(Object api) {
        return (Response)RequestUtil.composeRequest(api, Collections.emptyList()).delete();
    }

    public static Response options(Object api) {
        return (Response)RequestUtil.composeRequest(api, Collections.emptyList()).options();
    }

    private static void analyzeClazz(Object o, RequestSpecification request) {
        RequestUtil.analyzeAnnotation(o, o.getClass(), request);
    }

    private static void analyzeAnnotation(Object o, AnnotatedElement element, RequestSpecification request) {
        Annotation[] clazzAnnotations;
        for (Annotation clazzAnnotation : clazzAnnotations = AnnotationUtil.getAnnotations((AnnotatedElement)element, (boolean)true)) {
            if (!AnnotationUtil.hasAnnotation(clazzAnnotation.annotationType(), IAnnotation.class)) continue;
            Map annotationValueMap = AnnotationUtil.getAnnotationValueMap((AnnotatedElement)element, clazzAnnotation.annotationType());
            Class processorClazz = (Class)annotationValueMap.get("processor");
            Assert.notNull((Object)processorClazz, (String)String.format("%s\u4e2d\u672a\u627e\u5230Processor\u914d\u7f6e", clazzAnnotation.annotationType().getName()), (Object[])new Object[0]);
            ((IProcessor)ReflectUtil.newInstance((Class)processorClazz, (Object[])new Object[0])).execute(o, element, clazzAnnotation.annotationType(), request);
        }
    }

    private static void analyzeFields(Object o, RequestSpecification request) {
        Field[] fields;
        for (Field field : fields = o.getClass().getDeclaredFields()) {
            RequestUtil.analyzeAnnotation(o, field, request);
        }
    }

    private static void analyzeMethods(Object o, RequestSpecification request) {
        Method[] methods;
        for (Method method : methods = o.getClass().getDeclaredMethods()) {
            RequestUtil.analyzeAnnotation(o, method, request);
        }
    }
}

