/*
 * Decompiled with CFR 0.152.
 */
package com.digma.otel.instrumentation.spring.autoconfigure.resources;

import com.digma.otel.instrumentation.common.DigmaCommon;
import com.digma.otel.instrumentation.common.DigmaSemanticAttributes;
import com.digma.otel.instrumentation.spring.autoconfigure.resources.DigmaResourceProperties;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.resources.Resource;
import org.springframework.util.StringUtils;

public class DigmaResourceProvider
implements ResourceProvider {
    private final DigmaResourceProperties digmaResourceProperties;

    public DigmaResourceProvider(DigmaResourceProperties digmaResourceProperties) {
        this.digmaResourceProperties = digmaResourceProperties;
    }

    public Resource createResource(ConfigProperties config) {
        String envVal = this.evaluateEnvironment();
        Attributes attrs = Attributes.of((AttributeKey)DigmaSemanticAttributes.DIGMA_ENVIRONMENT, (Object)envVal);
        return Resource.create((Attributes)attrs, (String)"https://opentelemetry.io/schemas/1.13.0");
    }

    private String evaluateEnvironment() {
        String cfgValue = this.digmaResourceProperties.getEnvironment();
        if (StringUtils.hasText((String)cfgValue)) {
            return cfgValue;
        }
        return DigmaCommon.evaluateEnvironment();
    }
}

