/*
 * Decompiled with CFR 0.152.
 */
package com.digma.otel.instrumentation.spring.autoconfigure.webmvc;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
class CodeAttributesToRequestMappingAspect {
    CodeAttributesToRequestMappingAspect() {
    }

    protected Object processCommonMapping(ProceedingJoinPoint pjp) throws Throwable {
        Span currentSpan = Span.current();
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Method method = methodSignature.getMethod();
        Class<?> classOfMethod = method.getDeclaringClass();
        currentSpan.setAttribute(SemanticAttributes.CODE_NAMESPACE, (Object)classOfMethod.getName());
        currentSpan.setAttribute(SemanticAttributes.CODE_FUNCTION, (Object)method.getName());
        return pjp.proceed();
    }

    @Around(value="@annotation(org.springframework.web.bind.annotation.GetMapping)")
    public Object processGetMapping(ProceedingJoinPoint pjp) throws Throwable {
        return this.processCommonMapping(pjp);
    }

    @Around(value="@annotation(org.springframework.web.bind.annotation.PostMapping)")
    public Object processPostMapping(ProceedingJoinPoint pjp) throws Throwable {
        return this.processCommonMapping(pjp);
    }

    @Around(value="@annotation(org.springframework.web.bind.annotation.DeleteMapping)")
    public Object processDeleteMapping(ProceedingJoinPoint pjp) throws Throwable {
        return this.processCommonMapping(pjp);
    }

    @Around(value="@annotation(org.springframework.web.bind.annotation.PutMapping)")
    public Object processPutMapping(ProceedingJoinPoint pjp) throws Throwable {
        return this.processCommonMapping(pjp);
    }

    @Around(value="@annotation(org.springframework.web.bind.annotation.PatchMapping)")
    public Object processPatchMapping(ProceedingJoinPoint pjp) throws Throwable {
        return this.processCommonMapping(pjp);
    }
}

