/*
 * Decompiled with CFR 0.152.
 */
package com.digma.springboot.otlp.autoconf;

import com.digma.springboot.otlp.autoconf.DigmaOpenTelemetryProperties;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import org.springframework.core.env.Environment;

public final class DigmaOtelSpringBootCommon {
    protected static final String DEFAULT_APPLICATION_NAME = "application";
    protected static final AttributeKey<String> ATTRIBUTE_KEY_SERVICE_NAME = AttributeKey.stringKey((String)"service.name");

    protected static Resource openTelemetryResourceAsInSpring3dot2(Environment environment, DigmaOpenTelemetryProperties properties) {
        String applicationName = environment.getProperty("spring.application.name", DEFAULT_APPLICATION_NAME);
        return Resource.getDefault().merge(Resource.create((Attributes)Attributes.of(ATTRIBUTE_KEY_SERVICE_NAME, (Object)applicationName))).merge(DigmaOtelSpringBootCommon.toResource(properties));
    }

    protected static Resource toResource(DigmaOpenTelemetryProperties properties) {
        ResourceBuilder builder = Resource.builder();
        properties.getResourceAttributes().forEach((arg_0, arg_1) -> ((ResourceBuilder)builder).put(arg_0, arg_1));
        return builder.build();
    }
}

