/*
 * Decompiled with CFR 0.152.
 */
package com.digma.springboot.otlp.autoconf;

import com.digma.springboot.otlp.autoconf.DigmaOpenTelemetryProperties;
import com.digma.springboot.otlp.autoconf.DigmaOtelSpringBootCommon;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.Objects;
import java.util.stream.Stream;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;

@AutoConfiguration
@ConditionalOnClass(value={OpenTelemetrySdk.class})
@EnableConfigurationProperties(value={DigmaOpenTelemetryProperties.class})
public class DigmaOtelSpringBootVersion3dot0AutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"org.springframework.boot.actuate.autoconfigure.tracing.SdkTracerProviderBuilderCustomizer"})
    static class SpringBoot3dot0Configuration {
        SpringBoot3dot0Configuration() {
        }

        @Bean
        @Primary
        SdkTracerProvider sb3dot0OtelSdkTracerProvider(Environment environment, ObjectProvider<SpanProcessor> spanProcessors, Sampler sampler, DigmaOpenTelemetryProperties properties) {
            Resource springResource = DigmaOtelSpringBootCommon.openTelemetryResourceAsInSpring3dot2(environment, properties);
            SdkTracerProviderBuilder builder = SdkTracerProvider.builder().setSampler(sampler).setResource(Resource.getDefault().merge(springResource));
            Stream var10000 = spanProcessors.orderedStream();
            Objects.requireNonNull(builder);
            var10000.forEach(arg_0 -> ((SdkTracerProviderBuilder)builder).addSpanProcessor(arg_0));
            return builder.build();
        }
    }
}

