/*
 * Decompiled with CFR 0.152.
 */
package com.digma.springboot.otlp.autoconf;

import com.digma.springboot.otlp.autoconf.DigmaOpenTelemetryProperties;
import com.digma.springboot.otlp.autoconf.DigmaOtelSpringBootCommon;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import org.springframework.boot.actuate.autoconfigure.tracing.SdkTracerProviderBuilderCustomizer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@AutoConfiguration
@ConditionalOnClass(name={"org.springframework.boot.actuate.autoconfigure.tracing.SdkTracerProviderBuilderCustomizer", "io.opentelemetry.sdk.OpenTelemetrySdk"})
@EnableConfigurationProperties(value={DigmaOpenTelemetryProperties.class})
public class DigmaOtelSpringBootVersion3dot1AutoConfiguration {
    @Bean
    @ConditionalOnMissingClass(value={"org.springframework.boot.actuate.autoconfigure.opentelemetry.OpenTelemetryProperties"})
    SdkTracerProviderBuilderCustomizer otelSdkTracerProviderBuilderCustomizer(Environment environment, DigmaOpenTelemetryProperties properties) {
        return new ResourceAttributesSdkCustomizer(environment, properties);
    }

    static class ResourceAttributesSdkCustomizer
    implements SdkTracerProviderBuilderCustomizer {
        Environment environment;
        DigmaOpenTelemetryProperties properties;

        public ResourceAttributesSdkCustomizer(Environment environment, DigmaOpenTelemetryProperties properties) {
            this.environment = environment;
            this.properties = properties;
        }

        public void customize(SdkTracerProviderBuilder builder) {
            Resource resource = DigmaOtelSpringBootCommon.openTelemetryResourceAsInSpring3dot2(this.environment, this.properties);
            builder.setResource(resource);
        }
    }
}

