/*
 * Decompiled with CFR 0.152.
 */
package io.github.domainprimitives.object;

import io.github.domainprimitives.validation.InvariantException;
import java.util.ArrayList;
import java.util.List;

public abstract class DomainObject {
    private final List<String> violations = new ArrayList<String>();

    protected DomainObject() {
    }

    protected abstract void validate();

    protected void validateNotNull(Object field, String label) {
        if (field == null) {
            this.violations.add(String.format("%s should not be null", label));
        }
    }

    protected void addInvariantViolation(String violation) {
        this.violations.add(violation);
    }

    protected void evaluateValidations(String name) throws InvariantException {
        if (!this.violations.isEmpty()) {
            throw new InvariantException(name, this.violations);
        }
    }

    protected void evaluateValidations() throws InvariantException {
        this.evaluateValidations(this.getClass().getSimpleName());
    }
}

