/*
 * Decompiled with CFR 0.152.
 */
package io.github.domainprimitives.validation;

import io.github.domainprimitives.validation.Validation;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.function.Consumer;

public class Constraints {
    private static final String NULL = "null";
    private static final String NULL_ERROR_MESSAGE_TEMPLATE = "%s should not be null";
    private static final String ERROR_MESSAGE_RANGE_TEMPLATE = "%s should be between %s and %s";
    private static final String ERROR_MESSAGE_GREATER_THAN_TEMPLATE = "%s should be greater then %s";
    private static final String ERROR_MESSAGE_LESS_THAN_TEMPLATE = "%s should be less then %s";
    private static final String ERROR_MESSAGE_IN_FUTURE_TEMPLATE = "%s should be in the future";
    private static final String ERROR_MESSAGE_IN_PAST_TEMPLATE = "%s should be in the past";
    private static final String UUID_PATTERN = "[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}";

    private Constraints() {
    }

    public static Consumer<Validation<String>> isNotNull() {
        return val -> val.constraint(Constraints.isNotNull(val.value()), () -> String.format(NULL_ERROR_MESSAGE_TEMPLATE, Constraints.getValueFormatted(val)));
    }

    public static Consumer<Validation<String>> isNotBlank() {
        return val -> val.constraint(Constraints.isNotBlank((String)val.value()), () -> String.format("%s should not be blank", Constraints.getValueFormatted(val)));
    }

    private static boolean isNotBlank(String value) {
        return Constraints.isNotNull(value) && !value.trim().isEmpty();
    }

    public static Consumer<Validation<String>> isPattern(String pattern) {
        return val -> val.constraint(Constraints.isValidPattern((String)val.value(), pattern), () -> String.format("%s should match the pattern %s", Constraints.getValueFormatted(val), pattern));
    }

    private static boolean isValidPattern(String value, String pattern) {
        return Constraints.isNotNull(value) && value.matches(pattern);
    }

    public static Consumer<Validation<String>> hasMinLength(int minLength) {
        return val -> val.constraint(Constraints.hasMinLength((String)val.value(), minLength), () -> String.format("%s should be longer than %s", Constraints.getValueFormatted(val), minLength));
    }

    private static boolean hasMinLength(String value, int minLength) {
        return Constraints.isNotNull(value) && value.length() >= minLength;
    }

    public static Consumer<Validation<String>> hasMaxLength(int maxLength) {
        return val -> val.constraint(Constraints.hasMaxLength((String)val.value(), maxLength), () -> String.format("%s should not be longer than %s", Constraints.getValueFormatted(val), maxLength));
    }

    private static boolean hasMaxLength(String value, int maxLength) {
        return Constraints.isNotNull(value) && value.length() <= maxLength;
    }

    public static Consumer<Validation<String>> isBetween(int minLength, int maxLength) {
        return val -> val.constraint(Constraints.hasMinLength((String)val.value(), minLength) && Constraints.hasMaxLength((String)val.value(), maxLength), () -> String.format(ERROR_MESSAGE_RANGE_TEMPLATE, Constraints.getValueFormatted(val), minLength, maxLength));
    }

    public static Consumer<Validation<String>> isUUID() {
        return val -> val.constraint(Constraints.isValidPattern((String)val.value(), UUID_PATTERN), () -> String.format("%s should be a UUID", Constraints.getValueFormatted(val)));
    }

    public static Consumer<Validation<Integer>> isNotNullInteger() {
        return val -> val.constraint(Constraints.isNotNull(val.value()), () -> String.format(NULL_ERROR_MESSAGE_TEMPLATE, Constraints.getValueFormatted(val)));
    }

    public static Consumer<Validation<Integer>> isGreatThanOrEqual(Integer minSize) {
        return val -> val.constraint(Constraints.isGreatThanOrEqual((Integer)val.value(), minSize), () -> String.format(ERROR_MESSAGE_GREATER_THAN_TEMPLATE, Constraints.getValueFormatted(val), minSize));
    }

    private static boolean isGreatThanOrEqual(Integer value, Integer minSize) {
        return Constraints.isNotNull(value) && value >= minSize;
    }

    public static Consumer<Validation<Integer>> isLessThanOrEqual(Integer maxSize) {
        return val -> val.constraint(Constraints.isLessThanOrEqual((Integer)val.value(), maxSize), () -> String.format(ERROR_MESSAGE_LESS_THAN_TEMPLATE, Constraints.getValueFormatted(val), maxSize));
    }

    private static boolean isLessThanOrEqual(Integer value, Integer maxSize) {
        return Constraints.isNotNull(value) && value <= maxSize;
    }

    public static Consumer<Validation<Integer>> isInRange(Integer minSize, Integer maxSize) {
        return val -> val.constraint(Constraints.isGreatThanOrEqual((Integer)val.value(), minSize) && Constraints.isLessThanOrEqual((Integer)val.value(), maxSize), () -> String.format(ERROR_MESSAGE_RANGE_TEMPLATE, Constraints.getValueFormatted(val), minSize, maxSize));
    }

    public static Consumer<Validation<Long>> isNotNullLong() {
        return val -> val.constraint(Constraints.isNotNull(val.value()), () -> String.format(NULL_ERROR_MESSAGE_TEMPLATE, Constraints.getValueFormatted(val)));
    }

    public static Consumer<Validation<Long>> isGreatThanOrEqual(Long minSize) {
        return val -> val.constraint(Constraints.isGreatThanOrEqual((Long)val.value(), minSize), () -> String.format(ERROR_MESSAGE_GREATER_THAN_TEMPLATE, Constraints.getValueFormatted(val), minSize));
    }

    private static boolean isGreatThanOrEqual(Long value, Long minSize) {
        return Constraints.isNotNull(value) && value >= minSize;
    }

    public static Consumer<Validation<Long>> isLessThanOrEqual(Long maxSize) {
        return val -> val.constraint(Constraints.isLessThanOrEqual((Long)val.value(), maxSize), () -> String.format(ERROR_MESSAGE_LESS_THAN_TEMPLATE, Constraints.getValueFormatted(val), maxSize));
    }

    private static boolean isLessThanOrEqual(Long value, Long maxSize) {
        return Constraints.isNotNull(value) && value <= maxSize;
    }

    public static Consumer<Validation<Long>> isBetween(Long minSize, Long maxSize) {
        return val -> val.constraint(Constraints.isGreatThanOrEqual((Long)val.value(), minSize) && Constraints.isLessThanOrEqual((Long)val.value(), maxSize), () -> String.format(ERROR_MESSAGE_RANGE_TEMPLATE, Constraints.getValueFormatted(val), minSize, maxSize));
    }

    public static Consumer<Validation<Double>> isNotNullDouble() {
        return val -> val.constraint(Constraints.isNotNull(val.value()), () -> String.format(NULL_ERROR_MESSAGE_TEMPLATE, Constraints.getValueFormatted(val)));
    }

    public static Consumer<Validation<Double>> isGreatThanOrEqual(Double minSize) {
        return val -> val.constraint(Constraints.isGreatThanOrEqual((Double)val.value(), minSize), () -> String.format(ERROR_MESSAGE_GREATER_THAN_TEMPLATE, Constraints.getValueFormatted(val), minSize));
    }

    private static boolean isGreatThanOrEqual(Double value, Double minSize) {
        return Constraints.isNotNull(value) && value >= minSize;
    }

    public static Consumer<Validation<Double>> isLessThanOrEqual(Double maxSize) {
        return val -> val.constraint(Constraints.isLessThanOrEqual((Double)val.value(), maxSize), () -> String.format(ERROR_MESSAGE_LESS_THAN_TEMPLATE, Constraints.getValueFormatted(val), maxSize));
    }

    private static boolean isLessThanOrEqual(Double value, Double maxSize) {
        return Constraints.isNotNull(value) && value <= maxSize;
    }

    public static Consumer<Validation<Double>> isBetween(Double minSize, Double maxSize) {
        return val -> val.constraint(Constraints.isGreatThanOrEqual((Double)val.value(), minSize) && Constraints.isLessThanOrEqual((Double)val.value(), maxSize), () -> String.format(ERROR_MESSAGE_RANGE_TEMPLATE, Constraints.getValueFormatted(val), minSize, maxSize));
    }

    public static Consumer<Validation<Boolean>> isNotNullBoolean() {
        return val -> val.constraint(Constraints.isNotNull(val.value()), () -> String.format(NULL_ERROR_MESSAGE_TEMPLATE, Constraints.getValueFormatted(val)));
    }

    public static Consumer<Validation<Temporal>> isInFuture() {
        return val -> val.constraint(Constraints.isNotNull(val.value()) && Constraints.isInFuture((Temporal)val.value()), () -> String.format(ERROR_MESSAGE_IN_FUTURE_TEMPLATE, Constraints.getValueFormatted(val)));
    }

    public static Consumer<Validation<Temporal>> isInPast() {
        return val -> val.constraint(Constraints.isNotNull(val.value()) && Constraints.isInPast((Temporal)val.value()), () -> String.format(ERROR_MESSAGE_IN_PAST_TEMPLATE, Constraints.getValueFormatted(val)));
    }

    private static boolean isNotNull(Object value) {
        return value != null;
    }

    private static <T> String getValueFormatted(Validation<T> value) {
        String val = value != null ? String.valueOf(value.value()) : NULL;
        return "(" + val + ")";
    }

    private static boolean isInPast(Temporal temporal) {
        if (temporal instanceof LocalDate) {
            return ((LocalDate)temporal).isBefore(LocalDate.now());
        }
        if (temporal instanceof LocalDateTime) {
            return ((LocalDateTime)temporal).isBefore(LocalDateTime.now());
        }
        if (temporal instanceof LocalTime) {
            return ((LocalTime)temporal).isBefore(LocalTime.now());
        }
        if (temporal instanceof ZonedDateTime) {
            return ((ZonedDateTime)temporal).isBefore(ZonedDateTime.now());
        }
        if (temporal instanceof OffsetTime) {
            return ((OffsetTime)temporal).isBefore(OffsetTime.now());
        }
        if (temporal instanceof OffsetDateTime) {
            return ((OffsetDateTime)temporal).isBefore(OffsetDateTime.now());
        }
        throw new DateTimeException("Unsupported Temporal class: " + temporal.getClass());
    }

    private static boolean isInFuture(Temporal temporal) {
        if (temporal instanceof LocalDate) {
            return ((LocalDate)temporal).isAfter(LocalDate.now());
        }
        if (temporal instanceof LocalDateTime) {
            return ((LocalDateTime)temporal).isAfter(LocalDateTime.now());
        }
        if (temporal instanceof LocalTime) {
            return ((LocalTime)temporal).isAfter(LocalTime.now());
        }
        if (temporal instanceof ZonedDateTime) {
            return ((ZonedDateTime)temporal).isAfter(ZonedDateTime.now());
        }
        if (temporal instanceof OffsetTime) {
            return ((OffsetTime)temporal).isAfter(OffsetTime.now());
        }
        if (temporal instanceof OffsetDateTime) {
            return ((OffsetDateTime)temporal).isAfter(OffsetDateTime.now());
        }
        throw new DateTimeException("Unsupported Temporal class: " + temporal.getClass());
    }
}

