/*
 * Decompiled with CFR 0.152.
 */
package io.github.domainprimitives.validation;

import io.github.domainprimitives.validation.InvariantException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class Validation<T> {
    private final String label;
    private final T value;
    private final List<String> problems = new ArrayList<String>();

    public static <T> Consumer<Validation<T>> none() {
        return validation -> {};
    }

    public Validation(String label, T value) {
        this.label = label;
        this.value = value;
    }

    public static <T> void validate(T value, String label, Consumer<Validation<T>> validations) throws InvariantException {
        Validation<T> validation = new Validation<T>(label, value);
        validations.accept(validation);
        validation.validate();
    }

    public void addViolation(String problem) {
        this.problems.add(this.label + " " + problem);
    }

    private void validate() throws InvariantException {
        if (!this.problems.isEmpty()) {
            throw new InvariantException(this.label, this.problems);
        }
    }

    public void constraint(Boolean value, Supplier<String> descriptionSupplier) {
        if (Boolean.FALSE.equals(value)) {
            this.addViolation(descriptionSupplier.get());
        }
    }

    public T value() {
        return this.value;
    }
}

