/*
 * Decompiled with CFR 0.152.
 */
package io.github.domainprimitives.type;

import io.github.domainprimitives.validation.Validation;
import java.util.function.Consumer;

public abstract class ValueObject<T> {
    private final T value;
    private final String label;

    public ValueObject(T value) {
        this(value, Validation.none());
    }

    public ValueObject(T value, String label) {
        this(value, label, Validation.none());
    }

    public ValueObject(T value, Consumer<Validation<T>> constraints) {
        this.value = value;
        this.label = this.getClass().getSimpleName();
        this.runValidation(constraints);
    }

    public ValueObject(T value, String label, Consumer<Validation<T>> constraints) {
        this.value = value;
        this.label = label;
        this.runValidation(constraints);
    }

    private void runValidation(Consumer<Validation<T>> constraints) {
        if (!Validation.none().equals(constraints)) {
            Validation.validate(this.value, this.label, constraints);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public T getValue() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueObject valueObject = (ValueObject)o;
        if (this.value.equals(valueObject.value)) {
            return true;
        }
        if (this.value instanceof String) {
            return this.value.equals(valueObject.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

