package io.github.douira.glsl_transformer.ast.node.expression.binary;

import io.github.douira.glsl_transformer.ast.node.expression.Expression;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.traversal.*;

public class BitwiseAndExpression extends BinaryExpression {
  public BitwiseAndExpression(Expression left, Expression right) {
    super(left, right);
  }

  @Override
  public ExpressionType getExpressionType() {
    return ExpressionType.BITWISE_AND;
  }

  @Override
  public <R> R expressionAccept(ASTVisitor<R> visitor) {
    return visitor.visitBitwiseAndExpression(this);
  }

  @Override
  public void enterNode(ASTListener listener) {
    super.enterNode(listener);
    listener.enterBitwiseAndExpression(this);
  }

  @Override
  public void exitNode(ASTListener listener) {
    super.exitNode(listener);
    listener.exitBitwiseAndExpression(this);
  }

  @Override
  public BitwiseAndExpression clone() {
    return new BitwiseAndExpression(clone(left), clone(right));
  }

  @Override
  public BitwiseAndExpression cloneInto(Root root) {
    return (BitwiseAndExpression) super.cloneInto(root);
  }
}
