package io.github.douira.glsl_transformer.ast.print;

/**
 * Controls the output of the {@link ASTPrinter}.
 */
public class OutputOptions {
  private boolean printInfo;
  private String headerSuffix;
  public boolean printCustomDirectives = true;

  public OutputOptions() {
    this.printInfo = false;
    this.headerSuffix = null;
  }

  public OutputOptions(boolean printLibraryVersionInfo, String headerSuffix, boolean printCustomDirectives) {
    this.printInfo = printLibraryVersionInfo;
    this.headerSuffix = headerSuffix;
    this.printCustomDirectives = printCustomDirectives;
  }

  public void enablePrintInfo() {
    printInfo = true;
  }

  public void disablePrintInfo() {
    printInfo = false;
  }

  public void setHeaderSuffix(String headerSuffix) {
    this.headerSuffix = headerSuffix;
  }

  public String getPrintHeader() {
    if (printInfo || headerSuffix != null) {
      return "// Generated by glsl-transformer" +
          (headerSuffix == null ? "" : " " + headerSuffix) + "\n";
    }
    return null;
  }

  public OutputOptions clone() {
    return new OutputOptions(printInfo, headerSuffix, printCustomDirectives);
  }
}
