/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Predicate;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.CustomHtmlTreeBuilder;
import org.jsoup.parser.Parser;
import org.jsoup.parser.TreeBuilder;
import org.jsoup.select.Elements;

public class JsoupUtils {
    public static void selectChildren(Elements collection, Element parent, Predicate<Element> predicate) {
        for (Node node : parent.childNodes()) {
            Element child;
            if (!(node instanceof Element) || !predicate.test(child = (Element)node)) continue;
            collection.add((Object)child);
        }
    }

    public static Elements children(Element parent, String tag) {
        Elements elements = new Elements();
        JsoupUtils.selectChildren(elements, parent, c -> c.normalName().equals(tag));
        return elements;
    }

    public static Elements children(Element parent, String ... tags) {
        Elements elements = new Elements();
        HashSet<String> targets = new HashSet<String>(Arrays.asList(tags));
        JsoupUtils.selectChildren(elements, parent, c -> targets.contains(c.normalName()));
        return elements;
    }

    public static Element firstChild(Element parent, String tag) {
        for (Node node : parent.childNodes()) {
            Element child;
            if (!(node instanceof Element) || !(child = (Element)node).normalName().equals(tag)) continue;
            return child;
        }
        return null;
    }

    public static Elements childRows(Element parent) {
        Elements elements = new Elements();
        for (Node node : parent.childNodes()) {
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            if ("tr".equals(child.normalName())) {
                elements.add((Object)child);
                continue;
            }
            JsoupUtils.selectChildren(elements, child, c -> "tr".equals(c.normalName()));
        }
        return elements;
    }

    public static Document parse(String html) {
        CustomHtmlTreeBuilder treeBuilder = new CustomHtmlTreeBuilder();
        return Jsoup.parse((String)html, (Parser)new Parser((TreeBuilder)treeBuilder));
    }
}

