/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.util;

import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import java.math.BigInteger;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.TableRowAlign;
import org.apache.poi.xwpf.usermodel.TableWidthType;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.ddr.poi.html.HtmlRenderContext;
import org.ddr.poi.html.util.CSSLength;
import org.ddr.poi.html.util.CSSLengthUnit;
import org.ddr.poi.html.util.CSSStyleUtils;
import org.ddr.poi.html.util.Colors;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTAnchor;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTInline;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.STWrapText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTInd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPBdr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSpacing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTUnderline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STLineSpacingRule;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STUnderline;

public class RenderUtils {
    public static final int[] FONT_SIZE_IN_HALF_POINTS = new int[]{10, 11, 13, 15, 18, 21, 24, 28, 30, 32, 36, 44, 48, 52, 72, 84, 96, 144};
    public static final int BORDER_WIDTH_PER_PX = 4;
    public static final long MIN_BORDER_WIDTH = 2L;
    public static final long MAX_BORDER_WIDTH = 96L;
    public static final int TABLE_CELL_MARGIN = 108;
    public static final int SPACING_FACTOR = 240;

    public static ParagraphAlignment align(String textAlign) {
        if (StringUtils.isBlank((CharSequence)textAlign)) {
            return null;
        }
        switch (textAlign.toLowerCase()) {
            case "start": 
            case "left": {
                return ParagraphAlignment.LEFT;
            }
            case "end": 
            case "right": {
                return ParagraphAlignment.RIGHT;
            }
            case "center": {
                return ParagraphAlignment.CENTER;
            }
            case "justify": 
            case "justify-all": {
                return ParagraphAlignment.BOTH;
            }
        }
        return null;
    }

    public static STUnderline.Enum underline(String textDecorationStyle) {
        switch (textDecorationStyle) {
            case "double": {
                return STUnderline.DOUBLE;
            }
            case "dotted": {
                return STUnderline.DOTTED;
            }
            case "dashed": {
                return STUnderline.DASH;
            }
            case "wavy": {
                return STUnderline.WAVE;
            }
        }
        return STUnderline.SINGLE;
    }

    public static CTPPr getPPr(CTStyle ctStyle) {
        return ctStyle.isSetPPr() ? ctStyle.getPPr() : ctStyle.addNewPPr();
    }

    public static CTPPr getPPr(CTP ctp) {
        return ctp.isSetPPr() ? ctp.getPPr() : ctp.addNewPPr();
    }

    public static CTPBdr getPBdr(CTPPr pr) {
        return pr.isSetPBdr() ? pr.getPBdr() : pr.addNewPBdr();
    }

    public static CTJc getJc(CTPPr pr) {
        return pr.isSetJc() ? pr.getJc() : pr.addNewJc();
    }

    public static CTRPr getRPr(CTR ctr) {
        return ctr.isSetRPr() ? ctr.getRPr() : ctr.addNewRPr();
    }

    public static CTTcPr getTcPr(CTTc tc) {
        return tc.isSetTcPr() ? tc.getTcPr() : tc.addNewTcPr();
    }

    public static CTTcMar getTcMar(CTTcPr tcPr) {
        return tcPr.isSetTcMar() ? tcPr.getTcMar() : tcPr.addNewTcMar();
    }

    public static CTTcMar getTcMar(XWPFTableCell cell) {
        CTTcPr tcPr = RenderUtils.getTcPr(cell.getCTTc());
        return RenderUtils.getTcMar(tcPr);
    }

    public static CTShd getShd(CTPPr pPr) {
        return pPr.isSetShd() ? pPr.getShd() : pPr.addNewShd();
    }

    public static CTInd getInd(CTPPr pPr) {
        return pPr.isSetInd() ? pPr.getInd() : pPr.addNewInd();
    }

    public static CTInd getInd(XWPFParagraph paragraph) {
        CTPPr pPr = RenderUtils.getPPr(paragraph.getCTP());
        return RenderUtils.getInd(pPr);
    }

    public static CTSpacing getSpacing(CTPPr pPr) {
        return pPr.isSetSpacing() ? pPr.getSpacing() : pPr.addNewSpacing();
    }

    public static CTSpacing getSpacing(XWPFParagraph paragraph) {
        CTPPr pPr = RenderUtils.getPPr(paragraph.getCTP());
        return RenderUtils.getSpacing(pPr);
    }

    public static CTColor getColor(CTRPr rPr) {
        return rPr.isSetColor() ? rPr.getColor() : rPr.addNewColor();
    }

    public static CTUnderline getUnderline(CTRPr rPr) {
        return rPr.isSetU() ? rPr.getU() : rPr.addNewU();
    }

    public static int getAvailableWidthInEMU(IBody body) {
        if (body.getPartType() == BodyType.DOCUMENT) {
            XWPFDocument document = (XWPFDocument)body;
            CTSectPr sectPr = document.getDocument().getBody().getSectPr();
            int availableWidth = sectPr.getPgSz().getW().intValue() - sectPr.getPgMar().getLeft().intValue() - sectPr.getPgMar().getRight().intValue();
            return Units.TwipsToEMU((short)((short)availableWidth));
        }
        if (body.getPartType() == BodyType.TABLECELL) {
            XWPFTableCell tableCell = (XWPFTableCell)body;
            CTTblWidth tcW = tableCell.getCTTc().getTcPr().getTcW();
            if (TableWidthType.DXA.getStWidthType().equals(tcW.getType())) {
                int availableWidth = tcW.getW().intValue() - 216;
                return availableWidth > 0 ? Units.TwipsToEMU((short)((short)availableWidth)) : 0;
            }
            if (TableWidthType.PCT.getStWidthType().equals(tcW.getType())) {
                CTTblWidth tblW = tableCell.getTableRow().getTable().getCTTbl().getTblPr().getTblW();
                if (TableWidthType.DXA.getStWidthType().equals(tblW.getType())) {
                    int availableWidth = tblW.getW().intValue() * tcW.getW().intValue() / 5000 - 216;
                    return availableWidth > 0 ? Units.TwipsToEMU((short)((short)availableWidth)) : 0;
                }
                if (TableWidthType.NIL.getStWidthType().equals(tblW.getType())) {
                    return 0;
                }
                return Integer.MAX_VALUE;
            }
            if (TableWidthType.NIL.getStWidthType().equals(tcW.getType())) {
                return 0;
            }
            return Integer.MAX_VALUE;
        }
        throw new UnsupportedOperationException("Get bounds of " + body.getPartType() + " is not supported yet");
    }

    public static void paragraphStyle(HtmlRenderContext context, XWPFParagraph paragraph, CSSStyleDeclarationImpl cssStyleDeclaration) {
        String color;
        ParagraphAlignment align = RenderUtils.align(context.getPropertyValue("text-align"));
        if (align != null) {
            paragraph.setAlignment(align);
        }
        if (CSSStyleUtils.isEmpty(cssStyleDeclaration)) {
            return;
        }
        RenderUtils.setBorder(paragraph, cssStyleDeclaration);
        RenderUtils.setSpacing(context, paragraph, cssStyleDeclaration);
        RenderUtils.setIndentation(context, paragraph, cssStyleDeclaration);
        String backgroundColor = cssStyleDeclaration.getBackgroundColor();
        if (StringUtils.isNotBlank((CharSequence)backgroundColor) && (color = Colors.fromStyle(backgroundColor, null)) != null) {
            CTPPr pPr = RenderUtils.getPPr(paragraph.getCTP());
            CTShd shd = RenderUtils.getShd(pPr);
            shd.setFill((Object)color);
        }
    }

    private static void setSpacing(HtmlRenderContext context, XWPFParagraph paragraph, CSSStyleDeclarationImpl cssStyleDeclaration) {
        String lineHeight;
        CSSLength marginBottom;
        CSSLength marginTop = CSSLength.of(cssStyleDeclaration.getMarginTop().toLowerCase());
        if (marginTop.isValid() && !marginTop.isPercent()) {
            RenderUtils.getSpacing(paragraph).setBefore(BigInteger.valueOf(RenderUtils.emuToTwips(context.lengthToEMU(marginTop))));
        }
        if ((marginBottom = CSSLength.of(cssStyleDeclaration.getMarginBottom().toLowerCase())).isValid() && !marginBottom.isPercent()) {
            RenderUtils.getSpacing(paragraph).setAfter(BigInteger.valueOf(RenderUtils.emuToTwips(context.lengthToEMU(marginBottom))));
        }
        if (StringUtils.isNotBlank((CharSequence)(lineHeight = context.getPropertyValue("line-height")))) {
            double value;
            CSSLength cssLength = CSSLength.of(lineHeight);
            if (cssLength.isValid()) {
                if (cssLength.isPercent()) {
                    CTSpacing spacing = RenderUtils.getSpacing(paragraph);
                    spacing.setLineRule(STLineSpacingRule.AUTO);
                    spacing.setLine(BigInteger.valueOf(Math.round(cssLength.unitValue() * 240.0)));
                } else if (cssLength.getValue() > 0.0) {
                    CTSpacing spacing = RenderUtils.getSpacing(paragraph);
                    spacing.setLineRule(STLineSpacingRule.EXACT);
                    spacing.setLine(BigInteger.valueOf(RenderUtils.emuToTwips(context.lengthToEMU(cssLength))));
                }
            } else if (NumberUtils.isParsable((String)lineHeight) && (value = Double.parseDouble(lineHeight)) > 0.0) {
                CTSpacing spacing = RenderUtils.getSpacing(paragraph);
                spacing.setLineRule(STLineSpacingRule.AUTO);
                spacing.setLine(BigInteger.valueOf(Math.round(value * 240.0)));
            }
        }
    }

    private static void setIndentation(HtmlRenderContext context, XWPFParagraph paragraph, CSSStyleDeclarationImpl cssStyleDeclaration) {
        String textIndent;
        CSSLength marginRight;
        CSSLength marginLeft = CSSLength.of(cssStyleDeclaration.getMarginLeft().toLowerCase());
        if (marginLeft.isValid() && !marginLeft.isPercent()) {
            RenderUtils.getInd(paragraph).setLeft(BigInteger.valueOf(RenderUtils.emuToTwips(context.lengthToEMU(marginLeft))));
        }
        if ((marginRight = CSSLength.of(cssStyleDeclaration.getMarginRight().toLowerCase())).isValid() && !marginRight.isPercent()) {
            RenderUtils.getInd(paragraph).setRight(BigInteger.valueOf(RenderUtils.emuToTwips(context.lengthToEMU(marginRight))));
        }
        if ((textIndent = context.getPropertyValue("text-indent").trim()).isEmpty()) {
            RenderUtils.indent(context, paragraph, textIndent);
        } else {
            int nonSpace = -1;
            boolean indented = false;
            for (int i = 0; i < textIndent.length(); ++i) {
                char c = textIndent.charAt(i);
                if (Character.isWhitespace(c)) {
                    if (nonSpace >= 0) {
                        indented = RenderUtils.indent(context, paragraph, textIndent.substring(nonSpace, i));
                    }
                    nonSpace = -1;
                } else if (nonSpace < 0) {
                    nonSpace = i;
                }
                if (indented) break;
            }
            if (nonSpace >= 0) {
                RenderUtils.indent(context, paragraph, textIndent.substring(nonSpace));
            }
        }
    }

    private static boolean indent(HtmlRenderContext context, XWPFParagraph paragraph, String style) {
        CSSLength cssLength = CSSLength.of(style.toLowerCase());
        if (cssLength.isValid() && cssLength.getValue() > 0.0) {
            CTPPr pPr = RenderUtils.getPPr(paragraph.getCTP());
            CTInd ind = RenderUtils.getInd(pPr);
            double indent = cssLength.isPercent() ? (double)context.getAvailableWidthInEMU() * cssLength.unitValue() / CSSLengthUnit.TWIP.absoluteFactor() : (double)context.lengthToEMU(cssLength) / CSSLengthUnit.TWIP.absoluteFactor();
            ind.setFirstLine(BigInteger.valueOf(Math.round(indent)));
            return true;
        }
        return false;
    }

    private static boolean setBorder(Object xwpfElement, CSSStyleDeclarationImpl cssStyleDeclaration, String styleProperty, String widthProperty, String colorProperty, Function<Object, CTBorder> getter) {
        String borderStyle = cssStyleDeclaration.getPropertyValue(styleProperty);
        STBorder.Enum style = RenderUtils.borderStyle(borderStyle);
        String borderWidth = cssStyleDeclaration.getPropertyValue(widthProperty);
        CSSLength width = CSSLength.of(borderWidth);
        if (style != null && (!width.isValid() || width.getValue() > 0.0)) {
            CTBorder border = getter.apply(xwpfElement);
            border.setVal(style);
            String borderColor = cssStyleDeclaration.getPropertyValue(colorProperty);
            String color = Colors.fromStyle(borderColor);
            border.setColor((Object)color);
            if (width.isValid() && !width.isPercent()) {
                long widthValue = Math.round(width.to(CSSLengthUnit.PX).getValue()) * 4L;
                if (widthValue < 2L) {
                    widthValue = 2L;
                } else if (widthValue > 96L) {
                    widthValue = 96L;
                }
                border.setSz(BigInteger.valueOf(widthValue));
            } else {
                border.setSz(BigInteger.valueOf(4L));
            }
        }
        return style == STBorder.NONE || style == STBorder.NIL;
    }

    private static STBorder.Enum borderStyle(String style) {
        if (StringUtils.isBlank((CharSequence)style)) {
            return null;
        }
        switch (style.toLowerCase()) {
            case "dotted": {
                return STBorder.DOTTED;
            }
            case "dashed": {
                return STBorder.DASHED;
            }
            case "solid": {
                return STBorder.SINGLE;
            }
            case "double": {
                return STBorder.DOUBLE;
            }
            case "groove": 
            case "inset": {
                return STBorder.INSET;
            }
            case "ridge": 
            case "outset": {
                return STBorder.OUTSET;
            }
            case "none": {
                return STBorder.NONE;
            }
        }
        return null;
    }

    private static CTBorder getTop(Object e) {
        if (e instanceof XWPFParagraph) {
            XWPFParagraph paragraph = (XWPFParagraph)e;
            CTPPr pPr = RenderUtils.getPPr(paragraph.getCTP());
            CTPBdr pBdr = RenderUtils.getPBdr(pPr);
            return pBdr.isSetTop() ? pBdr.getTop() : pBdr.addNewTop();
        }
        if (e instanceof XWPFTable) {
            XWPFTable table = (XWPFTable)e;
            CTTblPr tblPr = RenderUtils.getTblPr(table.getCTTbl());
            CTTblBorders tblBorders = RenderUtils.getTblBorders(tblPr);
            return tblBorders.isSetTop() ? tblBorders.getTop() : tblBorders.addNewTop();
        }
        if (e instanceof XWPFTableCell) {
            XWPFTableCell cell = (XWPFTableCell)e;
            CTTcPr tcPr = RenderUtils.getTcPr(cell.getCTTc());
            CTTcBorders tcBorders = RenderUtils.getTcBorders(tcPr);
            return tcBorders.isSetTop() ? tcBorders.getTop() : tcBorders.addNewTop();
        }
        throw new UnsupportedOperationException("Can not get top border of " + e.getClass().getName());
    }

    private static CTBorder getRight(Object e) {
        if (e instanceof XWPFParagraph) {
            XWPFParagraph paragraph = (XWPFParagraph)e;
            CTPPr pPr = RenderUtils.getPPr(paragraph.getCTP());
            CTPBdr pBdr = RenderUtils.getPBdr(pPr);
            return pBdr.isSetRight() ? pBdr.getRight() : pBdr.addNewRight();
        }
        if (e instanceof XWPFTable) {
            XWPFTable table = (XWPFTable)e;
            CTTblPr tblPr = RenderUtils.getTblPr(table.getCTTbl());
            CTTblBorders tblBorders = RenderUtils.getTblBorders(tblPr);
            return tblBorders.isSetRight() ? tblBorders.getRight() : tblBorders.addNewRight();
        }
        if (e instanceof XWPFTableCell) {
            XWPFTableCell cell = (XWPFTableCell)e;
            CTTcPr tcPr = RenderUtils.getTcPr(cell.getCTTc());
            CTTcBorders tcBorders = RenderUtils.getTcBorders(tcPr);
            return tcBorders.isSetRight() ? tcBorders.getRight() : tcBorders.addNewRight();
        }
        throw new UnsupportedOperationException("Can not get right border of " + e.getClass().getName());
    }

    private static CTBorder getBottom(Object e) {
        if (e instanceof XWPFParagraph) {
            XWPFParagraph paragraph = (XWPFParagraph)e;
            CTPPr pPr = RenderUtils.getPPr(paragraph.getCTP());
            CTPBdr pBdr = RenderUtils.getPBdr(pPr);
            return pBdr.isSetBottom() ? pBdr.getBottom() : pBdr.addNewBottom();
        }
        if (e instanceof XWPFTable) {
            XWPFTable table = (XWPFTable)e;
            CTTblPr tblPr = RenderUtils.getTblPr(table.getCTTbl());
            CTTblBorders tblBorders = RenderUtils.getTblBorders(tblPr);
            return tblBorders.isSetBottom() ? tblBorders.getBottom() : tblBorders.addNewBottom();
        }
        if (e instanceof XWPFTableCell) {
            XWPFTableCell cell = (XWPFTableCell)e;
            CTTcPr tcPr = RenderUtils.getTcPr(cell.getCTTc());
            CTTcBorders tcBorders = RenderUtils.getTcBorders(tcPr);
            return tcBorders.isSetBottom() ? tcBorders.getBottom() : tcBorders.addNewBottom();
        }
        throw new UnsupportedOperationException("Can not get bottom border of " + e.getClass().getName());
    }

    private static CTBorder getLeft(Object e) {
        if (e instanceof XWPFParagraph) {
            XWPFParagraph paragraph = (XWPFParagraph)e;
            CTPPr pPr = RenderUtils.getPPr(paragraph.getCTP());
            CTPBdr pBdr = RenderUtils.getPBdr(pPr);
            return pBdr.isSetLeft() ? pBdr.getLeft() : pBdr.addNewLeft();
        }
        if (e instanceof XWPFTable) {
            XWPFTable table = (XWPFTable)e;
            CTTblPr tblPr = RenderUtils.getTblPr(table.getCTTbl());
            CTTblBorders tblBorders = RenderUtils.getTblBorders(tblPr);
            return tblBorders.isSetLeft() ? tblBorders.getLeft() : tblBorders.addNewLeft();
        }
        if (e instanceof XWPFTableCell) {
            XWPFTableCell cell = (XWPFTableCell)e;
            CTTcPr tcPr = RenderUtils.getTcPr(cell.getCTTc());
            CTTcBorders tcBorders = RenderUtils.getTcBorders(tcPr);
            return tcBorders.isSetLeft() ? tcBorders.getLeft() : tcBorders.addNewLeft();
        }
        throw new UnsupportedOperationException("Can not get left border of " + e.getClass().getName());
    }

    public static int smallerFontSizeInHalfPoints(int inheritedSizeInHalfPoints) {
        for (int i = FONT_SIZE_IN_HALF_POINTS.length - 1; i >= 0; --i) {
            int s = FONT_SIZE_IN_HALF_POINTS[i];
            if (s >= inheritedSizeInHalfPoints) continue;
            return s;
        }
        return FONT_SIZE_IN_HALF_POINTS[0];
    }

    public static int largerFontSizeInHalfPoints(int inheritedSizeInHalfPoints) {
        for (int s : FONT_SIZE_IN_HALF_POINTS) {
            if (s <= inheritedSizeInHalfPoints) continue;
            return s;
        }
        return FONT_SIZE_IN_HALF_POINTS[FONT_SIZE_IN_HALF_POINTS.length - 1];
    }

    public static int emuToTwips(int emu) {
        return (int)((long)emu * 20L / 12700L);
    }

    public static void tableStyle(HtmlRenderContext context, XWPFTable table, CSSStyleDeclarationImpl cssStyleDeclaration) {
        String color;
        String backgroundColor;
        String marginLeft;
        boolean allNone;
        if (CSSStyleUtils.isEmpty(cssStyleDeclaration)) {
            return;
        }
        TableRowAlign align = RenderUtils.alignTable(cssStyleDeclaration.getPropertyValue("float"));
        if (align != null) {
            table.setTableAlignment(align);
        }
        if (allNone = RenderUtils.setBorder(table, cssStyleDeclaration)) {
            CTTblPr tblPr = RenderUtils.getTblPr(table.getCTTbl());
            CTTblBorders tblBorders = RenderUtils.getTblBorders(tblPr);
            CTBorder insideH = tblBorders.isSetInsideH() ? tblBorders.getInsideH() : tblBorders.addNewInsideH();
            insideH.setVal(STBorder.NONE);
            CTBorder insideV = tblBorders.isSetInsideV() ? tblBorders.getInsideV() : tblBorders.addNewInsideV();
            insideV.setVal(STBorder.NONE);
        }
        if (StringUtils.isNotBlank((CharSequence)(marginLeft = cssStyleDeclaration.getPropertyValue("margin-left")))) {
            RenderUtils.indent(context, table, marginLeft);
        }
        if (StringUtils.isNotBlank((CharSequence)(backgroundColor = cssStyleDeclaration.getBackgroundColor())) && (color = Colors.fromStyle(backgroundColor, null)) != null) {
            CTTblPr tblPr = RenderUtils.getTblPr(table.getCTTbl());
            CTShd shd = RenderUtils.getShd(tblPr);
            shd.setFill((Object)color);
        }
    }

    public static void cellStyle(HtmlRenderContext context, XWPFTableCell cell, CSSStyleDeclarationImpl cssStyleDeclaration) {
        String color;
        if (CSSStyleUtils.isEmpty(cssStyleDeclaration)) {
            return;
        }
        RenderUtils.setCellPadding(context, cell, cssStyleDeclaration);
        XWPFTableCell.XWPFVertAlign align = RenderUtils.alignTableCell(cssStyleDeclaration.getVerticalAlign());
        if (align != null) {
            cell.setVerticalAlignment(align);
        }
        RenderUtils.setBorder(cell, cssStyleDeclaration);
        String backgroundColor = cssStyleDeclaration.getBackgroundColor();
        if (StringUtils.isNotBlank((CharSequence)backgroundColor) && (color = Colors.fromStyle(backgroundColor, null)) != null) {
            CTTcPr tcPr = RenderUtils.getTcPr(cell.getCTTc());
            CTShd shd = RenderUtils.getShd(tcPr);
            shd.setFill((Object)color);
        }
    }

    private static void setCellPadding(HtmlRenderContext context, XWPFTableCell cell, CSSStyleDeclarationImpl cssStyleDeclaration) {
        CSSLength paddingLeft;
        CSSLength paddingBottom;
        CSSLength paddingRight;
        CSSLength paddingTop = CSSLength.of(cssStyleDeclaration.getPaddingTop().toLowerCase());
        if (paddingTop.isValid() && !paddingTop.isPercent() && paddingTop.getValue() >= 0.0) {
            CTTblWidth top = RenderUtils.getTcMar(cell).addNewTop();
            top.setType(STTblWidth.DXA);
            top.setW(BigInteger.valueOf(RenderUtils.emuToTwips(context.lengthToEMU(paddingTop))));
        }
        if ((paddingRight = CSSLength.of(cssStyleDeclaration.getPaddingRight().toLowerCase())).isValid() && !paddingRight.isPercent() && paddingRight.getValue() >= 0.0) {
            CTTblWidth right = RenderUtils.getTcMar(cell).addNewRight();
            right.setType(STTblWidth.DXA);
            right.setW(BigInteger.valueOf(RenderUtils.emuToTwips(context.lengthToEMU(paddingRight))));
        }
        if ((paddingBottom = CSSLength.of(cssStyleDeclaration.getPaddingBottom().toLowerCase())).isValid() && !paddingBottom.isPercent() && paddingBottom.getValue() >= 0.0) {
            CTTblWidth bottom = RenderUtils.getTcMar(cell).addNewBottom();
            bottom.setType(STTblWidth.DXA);
            bottom.setW(BigInteger.valueOf(RenderUtils.emuToTwips(context.lengthToEMU(paddingBottom))));
        }
        if ((paddingLeft = CSSLength.of(cssStyleDeclaration.getPaddingLeft().toLowerCase())).isValid() && !paddingLeft.isPercent() && paddingLeft.getValue() >= 0.0) {
            CTTblWidth left = RenderUtils.getTcMar(cell).addNewLeft();
            left.setType(STTblWidth.DXA);
            left.setW(BigInteger.valueOf(RenderUtils.emuToTwips(context.lengthToEMU(paddingLeft))));
        }
    }

    public static boolean setBorder(Object xwpfElement, CSSStyleDeclarationImpl cssStyleDeclaration) {
        boolean topNone = RenderUtils.setBorder(xwpfElement, cssStyleDeclaration, "border-top-style", "border-top-width", "border-top-color", RenderUtils::getTop);
        boolean rightNone = RenderUtils.setBorder(xwpfElement, cssStyleDeclaration, "border-right-style", "border-right-width", "border-right-color", RenderUtils::getRight);
        boolean bottomNone = RenderUtils.setBorder(xwpfElement, cssStyleDeclaration, "border-bottom-style", "border-bottom-width", "border-bottom-color", RenderUtils::getBottom);
        boolean leftNone = RenderUtils.setBorder(xwpfElement, cssStyleDeclaration, "border-left-style", "border-left-width", "border-left-color", RenderUtils::getLeft);
        return topNone && rightNone && bottomNone && leftNone;
    }

    private static boolean indent(HtmlRenderContext context, XWPFTable table, String style) {
        CSSLength cssLength = CSSLength.of(style.toLowerCase());
        if (cssLength.isValid() && cssLength.getValue() > 0.0) {
            CTTblPr tblPr = RenderUtils.getTblPr(table.getCTTbl());
            CTTblWidth ind = RenderUtils.getInd(tblPr);
            double indent = cssLength.isPercent() ? (double)context.getAvailableWidthInEMU() * cssLength.unitValue() / CSSLengthUnit.TWIP.absoluteFactor() : (double)context.lengthToEMU(cssLength) / CSSLengthUnit.TWIP.absoluteFactor();
            ind.setType(STTblWidth.DXA);
            ind.setW(BigInteger.valueOf(Math.round(indent)));
            return true;
        }
        return false;
    }

    public static CTTblWidth getInd(CTTblPr tblPr) {
        return tblPr.isSetTblInd() ? tblPr.getTblInd() : tblPr.addNewTblInd();
    }

    public static CTTblBorders getTblBorders(CTTblPr tblPr) {
        return tblPr.isSetTblBorders() ? tblPr.getTblBorders() : tblPr.addNewTblBorders();
    }

    public static CTShd getShd(CTTblPr tblPr) {
        return tblPr.isSetShd() ? tblPr.getShd() : tblPr.addNewShd();
    }

    public static CTTblPr getTblPr(CTTbl ctTbl) {
        CTTblPr tblPr = ctTbl.getTblPr();
        if (tblPr == null) {
            tblPr = ctTbl.addNewTblPr();
        }
        return tblPr;
    }

    public static CTTcBorders getTcBorders(CTTcPr tcPr) {
        return tcPr.isSetTcBorders() ? tcPr.getTcBorders() : tcPr.addNewTcBorders();
    }

    public static CTShd getShd(CTTcPr tcPr) {
        return tcPr.isSetShd() ? tcPr.getShd() : tcPr.addNewShd();
    }

    public static TableRowAlign alignTable(String cssFloat) {
        if (StringUtils.isBlank((CharSequence)cssFloat)) {
            return null;
        }
        switch (cssFloat.toLowerCase()) {
            case "left": {
                return TableRowAlign.LEFT;
            }
            case "right": {
                return TableRowAlign.RIGHT;
            }
        }
        return null;
    }

    public static XWPFTableCell.XWPFVertAlign alignTableCell(String verticalAlign) {
        if (StringUtils.isBlank((CharSequence)verticalAlign)) {
            return null;
        }
        switch (verticalAlign.toLowerCase()) {
            case "middle": {
                return XWPFTableCell.XWPFVertAlign.CENTER;
            }
            case "bottom": {
                return XWPFTableCell.XWPFVertAlign.BOTTOM;
            }
        }
        return XWPFTableCell.XWPFVertAlign.TOP;
    }

    public static CTAnchor inlineToAnchor(CTDrawing drawing) {
        CTInline ctInline = drawing.getInlineArray(0);
        CTAnchor ctAnchor = drawing.addNewAnchor();
        ctAnchor.setDocPr(ctInline.getDocPr());
        ctAnchor.setExtent(ctInline.getExtent());
        ctAnchor.setGraphic(ctInline.getGraphic());
        drawing.removeInline(0);
        ctAnchor.setAllowOverlap(true);
        ctAnchor.setBehindDoc(false);
        ctAnchor.setRelativeHeight(0L);
        ctAnchor.setDistL(0L);
        ctAnchor.setDistR(0L);
        ctAnchor.setDistB(0L);
        ctAnchor.setDistT(0L);
        ctAnchor.setLayoutInCell(true);
        ctAnchor.setLocked(false);
        ctAnchor.addNewWrapSquare().setWrapText(STWrapText.BOTH_SIDES);
        ctAnchor.setSimplePos2(false);
        CTPoint2D simplePos = ctAnchor.addNewSimplePos();
        simplePos.setX(0L);
        simplePos.setY(0L);
        return ctAnchor;
    }
}

