/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.util;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ddr.poi.html.util.CSSLength;
import org.ddr.poi.html.util.CSSLengthUnit;

public enum NamedFontSize {
    XX_SMALL("xx-small", 6.0),
    X_SMALL("x-small", 7.5),
    SMALL("small", 10.0),
    MEDIUM("medium", 12.0),
    LARGE("large", 13.5),
    X_LARGE("x-large", 18.0),
    XX_LARGE("xx-large", 24.0),
    XXX_LARGE("xxx-large", 36.0);

    private final String name;
    private final CSSLength size;
    private static final Map<String, NamedFontSize> NAMED_MAP;

    private NamedFontSize(String name, double pt) {
        this.name = name;
        this.size = new CSSLength(pt, CSSLengthUnit.PT);
    }

    public String getName() {
        return this.name;
    }

    public CSSLength getSize() {
        return this.size;
    }

    public static NamedFontSize of(String name) {
        return NAMED_MAP.get(name);
    }

    static {
        NAMED_MAP = Arrays.stream(NamedFontSize.values()).collect(Collectors.toMap(NamedFontSize::getName, Function.identity()));
    }
}

