/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.tag;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.SVGPictureData;
import org.ddr.poi.html.ElementRenderer;
import org.ddr.poi.html.HtmlRenderContext;
import org.ddr.poi.html.util.CSSLength;
import org.ddr.poi.math.MathMLUtils;
import org.ddr.poi.util.ByteArrayCopyStream;
import org.ddr.poi.util.HttpURLConnectionUtils;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageRenderer
implements ElementRenderer {
    private static final Logger log = LoggerFactory.getLogger(ImageRenderer.class);
    private static final String[] TAGS = new String[]{"img"};
    private static final String HTTP = "http";
    private static final String DOUBLE_SLASH = "//";
    private static final String DATA_PREFIX = "data:";
    private static final Map<String, ImageType> PICTURE_TYPES = new HashMap<String, ImageType>(ImageType.values().length);
    private static final String COMMENT_MATH_PREFIX = "<!--MathML: <math ";
    private static final String COMMENT_MATH_SUFFIX = "</math>-->";

    @Override
    public boolean renderStart(Element element, HtmlRenderContext context) {
        String src = element.attr("src");
        if (StringUtils.startsWithIgnoreCase((CharSequence)src, (CharSequence)HTTP)) {
            this.handleRemoteImage(element, context, src);
        } else if (StringUtils.startsWith((CharSequence)src, (CharSequence)DOUBLE_SLASH)) {
            this.handleRemoteImage(element, context, "http:" + src);
        } else if (StringUtils.startsWith((CharSequence)src, (CharSequence)DATA_PREFIX)) {
            this.handleData(element, context, src);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleData(Element element, HtmlRenderContext context, String src) {
        int startOfMath;
        byte[] bytes;
        int index = src.indexOf(",".charAt(0));
        String data = src.substring(index + 1);
        String declaration = src.substring(0, index);
        String format = StringUtils.substringBetween((String)declaration, (String)"/", (String)";");
        if (format.contains("-")) {
            format = StringUtils.substringAfterLast((String)format, (String)"-");
        } else if (format.contains("+")) {
            format = StringUtils.substringBefore((String)format, (String)"+");
        }
        if (declaration.contains("base64")) {
            try {
                bytes = Base64.getDecoder().decode(data);
            }
            catch (Exception e) {
                log.warn("Failed to load image due to illegal base64 data: {}", (Object)src);
                return;
            }
        }
        if (data.startsWith("%")) {
            try {
                data = URLDecoder.decode(data, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                log.warn("Failed to load image due to illegal data url: {}", (Object)src);
                return;
            }
        }
        if ((startOfMath = data.indexOf(COMMENT_MATH_PREFIX)) >= 0) {
            try {
                int endOfMath = data.indexOf(COMMENT_MATH_SUFFIX, startOfMath + COMMENT_MATH_PREFIX.length());
                String math = data.substring(startOfMath + 12, endOfMath + 7);
                MathMLUtils.renderTo(context.getClosestParagraph(), context.newRun(), math);
                return;
            }
            catch (Exception e) {
                log.warn("Failed to render math in wiris svg, will try to render as svg image: {}", (Object)data, (Object)e);
            }
        }
        bytes = data.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            InputStream imageStream;
            BufferedImage image = ImageIO.read(inputStream);
            ImageType type = PICTURE_TYPES.getOrDefault(format, this.typeOf(image));
            boolean svg = "svg".equals(format);
            if (svg) {
                ByteArrayCopyStream outputStream = new ByteArrayCopyStream(image.getData().getDataBuffer().getSize());
                ImageIO.write((RenderedImage)image, type.getExtension(), outputStream);
                imageStream = outputStream.toInput();
            } else {
                ((InputStream)inputStream).reset();
                imageStream = inputStream;
            }
            this.addPicture(element, context, imageStream, type.getType(), image.getWidth(), image.getHeight(), (byte[])(svg ? bytes : null));
        }
        catch (IOException | InvalidFormatException e) {
            log.warn("Failed to load image: {}", (Object)src, (Object)e);
        }
        finally {
            Object image = null;
        }
    }

    protected ImageType typeOf(BufferedImage image) {
        return image.getColorModel().hasAlpha() ? ImageType.PNG : ImageType.JPG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleRemoteImage(Element element, HtmlRenderContext context, String src) {
        BufferedImage image;
        HttpURLConnection connect;
        InputStream inputStream;
        ByteArrayCopyStream outputStream;
        block11: {
            block10: {
                String url;
                String extension = FilenameUtils.getExtension((String)StringUtils.substringBefore((String)src, (String)"?")).toLowerCase();
                if ("heic".equals(extension) && !src.equals(url = this.convertHeic(src))) {
                    src = url;
                    extension = ImageType.JPG.getExtension();
                }
                ImageType type = PICTURE_TYPES.get(extension);
                outputStream = null;
                inputStream = null;
                connect = null;
                try {
                    connect = HttpURLConnectionUtils.connect(src);
                    InputStream urlStream = connect.getInputStream();
                    boolean svg = StringUtils.contains((CharSequence)connect.getHeaderField("content-type"), (CharSequence)"svg");
                    byte[] svgData = null;
                    outputStream = new ByteArrayCopyStream(urlStream.available());
                    IOUtils.copy((InputStream)urlStream, (OutputStream)outputStream);
                    if (svg) {
                        svgData = outputStream.toByteArray();
                    }
                    if ((image = ImageIO.read(outputStream.toInput())) == null) {
                        log.warn("Illegal image url: {}", (Object)src);
                        IOUtils.close((URLConnection)connect);
                        break block10;
                    }
                    if (type == null) {
                        type = this.typeOf(image);
                    }
                    inputStream = outputStream.toInput();
                    this.addPicture(element, context, inputStream, type.getType(), image.getWidth(), image.getHeight(), svgData);
                    IOUtils.close((URLConnection)connect);
                    break block11;
                }
                catch (IOException | InvalidFormatException e) {
                    log.warn("Failed to load image: {}", (Object)src, (Object)e);
                    return;
                }
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
            return;
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        return;
        finally {
            IOUtils.close((URLConnection)connect);
            IOUtils.closeQuietly(outputStream);
            IOUtils.closeQuietly(inputStream);
            image = null;
        }
    }

    private String convertHeic(String src) {
        return src + (src.contains("?") ? (char)'&' : '?') + "x-oss-process=image/format,jpg";
    }

    @Override
    public String[] supportedTags() {
        return TAGS;
    }

    @Override
    public boolean renderAsBlock() {
        return false;
    }

    protected void addPicture(Element element, HtmlRenderContext context, InputStream inputStream, int type, int widthInPixels, int heightInPixels, byte[] svgData) throws InvalidFormatException, IOException {
        int calculatedHeight;
        int calculatedWidth;
        CSSLength cssLength;
        CSSLength cssLength2;
        String height;
        CSSLength cssLength3;
        CSSLength cssLength4;
        int containerWidth = context.getAvailableWidthInEMU();
        int widthInEMU = Units.pixelToEMU((int)widthInPixels);
        int heightInEMU = Units.pixelToEMU((int)heightInPixels);
        float naturalAspect = 1.0f * (float)widthInEMU / (float)heightInEMU;
        int declaredWidth = widthInEMU;
        int declaredHeight = heightInEMU;
        int maxWidthInEMU = containerWidth;
        int maxHeightInEMU = Integer.MAX_VALUE;
        String width = context.getPropertyValue("width");
        if (width.length() > 0) {
            cssLength4 = CSSLength.of(width);
            if (cssLength4.isValid()) {
                declaredWidth = context.computeLengthInEMU(cssLength4, widthInEMU, containerWidth);
            }
        } else {
            width = element.attr("width");
            if (NumberUtils.isParsable((String)width)) {
                width = width + "px";
                cssLength4 = CSSLength.of(width);
                declaredWidth = context.computeLengthInEMU(cssLength4, widthInEMU, containerWidth);
            }
        }
        String maxWidth = context.getPropertyValue("max-width");
        if (maxWidth.length() > 0 && (cssLength3 = CSSLength.of(maxWidth)).isValid()) {
            maxWidthInEMU = Math.min(context.computeLengthInEMU(cssLength3, widthInEMU, containerWidth), containerWidth);
        }
        if ((height = context.getPropertyValue("height")).length() > 0) {
            cssLength2 = CSSLength.of(height);
            if (cssLength2.isValid()) {
                declaredHeight = context.computeLengthInEMU(cssLength2, heightInEMU, Integer.MAX_VALUE);
            }
        } else {
            height = element.attr("height");
            if (NumberUtils.isParsable((String)height)) {
                height = height + "px";
                cssLength2 = CSSLength.of(height);
                declaredHeight = context.computeLengthInEMU(cssLength2, heightInEMU, Integer.MAX_VALUE);
            }
        }
        String maxHeight = context.getPropertyValue("max-height");
        if (maxHeight.length() > 0 && (cssLength = CSSLength.of(maxHeight)).isValid()) {
            maxHeightInEMU = context.computeLengthInEMU(cssLength, heightInEMU, Integer.MAX_VALUE);
        }
        if (declaredWidth < maxWidthInEMU && declaredHeight <= maxHeightInEMU) {
            calculatedWidth = declaredWidth;
            calculatedHeight = declaredHeight;
        } else if (declaredWidth > maxWidthInEMU && declaredHeight <= maxHeightInEMU) {
            calculatedWidth = maxWidthInEMU;
            calculatedHeight = (int)((float)maxWidthInEMU / naturalAspect);
        } else if (declaredHeight > maxHeightInEMU && declaredWidth <= maxWidthInEMU) {
            calculatedHeight = maxHeightInEMU;
            calculatedWidth = (int)((float)maxHeightInEMU * naturalAspect);
        } else {
            float widthRatio = 1.0f * (float)maxWidthInEMU / (float)declaredWidth;
            float heightRatio = 1.0f * (float)maxHeightInEMU / (float)declaredHeight;
            float scale = Math.min(widthRatio, heightRatio);
            calculatedWidth = (int)((float)declaredWidth * scale);
            calculatedHeight = (int)((float)declaredHeight * scale);
        }
        context.renderPicture(inputStream, type, "img", calculatedWidth, calculatedHeight, svgData);
    }

    static {
        for (ImageType type : ImageType.values()) {
            PICTURE_TYPES.put(type.getExtension(), type);
        }
        SVGPictureData.initRelation();
    }

    protected static enum ImageType {
        EMF(2),
        WMF(3),
        PICT(4),
        JPEG(5),
        JPG(5),
        PNG(6),
        DIB(7),
        GIF(8),
        TIF(9),
        TIFF(9),
        EPS(10),
        BMP(11),
        WPG(12);

        private final int type;

        private ImageType(int type) {
            this.type = type;
        }

        public String getExtension() {
            return this.name().toLowerCase();
        }

        public int getType() {
            return this.type;
        }
    }
}

