/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.tag;

import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.xb.xmlschema.SpaceAttribute;
import org.ddr.poi.html.ElementRenderer;
import org.ddr.poi.html.HtmlRenderContext;
import org.ddr.poi.html.util.RenderUtils;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STFldCharType;

public class RubyRenderer
implements ElementRenderer {
    private static final String[] TAGS = new String[]{"ruby"};

    @Override
    public boolean renderStart(Element element, HtmlRenderContext context) {
        StringBuilder sb = StringUtil.borrowBuilder();
        for (Node childNode : element.childNodes()) {
            if (childNode instanceof Element) {
                String tagName = ((Element)childNode).normalName();
                if ("rt".equals(tagName)) {
                    String rt = ((Element)childNode).text();
                    CTR ctr = context.newRun();
                    CTRPr rPr = RenderUtils.getRPr(ctr);
                    rPr.addNewLang().setVal((Object)"en-US");
                    ctr.addNewFldChar().setFldCharType(STFldCharType.BEGIN);
                    ctr = context.newRun();
                    rPr = RenderUtils.getRPr(ctr);
                    rPr.addNewLang().setVal((Object)"en-US");
                    CTText ctText = ctr.addNewInstrText();
                    ctText.setSpace(SpaceAttribute.Space.PRESERVE);
                    int fontSize = context.getGlobalFontSize() == null ? context.getInheritedFontSizeInHalfPoints() : context.getGlobalFontSize().intValue();
                    fontSize = (fontSize + 1) / 2;
                    ctText.setStringValue("EQ \\* jc0 \\* hps" + fontSize + " \\o \\ad(\\s \\up 9(" + rt + ")," + StringUtil.releaseBuilder((StringBuilder)sb).trim() + ")");
                    sb = StringUtil.borrowBuilder();
                    ctr = context.newRun();
                    rPr = RenderUtils.getRPr(ctr);
                    rPr.addNewLang().setVal((Object)"en-US");
                    ctr.addNewFldChar().setFldCharType(STFldCharType.END);
                    continue;
                }
                if ("rp".equals(tagName)) continue;
                StringUtil.appendNormalisedWhitespace((StringBuilder)sb, (String)((Element)childNode).wholeText(), (boolean)false);
                continue;
            }
            if (!(childNode instanceof TextNode)) continue;
            StringUtil.appendNormalisedWhitespace((StringBuilder)sb, (String)((TextNode)childNode).getWholeText(), (boolean)false);
        }
        String remainText = StringUtil.releaseBuilder((StringBuilder)sb);
        if (StringUtils.isNotBlank((CharSequence)remainText)) {
            context.renderText(remainText);
        }
        return false;
    }

    @Override
    public String[] supportedTags() {
        return TAGS;
    }

    @Override
    public boolean renderAsBlock() {
        return false;
    }
}

