package top.dreamlike.panama.genertor.proxy;

import top.dreamlike.panama.genertor.annotation.Alignment;
import top.dreamlike.panama.genertor.annotation.Pointer;
import top.dreamlike.panama.genertor.annotation.Union;
import top.dreamlike.panama.genertor.helper.NativeGeneratorHelper;
import top.dreamlike.panama.genertor.helper.StructProxyContext;

import javax.tools.*;
import java.awt.*;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.List;

// Press Shift twice to open the Search Everywhere dialog and type `show whitespaces`,
// then press Enter. You can now see whitespace characters in your code.
public class Main{


    public static void main(String[] args) throws Throwable {
        String javaCode = "public class HelloWorld {public static void main(String[] args) {" +
                "System.out.println(\"Hello, World!\");}}";

        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);

        Iterable<? extends JavaFileObject> fileObjects;
        fileObjects = List.of(new StringJavaFileObject("HelloWorld", javaCode));

        compiler.getTask(null, fileManager, null, null, null, fileObjects).call();

    }

    static class StringJavaFileObject extends SimpleJavaFileObject {

        private final String code;

        private final String name;

        StringJavaFileObject(String name, String code) {
            super(URI.create(STR."string:///\{name.replace('.', '/')}\{Kind.SOURCE.extension}"), Kind.SOURCE);
            this.name = name;
            this.code = code;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return code;
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return new FileOutputStream(STR."tmp/\{name}.class");
        }
    }

    private void s() {}

    private static void s1(){}

    public void s2() {};

    public static void print(String s, int a) {
        System.out.println(STR."\{s}ocean, a: \{a}");
    }

    public static String getString() {
        return "dreamlike-";
    }

    public static int getInt() {
        return 1;
    }


    public static final MemoryLayout MEMORY_LAYOUT;

    static {
        MEMORY_LAYOUT = null;
    }

    public static MemorySegment s(Object e) {
        return Arena.global().allocate(1024);
    }

    public interface epoll {
        int epoll_create(int size);

        int epoll_ctl(int epfd, int op, int fd,@Pointer epoll_event epoll_event);

        int epoll_wait(int epfd, NativeArray<epoll_event> events, int maxEvent, int timout);

        int open(MemorySegment pathName, int flag);
    }

    public static class epoll_event {

        private int events;

        private epoll_data_t data;

        public epoll_data_t getData() {
            return data;
        }

        public int getEvents() {
            return events;
        }

        public void setEvents(int events) {
            this.events = events;
        }


        @Union
        @Alignment(byteSize = 1)
        public static class epoll_data_t {
            @Pointer
            private long ptr;

            private int fd;

            private int u32;

            private long u64;

            public void setFd(int fd) {
                this.fd = fd;
            }

            public int getFd() {
                return fd;
            }
        }
    }


}