/*
 * Decompiled with CFR 0.152.
 */
package top.dreamlike.panama.generator.helper;

import java.lang.classfile.CodeBuilder;
import java.lang.classfile.TypeKind;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public class ClassFileHelper {
    public static <T> String toSignature(Class<T> c) {
        return c.describeConstable().get().descriptorString();
    }

    public static <T> ClassDesc toDesc(Class<T> c) {
        return c.describeConstable().get();
    }

    public static ClassDesc toDesc(String className) {
        return ClassDesc.ofDescriptor("L" + className.replace(".", "/") + ";");
    }

    public static MethodTypeDesc toMethodDescriptor(Executable method) {
        Executable executable = method;
        Objects.requireNonNull(executable);
        Executable executable2 = executable;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Method.class, Constructor.class}, (Executable)executable2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Method m = (Method)executable2;
                yield MethodType.methodType(m.getReturnType(), method.getParameterTypes()).describeConstable().get();
            }
            case 1 -> MethodType.methodType(Void.TYPE, method.getParameterTypes()).describeConstable().get();
        };
    }

    public static String toSignature(Executable method) {
        return ClassFileHelper.toMethodDescriptor(method).descriptorString();
    }

    public static void invokeMethodHandleExactWithAllArgs(Method method, CodeBuilder it) {
        ClassFileHelper.loadAllArgs(method, it);
        it.invokevirtual(ConstantDescs.CD_MethodHandle, "invokeExact", ClassFileHelper.toMethodDescriptor(method));
        it.return_(TypeKind.from(method.getReturnType()));
    }

    public static void loadAllArgs(Method method, CodeBuilder it) {
        Parameter[] parameters = method.getParameters();
        int nextSlot = 1;
        for (int i = 0; i < parameters.length; ++i) {
            TypeKind typeKind = TypeKind.from(parameters[i].getType());
            it.loadLocal(typeKind, nextSlot);
            nextSlot += typeKind.slotSize();
        }
    }

    public static void getField(CodeBuilder cb, Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            cb.getstatic(field.getDeclaringClass().describeConstable().get(), field.getName(), field.getType().describeConstable().get());
        } else {
            cb.getfield(field.getDeclaringClass().describeConstable().get(), field.getName(), field.getType().describeConstable().get());
        }
    }

    public static void setStatic(CodeBuilder cb, Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            cb.putstatic(field.getDeclaringClass().describeConstable().get(), field.getName(), field.getType().describeConstable().get());
        } else {
            cb.putfield(field.getDeclaringClass().describeConstable().get(), field.getName(), field.getType().describeConstable().get());
        }
    }

    public static void invoke(CodeBuilder cb, Executable method) {
        ClassFileHelper.invoke(cb, method, false);
    }

    public static void invoke(CodeBuilder cb, Executable method, boolean interfaceMethod) {
        if (Modifier.isStatic(method.getModifiers())) {
            cb.invokestatic(ClassFileHelper.toDesc(method.getDeclaringClass()), method.getName(), ClassFileHelper.toMethodDescriptor(method));
            return;
        }
        if (interfaceMethod && method instanceof Method) {
            cb.invokeinterface(ClassFileHelper.toDesc(method.getDeclaringClass()), method.getName(), ClassFileHelper.toMethodDescriptor(method));
            return;
        }
        if (method instanceof Constructor || Modifier.isPrivate(method.getModifiers())) {
            cb.invokespecial(ClassFileHelper.toDesc(method.getDeclaringClass()), method.getName(), ClassFileHelper.toMethodDescriptor(method));
            return;
        }
        cb.invokevirtual(ClassFileHelper.toDesc(method.getDeclaringClass()), method.getName(), ClassFileHelper.toMethodDescriptor(method));
    }

    public static void returnValue(CodeBuilder cb, Class returnType) {
        TypeKind type = TypeKind.from((TypeDescriptor.OfField)returnType);
        cb.return_(type);
    }
}

