/*
 * Decompiled with CFR 0.152.
 */
package top.dreamlike.panama.generator.helper;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import top.dreamlike.panama.generator.exception.StructException;
import top.dreamlike.panama.generator.helper.NativeAddressable;
import top.dreamlike.panama.generator.helper.NativeStructEnhanceMark;
import top.dreamlike.panama.generator.helper.StructProxyContext;
import top.dreamlike.panama.generator.proxy.NativeArray;
import top.dreamlike.panama.generator.proxy.NativeCallGenerator;
import top.dreamlike.panama.generator.proxy.StructProxyGenerator;

public class NativeGeneratorHelper {
    public static final MethodHandle DEREFERENCE;
    public static final Method REBIND_ASSERT_METHOD;
    public static final Method FETCH_CURRENT_NATIVE_CALL_GENERATOR;
    public static final Method FETCH_CURRENT_STRUCT_CONTEXT_GENERATOR;
    public static final Method FETCH_CURRENT_STRUCT_LAYOUT_GENERATOR;
    public static final Method FETCH_CURRENT_STRUCT_GENERATOR_GENERATOR;
    public static final ThreadLocal<NativeCallGenerator> CURRENT_GENERATOR;
    public static Supplier<NativeCallGenerator> fetchCurrentNativeCallGenerator;
    public static final ThreadLocal<StructProxyContext> STRUCT_CONTEXT;
    public static Supplier<StructProxyContext> fetchCurrentNativeStructGenerator;
    public static final Method LOAD_SO;
    public static final Method FETCH_STRUCT_PROXY_GENERATOR;
    public static final Method REAL_MEMORY;
    public static final Method REBIND_MEMORY;
    public static final Method GET_ADDRESS_FROM_MEMORY_SEGMENT;
    public static final Method REINTERPRET;
    public static final Method AS_SLICE;
    public static final Method ENHANCE;
    public static final MethodHandle TRANSFORM_OBJECT_TO_STRUCT_MH;
    public static final MethodHandle NATIVE_ARRAY_CTOR;
    public static final Method SET_PTR;
    public static final Method OVER_WRITE_SUB_ELEMENT;

    public static NativeCallGenerator currentNativeCallGenerator() {
        return fetchCurrentNativeCallGenerator.get();
    }

    public static void assertRebindMemory(MemorySegment segment, MemorySegment origin) {
        if (segment.byteSize() != origin.byteSize()) {
            throw new IllegalArgumentException("memorySegment size rebind should equal origin memorySegment size");
        }
    }

    public static MemorySegment deReferencePointer(MemorySegment pointer, long sizeof) {
        if (pointer.address() == MemorySegment.NULL.address()) {
            return pointer;
        }
        return pointer.reinterpret(sizeof);
    }

    public static StructProxyContext currentStructContext() {
        return fetchCurrentNativeStructGenerator.get();
    }

    public static MemorySegment transToStruct(Object o) {
        Object object = o;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NativeAddressable.class, NativeStructEnhanceMark.class, MemorySegment.class}, (Object)object, n)) {
            case -1 -> MemorySegment.NULL;
            case 0 -> {
                NativeAddressable nativeAddressable = (NativeAddressable)object;
                yield nativeAddressable.address();
            }
            case 1 -> {
                NativeStructEnhanceMark structEnhanceMark = (NativeStructEnhanceMark)object;
                yield structEnhanceMark.realMemory();
            }
            case 2 -> {
                MemorySegment memorySegment;
                yield memorySegment = (MemorySegment)object;
            }
            default -> throw new StructException(String.valueOf(o.getClass()) + " is not struct,pleace call StructProxyGenerator::enhance before calling native function");
        };
    }

    public static MemoryLayout currentLayout() {
        StructProxyContext context = fetchCurrentNativeStructGenerator.get();
        if (context == null) {
            new RuntimeException().printStackTrace();
        }
        return context.memoryLayout();
    }

    public static StructProxyGenerator currentStructGenerator() {
        return fetchCurrentNativeStructGenerator.get().generator();
    }

    public static MemoryLayout calAlignLayout(List<MemoryLayout> memoryLayouts) {
        long size = 0L;
        long align = 1L;
        ArrayList<MemoryLayout> layouts = new ArrayList<MemoryLayout>();
        for (MemoryLayout memoryLayout : memoryLayouts) {
            if (size % memoryLayout.byteAlignment() == 0L) {
                size = Math.addExact(size, memoryLayout.byteSize());
                align = Math.max(align, memoryLayout.byteAlignment());
                layouts.add(memoryLayout);
                continue;
            }
            long multiple = size / memoryLayout.byteAlignment();
            long padding = (multiple + 1L) * memoryLayout.byteAlignment() - size;
            size = Math.addExact(size, padding);
            layouts.add(MemoryLayout.paddingLayout(padding));
            layouts.add(memoryLayout);
            size = Math.addExact(size, memoryLayout.byteSize());
            align = Math.max(align, memoryLayout.byteAlignment());
        }
        if (size % align != 0L) {
            long multiple = size / align;
            long padding = (multiple + 1L) * align - size;
            size = Math.addExact(size, padding);
            layouts.add(MemoryLayout.paddingLayout(padding));
        }
        return MemoryLayout.structLayout((MemoryLayout[])layouts.toArray(MemoryLayout[]::new));
    }

    public static Function<MemorySegment, Object> memoryBinder(MethodHandle methodHandle, MemoryLayout memoryLayout) throws Throwable {
        CallSite callSite = LambdaMetafactory.metafactory(MethodHandles.lookup(), "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), methodHandle, MethodType.methodType(Object.class, MemorySegment.class));
        MethodHandle target = callSite.getTarget();
        Function lambdaFunction = target.invoke();
        return ms -> lambdaFunction.apply(ms.reinterpret(memoryLayout.byteSize()));
    }

    public static Supplier<Object> ctorBinder(MethodHandle methodHandle) throws Throwable {
        CallSite callSite = LambdaMetafactory.metafactory(MethodHandles.lookup(), "get", MethodType.methodType(Supplier.class), MethodType.methodType(Object.class), methodHandle, methodHandle.type());
        return callSite.getTarget().invoke();
    }

    public static void setPtr(Object proxyStruct, long offset, Object newStructPtr) {
        MemorySegment newPtr = NativeGeneratorHelper.transToStruct(newStructPtr);
        MemorySegment struct = NativeGeneratorHelper.transToStruct(proxyStruct);
        struct.set(ValueLayout.ADDRESS, offset, newPtr);
    }

    public static void overwriteSubElement(Object proxyStruct, long offset, long size, Object newStruct) {
        MemorySegment newStructMemory = NativeGeneratorHelper.transToStruct(newStruct);
        if (newStructMemory.byteSize() != size) {
            throw new StructException("newStruct size must greater than old!");
        }
        MemorySegment struct = NativeGeneratorHelper.transToStruct(proxyStruct);
        MemorySegment.copy(newStructMemory, ValueLayout.JAVA_BYTE, 0L, struct, ValueLayout.JAVA_BYTE, offset, size);
    }

    static {
        CURRENT_GENERATOR = new ThreadLocal();
        fetchCurrentNativeCallGenerator = CURRENT_GENERATOR::get;
        STRUCT_CONTEXT = new ThreadLocal();
        fetchCurrentNativeStructGenerator = STRUCT_CONTEXT::get;
        try {
            FETCH_CURRENT_NATIVE_CALL_GENERATOR = NativeGeneratorHelper.class.getMethod("currentNativeCallGenerator", new Class[0]);
            REBIND_ASSERT_METHOD = NativeGeneratorHelper.class.getMethod("assertRebindMemory", MemorySegment.class, MemorySegment.class);
            DEREFERENCE = MethodHandles.lookup().findStatic(NativeGeneratorHelper.class, "deReferencePointer", MethodType.methodType(MemorySegment.class, MemorySegment.class, Long.TYPE));
            FETCH_CURRENT_STRUCT_CONTEXT_GENERATOR = NativeGeneratorHelper.class.getMethod("currentStructContext", new Class[0]);
            FETCH_CURRENT_STRUCT_LAYOUT_GENERATOR = NativeGeneratorHelper.class.getMethod("currentLayout", new Class[0]);
            FETCH_CURRENT_STRUCT_GENERATOR_GENERATOR = NativeGeneratorHelper.class.getMethod("currentStructGenerator", new Class[0]);
            LOAD_SO = NativeCallGenerator.class.getMethod("loadSo", Class.class);
            FETCH_STRUCT_PROXY_GENERATOR = NativeStructEnhanceMark.class.getMethod("fetchStructProxyGenerator", new Class[0]);
            REAL_MEMORY = NativeStructEnhanceMark.class.getMethod("realMemory", new Class[0]);
            REBIND_MEMORY = NativeStructEnhanceMark.class.getMethod("rebind", MemorySegment.class);
            GET_ADDRESS_FROM_MEMORY_SEGMENT = MemorySegment.class.getMethod("get", AddressLayout.class, Long.TYPE);
            REINTERPRET = MemorySegment.class.getMethod("reinterpret", Long.TYPE);
            AS_SLICE = MemorySegment.class.getMethod("asSlice", Long.TYPE, Long.TYPE);
            ENHANCE = StructProxyGenerator.class.getMethod("enhance", Class.class, MemorySegment.class);
            TRANSFORM_OBJECT_TO_STRUCT_MH = MethodHandles.lookup().findStatic(NativeGeneratorHelper.class, "transToStruct", MethodType.methodType(MemorySegment.class, Object.class));
            NATIVE_ARRAY_CTOR = MethodHandles.lookup().findConstructor(NativeArray.class, MethodType.methodType(Void.TYPE, StructProxyGenerator.class, MemorySegment.class, Class.class));
            SET_PTR = NativeGeneratorHelper.class.getMethod("setPtr", Object.class, Long.TYPE, Object.class);
            OVER_WRITE_SUB_ELEMENT = NativeGeneratorHelper.class.getMethod("overwriteSubElement", Object.class, Long.TYPE, Long.TYPE, Object.class);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

