/*
 * Decompiled with CFR 0.152.
 */
package top.dreamlike.panama.generator.proxy;

import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import top.dreamlike.panama.generator.annotation.NativeArrayMark;
import top.dreamlike.panama.generator.annotation.Pointer;
import top.dreamlike.panama.generator.helper.NativeGeneratorHelper;
import top.dreamlike.panama.generator.proxy.NativeArray;
import top.dreamlike.panama.generator.proxy.NativeCallGenerator;
import top.dreamlike.panama.generator.proxy.StructProxyGenerator;

public class InvokeDynamicFactory {
    public static CallSite nativeCallIndyFactory(MethodHandles.Lookup lookup, String methodName, MethodType methodType) throws Throwable {
        Class<?> lookupClass = lookup.lookupClass();
        NativeCallGenerator generator = lookup.findStaticVarHandle(lookupClass, "_generator", NativeCallGenerator.class).get();
        Class<?> targetInterface = lookupClass.getInterfaces()[0];
        Method method = targetInterface.getMethod(methodName, methodType.parameterArray());
        MethodHandle nativeCallMH = generator.nativeMethodHandle(method, false);
        return new ConstantCallSite(nativeCallMH);
    }

    public static CallSite shortcutIndyFactory(MethodHandles.Lookup lookup, String methodName, MethodType methodType, Object ... args) throws Throwable {
        Class<?> lookupClass = lookup.lookupClass();
        StructProxyGenerator generator = lookup.findStaticVarHandle(lookupClass, "_generator", StructProxyGenerator.class).get();
        Class<?> targetInterface = lookupClass.getInterfaces()[0];
        Method method = targetInterface.getMethod(methodName, methodType.parameterArray());
        return new ConstantCallSite(generator.generateShortcutTrustedMH(method));
    }

    public static CallSite nativeStructGetterIndyFactory(MethodHandles.Lookup lookup, String fieldName, MethodType methodType, Object ... args) throws Throwable {
        MethodHandle methodHandle;
        Class<?> fieldType;
        Class<?> proxyClass = lookup.lookupClass();
        StructProxyGenerator generator = lookup.findStaticVarHandle(proxyClass, "_generator", StructProxyGenerator.class).get();
        MemoryLayout currentLayout = lookup.findStaticVarHandle(proxyClass, "_layout", MemoryLayout.class).get();
        Field field = proxyClass.getSuperclass().getDeclaredField(fieldName);
        Class<?> clazz = fieldType = field.getType();
        Objects.requireNonNull(clazz);
        Class<?> clazz2 = clazz;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, Class.class, Class.class}, clazz2, n)) {
                case 0: {
                    Class<?> c = clazz2;
                    if (!c.isPrimitive()) {
                        n = 1;
                        continue block5;
                    }
                    methodHandle = InvokeDynamicFactory.nativeStructPrimitiveGetterIndyFactory(lookup, generator, currentLayout, field, fieldName);
                    break block5;
                }
                case 1: {
                    Class<?> c = clazz2;
                    if (!NativeArray.class.isAssignableFrom(c)) {
                        n = 2;
                        continue block5;
                    }
                    methodHandle = InvokeDynamicFactory.nativeStructNativeArrayGetterIndyFactory(lookup, generator, currentLayout, field, fieldName);
                    break block5;
                }
                case 2: {
                    Class<?> c = clazz2;
                    if (!MemorySegment.class.isAssignableFrom(c)) {
                        n = 3;
                        continue block5;
                    }
                    methodHandle = InvokeDynamicFactory.nativeStructMemorySegmentGetterIndyFactory(lookup, generator, currentLayout, field, fieldName);
                    break block5;
                }
                default: {
                    methodHandle = InvokeDynamicFactory.nativeStructSubStructGetterIndyFactory(lookup, generator, currentLayout, field, fieldName);
                    break block5;
                }
            }
            break;
        }
        MethodHandle methodHandle2 = methodHandle;
        return new ConstantCallSite(methodHandle2);
    }

    private static MethodHandle nativeStructPrimitiveGetterIndyFactory(MethodHandles.Lookup lookup, StructProxyGenerator __, MemoryLayout currentLayout, Field field, String fieldName) {
        VarHandle varHandle = StructProxyGenerator.generateVarHandle(currentLayout, fieldName);
        varHandle = MethodHandles.insertCoordinates(varHandle, 1, 0);
        MethodHandle getter = varHandle.toMethodHandle(VarHandle.AccessMode.GET);
        getter = MethodHandles.filterArguments(getter, 0, NativeGeneratorHelper.TRANSFORM_OBJECT_TO_STRUCT_MH);
        return getter;
    }

    private static MethodHandle nativeStructNativeArrayGetterIndyFactory(MethodHandles.Lookup lookup, StructProxyGenerator proxyGenerator, MemoryLayout currentLayout, Field field, String fieldName) throws Throwable {
        MethodHandle memorySegmentSupplierMH;
        NativeArrayMark arrayMark = field.getAnnotation(NativeArrayMark.class);
        if (arrayMark == null) {
            throw new IllegalArgumentException(String.valueOf(field) + " must be marked as NativeArrayMark");
        }
        long offset = currentLayout.byteOffset(MemoryLayout.PathElement.groupElement(field.getName()));
        long newSize = proxyGenerator.extract(arrayMark.size()).byteSize() * (long)arrayMark.length();
        boolean asPointer = field.getAnnotation(Pointer.class) != null || arrayMark.asPointer();
        MethodHandle nativeArrayCtorMh = NativeGeneratorHelper.NATIVE_ARRAY_CTOR.bindTo(proxyGenerator);
        nativeArrayCtorMh = MethodHandles.insertArguments(nativeArrayCtorMh, 1, field.getDeclaringClass());
        if (asPointer) {
            MethodHandle resizeMh = lookup.unreflect(NativeGeneratorHelper.REINTERPRET);
            resizeMh = MethodHandles.insertArguments(resizeMh, 1, newSize);
            MethodHandle handle = lookup.unreflect(NativeGeneratorHelper.GET_ADDRESS_FROM_MEMORY_SEGMENT);
            handle = MethodHandles.insertArguments(handle, 1, ValueLayout.ADDRESS, offset);
            memorySegmentSupplierMH = MethodHandles.filterArguments(resizeMh, 0, handle);
            memorySegmentSupplierMH = MethodHandles.filterArguments(memorySegmentSupplierMH, 0, NativeGeneratorHelper.TRANSFORM_OBJECT_TO_STRUCT_MH);
        } else {
            MethodHandle handle = lookup.unreflect(NativeGeneratorHelper.AS_SLICE);
            handle = MethodHandles.insertArguments(handle, 1, offset, newSize);
            memorySegmentSupplierMH = MethodHandles.filterArguments(handle, 0, NativeGeneratorHelper.TRANSFORM_OBJECT_TO_STRUCT_MH);
        }
        nativeArrayCtorMh = MethodHandles.filterArguments(nativeArrayCtorMh, 0, memorySegmentSupplierMH);
        return nativeArrayCtorMh;
    }

    private static MethodHandle nativeStructMemorySegmentGetterIndyFactory(MethodHandles.Lookup lookup, StructProxyGenerator proxyGenerator, MemoryLayout currentLayout, Field field, String fieldName) throws Throwable {
        MethodHandle memorySegmentSupplierMH;
        long offset = currentLayout.byteOffset(MemoryLayout.PathElement.groupElement(field.getName()));
        NativeArrayMark arrayMark = field.getAnnotation(NativeArrayMark.class);
        boolean pointerMarked = field.getAnnotation(Pointer.class) != null;
        boolean pointer = arrayMark.asPointer();
        if (pointerMarked) {
            MethodHandle handle = lookup.unreflect(NativeGeneratorHelper.GET_ADDRESS_FROM_MEMORY_SEGMENT);
            handle = MethodHandles.insertArguments(handle, 1, ValueLayout.ADDRESS, offset);
            return MethodHandles.filterArguments(handle, 0, NativeGeneratorHelper.TRANSFORM_OBJECT_TO_STRUCT_MH);
        }
        long newSize = proxyGenerator.extract(arrayMark.size()).byteSize() * (long)arrayMark.length();
        if (pointer) {
            MethodHandle resizeMh = lookup.unreflect(NativeGeneratorHelper.REINTERPRET);
            resizeMh = MethodHandles.insertArguments(resizeMh, 1, newSize);
            MethodHandle handle = lookup.unreflect(NativeGeneratorHelper.GET_ADDRESS_FROM_MEMORY_SEGMENT);
            handle = MethodHandles.insertArguments(handle, 1, ValueLayout.ADDRESS, offset);
            memorySegmentSupplierMH = MethodHandles.filterArguments(resizeMh, 0, handle);
            memorySegmentSupplierMH = MethodHandles.filterArguments(memorySegmentSupplierMH, 0, NativeGeneratorHelper.TRANSFORM_OBJECT_TO_STRUCT_MH);
        } else {
            MethodHandle handle = lookup.unreflect(NativeGeneratorHelper.AS_SLICE);
            handle = MethodHandles.insertArguments(handle, 1, offset, newSize);
            memorySegmentSupplierMH = MethodHandles.filterArguments(handle, 0, NativeGeneratorHelper.TRANSFORM_OBJECT_TO_STRUCT_MH);
        }
        return memorySegmentSupplierMH;
    }

    private static MethodHandle nativeStructSubStructGetterIndyFactory(MethodHandles.Lookup lookup, StructProxyGenerator proxyGenerator, MemoryLayout currentLayout, Field field, String fieldName) throws Throwable {
        MethodHandle memorySegmentSupplierMH;
        boolean isPointer;
        long subStructLayoutSize = currentLayout.select(MemoryLayout.PathElement.groupElement(field.getName())).byteSize();
        long offset = currentLayout.byteOffset(MemoryLayout.PathElement.groupElement(field.getName()));
        boolean bl = isPointer = field.getAnnotation(Pointer.class) != null;
        if (isPointer) {
            MethodHandle resizeMh = lookup.unreflect(NativeGeneratorHelper.REINTERPRET);
            resizeMh = MethodHandles.insertArguments(resizeMh, 1, subStructLayoutSize);
            MethodHandle handle = lookup.unreflect(NativeGeneratorHelper.GET_ADDRESS_FROM_MEMORY_SEGMENT);
            handle = MethodHandles.insertArguments(handle, 1, ValueLayout.ADDRESS, offset);
            memorySegmentSupplierMH = MethodHandles.filterArguments(resizeMh, 0, handle);
            memorySegmentSupplierMH = MethodHandles.filterArguments(memorySegmentSupplierMH, 0, NativeGeneratorHelper.TRANSFORM_OBJECT_TO_STRUCT_MH);
        } else {
            MethodHandle handle = lookup.unreflect(NativeGeneratorHelper.AS_SLICE);
            handle = MethodHandles.insertArguments(handle, 1, offset, subStructLayoutSize);
            memorySegmentSupplierMH = MethodHandles.filterArguments(handle, 0, NativeGeneratorHelper.TRANSFORM_OBJECT_TO_STRUCT_MH);
        }
        MethodHandle returnEnhance = StructProxyGenerator.ENHANCE_MH.asType(StructProxyGenerator.ENHANCE_MH.type().changeReturnType(field.getType())).bindTo(proxyGenerator).bindTo(field.getType());
        return MethodHandles.filterArguments(returnEnhance, 0, memorySegmentSupplierMH);
    }
}

