/*
 * Decompiled with CFR 0.152.
 */
package top.dreamlike.panama.generator.proxy;

import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import top.dreamlike.panama.generator.helper.NativeAddressable;
import top.dreamlike.panama.generator.helper.NativeGeneratorHelper;
import top.dreamlike.panama.generator.helper.NativeStructEnhanceMark;
import top.dreamlike.panama.generator.proxy.StructProxyGenerator;

public final class NativeArray<T>
implements NativeStructEnhanceMark,
List<T>,
NativeAddressable {
    private MemorySegment segment;
    private final MemoryLayout elementLayout;
    private final StructProxyGenerator generator;
    private final long len;
    private final List<T> mappingJavaBean;

    public NativeArray(StructProxyGenerator generator, MemorySegment memorySegment, Class<T> component) {
        if (component == Object.class) {
            throw new IllegalArgumentException("please fill generic param");
        }
        this.segment = memorySegment;
        this.elementLayout = generator.extract(component);
        if (this.segment.byteSize() % this.elementLayout.byteSize() != 0L) {
            throw new IllegalArgumentException("segment.byteSize() % layout.byteSize() must equals 0!, array size is" + memorySegment.byteSize() + ", single component size is" + this.elementLayout.byteSize());
        }
        this.len = this.segment.byteSize() / this.elementLayout.byteSize();
        this.generator = generator;
        Object[] mappingJavaBeanArray = new Object[(int)this.len];
        int l = 0;
        int offset = 0;
        while ((long)l < this.len) {
            MemorySegment slice = this.segment.asSlice((long)offset, this.elementLayout.byteSize());
            mappingJavaBeanArray[l] = generator.enhance(component, slice);
            ++l;
            offset += (int)this.elementLayout.byteSize();
        }
        this.mappingJavaBean = Arrays.asList(mappingJavaBeanArray);
    }

    @Override
    public StructProxyGenerator fetchStructProxyGenerator() {
        return this.generator;
    }

    @Override
    public MemorySegment realMemory() {
        return this.segment;
    }

    @Override
    public MemorySegment address() {
        return this.segment;
    }

    @Override
    public long sizeof() {
        return this.segment.byteSize();
    }

    @Override
    public MemoryLayout layout() {
        return MemoryLayout.sequenceLayout(this.len, this.elementLayout);
    }

    @Override
    public void rebind(MemorySegment memorySegment) {
        NativeGeneratorHelper.assertRebindMemory(memorySegment, this.segment);
        this.segment = memorySegment;
    }

    @Override
    public int size() {
        return this.mappingJavaBean.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mappingJavaBean.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.mappingJavaBean.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.mappingJavaBean.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.mappingJavaBean.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.mappingJavaBean.toArray(a);
    }

    @Override
    public boolean add(T t) {
        return this.mappingJavaBean.add(t);
    }

    @Override
    public boolean remove(Object o) {
        return this.mappingJavaBean.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.mappingJavaBean.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.mappingJavaBean.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.mappingJavaBean.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.mappingJavaBean.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.mappingJavaBean.retainAll(c);
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        this.mappingJavaBean.replaceAll(operator);
    }

    @Override
    public void sort(Comparator<? super T> c) {
        this.mappingJavaBean.sort(c);
    }

    @Override
    public void clear() {
        this.mappingJavaBean.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.mappingJavaBean.equals(o);
    }

    @Override
    public int hashCode() {
        return this.mappingJavaBean.hashCode();
    }

    @Override
    public T get(int index) {
        return this.mappingJavaBean.get(index);
    }

    @Override
    public T set(int index, T element) {
        return this.mappingJavaBean.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        this.mappingJavaBean.add(index, element);
    }

    @Override
    public T remove(int index) {
        return this.mappingJavaBean.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.mappingJavaBean.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.mappingJavaBean.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.mappingJavaBean.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.mappingJavaBean.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.mappingJavaBean.subList(fromIndex, toIndex);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.mappingJavaBean.spliterator();
    }

    @Override
    public void addFirst(T t) {
        this.mappingJavaBean.addFirst(t);
    }

    @Override
    public void addLast(T t) {
        this.mappingJavaBean.addLast(t);
    }

    @Override
    public T getFirst() {
        return this.mappingJavaBean.getFirst();
    }

    @Override
    public T getLast() {
        return this.mappingJavaBean.getLast();
    }

    @Override
    public T removeFirst() {
        return this.mappingJavaBean.removeFirst();
    }

    @Override
    public T removeLast() {
        return this.mappingJavaBean.removeLast();
    }

    @Override
    public List<T> reversed() {
        return this.mappingJavaBean.reversed();
    }

    @Override
    public <T1> T1[] toArray(IntFunction<T1[]> generator) {
        return this.mappingJavaBean.toArray(generator);
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        return this.mappingJavaBean.removeIf(filter);
    }

    @Override
    public Stream<T> stream() {
        return this.mappingJavaBean.stream();
    }

    @Override
    public Stream<T> parallelStream() {
        return this.mappingJavaBean.parallelStream();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.mappingJavaBean.forEach(action);
    }
}

