/*
 * Decompiled with CFR 0.152.
 */
package top.dreamlike.panama.generator.proxy;

import java.lang.foreign.FunctionDescriptor;
import java.lang.reflect.Method;
import java.util.Objects;
import org.graalvm.nativeimage.hosted.RuntimeForeignAccess;
import top.dreamlike.panama.generator.helper.DowncallContext;
import top.dreamlike.panama.generator.proxy.NativeCallGenerator;

public class NativeImageHelper {
    public static final String PROPERTY_IMAGE_CODE_KEY = "org.graalvm.nativeimage.imagecode";
    public static final String PROPERTY_IMAGE_CODE_VALUE_BUILDTIME = "buildtime";
    public static final String PROPERTY_IMAGE_CODE_VALUE_RUNTIME = "runtime";
    public static final String PROPERTY_IMAGE_KIND_KEY = "org.graalvm.nativeimage.kind";
    public static final String PROPERTY_IMAGE_KIND_VALUE_SHARED_LIBRARY = "shared";
    public static final String PROPERTY_IMAGE_KIND_VALUE_EXECUTABLE = "executable";

    public static void initPanamaFeature(Class nativeInterface) {
        Objects.requireNonNull(nativeInterface);
        if (!nativeInterface.isInterface()) {
            throw new IllegalArgumentException(String.valueOf(nativeInterface) + " is not interface");
        }
        NativeCallGenerator generator = new NativeCallGenerator();
        for (Method method : nativeInterface.getMethods()) {
            if (method.isBridge() || method.isDefault() || method.isSynthetic()) continue;
            DowncallContext downcallContext = generator.parseDowncallContext(method);
            FunctionDescriptor desc = downcallContext.fd();
            RuntimeForeignAccess.registerForDowncall((Object)desc, (Object[])downcallContext.ops());
        }
    }

    public static boolean inImageCode() {
        return NativeImageHelper.inImageBuildtimeCode() || NativeImageHelper.inImageRuntimeCode();
    }

    public static boolean inImageRuntimeCode() {
        return PROPERTY_IMAGE_CODE_VALUE_RUNTIME.equals(System.getProperty(PROPERTY_IMAGE_CODE_KEY));
    }

    public static boolean inImageBuildtimeCode() {
        return PROPERTY_IMAGE_CODE_VALUE_BUILDTIME.equals(System.getProperty(PROPERTY_IMAGE_CODE_KEY));
    }

    public static boolean inExecutable() {
        NativeImageHelper.ensureKindAvailable();
        return PROPERTY_IMAGE_KIND_VALUE_EXECUTABLE.equals(System.getProperty(PROPERTY_IMAGE_KIND_KEY));
    }

    public static boolean isSharedLibrary() {
        NativeImageHelper.ensureKindAvailable();
        return PROPERTY_IMAGE_KIND_VALUE_SHARED_LIBRARY.equals(System.getProperty(PROPERTY_IMAGE_KIND_KEY));
    }

    private static void ensureKindAvailable() {
        if (NativeImageHelper.inImageCode() && System.getProperty(PROPERTY_IMAGE_KIND_KEY) == null) {
            throw new UnsupportedOperationException("The kind of image that is built (executable or shared library) is not available yet because the relevant command line option has not been parsed yet.");
        }
    }
}

