/*
 * Decompiled with CFR 0.152.
 */
package top.dreamlike.panama.generator.proxy;

import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SegmentAllocator;
import java.lang.foreign.StructLayout;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.invoke.VarHandle;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import top.dreamlike.panama.generator.proxy.ErrorNo;
import top.dreamlike.panama.generator.proxy.MemoryLifetimeScope;

class NativeLookup
implements SymbolLookup {
    public static final MethodHandle AllocateErrorBuffer_MH;
    public static final MethodHandle FILL_ERROR_CODE_VOID_MH;
    public static final MethodHandle FILL_ERROR_CODE_BYTE_MH;
    public static final MethodHandle FILL_ERROR_CODE_SHORT_MH;
    public static final MethodHandle FILL_ERROR_CODE_INT_MH;
    public static final MethodHandle FILL_ERROR_CODE_LONG_MH;
    public static final MethodHandle FILL_ERROR_CODE_FLOAT_MH;
    public static final MethodHandle FILL_ERROR_CODE_DOUBLE_MH;
    public static final MethodHandle FILL_ERROR_CODE_BOOLEAN_MH;
    public static final MethodHandle FILL_ERROR_CODE_CHAR_MH;
    public static final MethodHandle FILL_ERROR_CODE_ADDRESS_MH;
    private static final MethodHandle MEMORY_SEGMENT_HEAP_INT_MH;
    private static final MethodHandle MEMORY_SEGMENT_HEAP_LONG_MH;
    private static final MethodHandle MEMORY_SEGMENT_HEAP_CHAR_MH;
    private static final MethodHandle MEMORY_SEGMENT_HEAP_FLOAT_MH;
    private static final MethodHandle MEMORY_SEGMENT_HEAP_DOUBLE_MH;
    private static final MethodHandle MEMORY_SEGMENT_HEAP_BYTE_MH;
    private static final MethodHandle MEMORY_SEGMENT_HEAP_SHORT_MH;
    private static final VarHandle errorHandle;
    static ThreadLocal<MemorySegment> errorBuffer;

    NativeLookup() {
    }

    public static MemorySegment allocateErrorBuffer() {
        SegmentAllocator allocator = MemoryLifetimeScope.currentAllocator.orElseThrow(() -> new IllegalStateException("please active MemoryLifetimeScope first!"));
        StructLayout structLayout = Linker.Option.captureStateLayout();
        MemorySegment buffer = allocator.allocate(structLayout);
        errorBuffer.set(buffer);
        return buffer;
    }

    public static MethodHandle fillErrorNoAfterReturn(MethodHandle methodHandle) {
        MethodHandle methodHandle2;
        TypeDescriptor.OfField returnType;
        TypeDescriptor.OfField ofField = returnType = methodHandle.type().returnType();
        Objects.requireNonNull(ofField);
        TypeDescriptor.OfField ofField2 = ofField;
        int n = 0;
        block10: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, Class.class, Class.class, Class.class, Class.class, Class.class, Class.class, Class.class}, (Class)ofField2, n)) {
                case 0: {
                    TypeDescriptor.OfField c = ofField2;
                    if (c != Integer.TYPE) {
                        n = 1;
                        continue block10;
                    }
                    methodHandle2 = MethodHandles.filterReturnValue(methodHandle, FILL_ERROR_CODE_INT_MH);
                    break block10;
                }
                case 1: {
                    TypeDescriptor.OfField c = ofField2;
                    if (c != Long.TYPE) {
                        n = 2;
                        continue block10;
                    }
                    methodHandle2 = MethodHandles.filterReturnValue(methodHandle, FILL_ERROR_CODE_LONG_MH);
                    break block10;
                }
                case 2: {
                    TypeDescriptor.OfField c = ofField2;
                    if (c != Short.TYPE) {
                        n = 3;
                        continue block10;
                    }
                    methodHandle2 = MethodHandles.filterReturnValue(methodHandle, FILL_ERROR_CODE_SHORT_MH);
                    break block10;
                }
                case 3: {
                    TypeDescriptor.OfField c = ofField2;
                    if (c != Character.TYPE) {
                        n = 4;
                        continue block10;
                    }
                    methodHandle2 = MethodHandles.filterReturnValue(methodHandle, FILL_ERROR_CODE_CHAR_MH);
                    break block10;
                }
                case 4: {
                    TypeDescriptor.OfField c = ofField2;
                    if (c != Float.TYPE) {
                        n = 5;
                        continue block10;
                    }
                    methodHandle2 = MethodHandles.filterReturnValue(methodHandle, FILL_ERROR_CODE_FLOAT_MH);
                    break block10;
                }
                case 5: {
                    TypeDescriptor.OfField c = ofField2;
                    if (c != Double.TYPE) {
                        n = 6;
                        continue block10;
                    }
                    methodHandle2 = MethodHandles.filterReturnValue(methodHandle, FILL_ERROR_CODE_DOUBLE_MH);
                    break block10;
                }
                case 6: {
                    TypeDescriptor.OfField c = ofField2;
                    if (c != Boolean.TYPE) {
                        n = 7;
                        continue block10;
                    }
                    methodHandle2 = MethodHandles.filterReturnValue(methodHandle, FILL_ERROR_CODE_BOOLEAN_MH);
                    break block10;
                }
                case 7: {
                    TypeDescriptor.OfField c = ofField2;
                    if (c != Void.TYPE) {
                        n = 8;
                        continue block10;
                    }
                    methodHandle2 = MethodHandles.filterReturnValue(methodHandle, FILL_ERROR_CODE_VOID_MH);
                    break block10;
                }
                default: {
                    methodHandle2 = MethodHandles.filterReturnValue(methodHandle, FILL_ERROR_CODE_ADDRESS_MH);
                    break block10;
                }
            }
            break;
        }
        return methodHandle2;
    }

    public static MethodHandle heapAccessMH(Class primitiveType) {
        MethodHandle methodHandle;
        if (!primitiveType.isPrimitive()) {
            throw new IllegalArgumentException("primitiveType must be a primitive type");
        }
        Class clazz = primitiveType;
        Objects.requireNonNull(clazz);
        Class clazz2 = clazz;
        int n = 0;
        block9: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, Class.class, Class.class, Class.class, Class.class, Class.class, Class.class}, (Class)clazz2, n)) {
                case 0: {
                    Class c = clazz2;
                    if (c != Integer.TYPE) {
                        n = 1;
                        continue block9;
                    }
                    methodHandle = MEMORY_SEGMENT_HEAP_INT_MH;
                    break block9;
                }
                case 1: {
                    Class c = clazz2;
                    if (c != Long.TYPE) {
                        n = 2;
                        continue block9;
                    }
                    methodHandle = MEMORY_SEGMENT_HEAP_LONG_MH;
                    break block9;
                }
                case 2: {
                    Class c = clazz2;
                    if (c != Short.TYPE) {
                        n = 3;
                        continue block9;
                    }
                    methodHandle = MEMORY_SEGMENT_HEAP_SHORT_MH;
                    break block9;
                }
                case 3: {
                    Class c = clazz2;
                    if (c != Character.TYPE) {
                        n = 4;
                        continue block9;
                    }
                    methodHandle = MEMORY_SEGMENT_HEAP_CHAR_MH;
                    break block9;
                }
                case 4: {
                    Class c = clazz2;
                    if (c != Float.TYPE) {
                        n = 5;
                        continue block9;
                    }
                    methodHandle = MEMORY_SEGMENT_HEAP_FLOAT_MH;
                    break block9;
                }
                case 5: {
                    Class c = clazz2;
                    if (c != Double.TYPE) {
                        n = 6;
                        continue block9;
                    }
                    methodHandle = MEMORY_SEGMENT_HEAP_DOUBLE_MH;
                    break block9;
                }
                case 6: {
                    Class c = clazz2;
                    if (c != Byte.TYPE) {
                        n = 7;
                        continue block9;
                    }
                    methodHandle = MEMORY_SEGMENT_HEAP_BYTE_MH;
                    break block9;
                }
                default: {
                    throw new IllegalArgumentException("primitiveType must be a primitive type");
                }
            }
            break;
        }
        return methodHandle;
    }

    public static void fillTLErrorVoid() {
        MemorySegment errorSegment = errorBuffer.get();
        int errorCode = errorHandle.get(errorSegment);
        ErrorNo.error.set(errorCode);
    }

    public static byte fillTLErrorByte(byte returnValue) {
        NativeLookup.fillTLErrorVoid();
        return returnValue;
    }

    public static int fillTLErrorInt(int returnValue) {
        NativeLookup.fillTLErrorVoid();
        return returnValue;
    }

    public static long fillTLErrorLong(long returnValue) {
        NativeLookup.fillTLErrorVoid();
        return returnValue;
    }

    public static float fillTLErrorFloat(float returnValue) {
        NativeLookup.fillTLErrorVoid();
        return returnValue;
    }

    public static double fillTLErrorDouble(double returnValue) {
        NativeLookup.fillTLErrorVoid();
        return returnValue;
    }

    public static boolean fillTLErrorBoolean(boolean returnValue) {
        NativeLookup.fillTLErrorVoid();
        return returnValue;
    }

    public static char fillTLErrorChar(char returnValue) {
        NativeLookup.fillTLErrorVoid();
        return returnValue;
    }

    public static short fillTLErrorShort(short returnValue) {
        NativeLookup.fillTLErrorVoid();
        return returnValue;
    }

    public static MemorySegment fillTLErrorAddress(MemorySegment returnValue) {
        NativeLookup.fillTLErrorVoid();
        return returnValue;
    }

    @Override
    public Optional<MemorySegment> find(String name) {
        return SymbolLookup.loaderLookup().find(name).or(() -> Linker.nativeLinker().defaultLookup().find(name));
    }

    public MemorySegment findOrException(String name) {
        return this.find(name).orElseThrow(() -> new IllegalArgumentException("cant link to " + name));
    }

    public MethodHandle downcallHandle(String name, FunctionDescriptor functionDescriptor, Linker.Option ... options) {
        return this.find(name).map(functionAddr -> Linker.nativeLinker().downcallHandle((MemorySegment)functionAddr, functionDescriptor, options)).orElseThrow(() -> new IllegalArgumentException("cant link " + name));
    }

    public static MemoryLayout primitiveMapToMemoryLayout(Class source) {
        ValueLayout valueLayout;
        Class clazz = source;
        Objects.requireNonNull(clazz);
        Class clazz2 = clazz;
        int n = 0;
        block10: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, Class.class, Class.class, Class.class, Class.class, Class.class, Class.class, Class.class}, (Class)clazz2, n)) {
                case 0: {
                    Class c = clazz2;
                    if (c != Integer.TYPE) {
                        n = 1;
                        continue block10;
                    }
                    valueLayout = ValueLayout.JAVA_INT;
                    break block10;
                }
                case 1: {
                    Class c = clazz2;
                    if (c != Long.TYPE) {
                        n = 2;
                        continue block10;
                    }
                    valueLayout = ValueLayout.JAVA_LONG;
                    break block10;
                }
                case 2: {
                    Class c = clazz2;
                    if (c != Double.TYPE) {
                        n = 3;
                        continue block10;
                    }
                    valueLayout = ValueLayout.JAVA_DOUBLE;
                    break block10;
                }
                case 3: {
                    Class c = clazz2;
                    if (c != Float.TYPE) {
                        n = 4;
                        continue block10;
                    }
                    valueLayout = ValueLayout.JAVA_FLOAT;
                    break block10;
                }
                case 4: {
                    Class c = clazz2;
                    if (c != Byte.TYPE) {
                        n = 5;
                        continue block10;
                    }
                    valueLayout = ValueLayout.JAVA_BYTE;
                    break block10;
                }
                case 5: {
                    Class c = clazz2;
                    if (c != Boolean.TYPE) {
                        n = 6;
                        continue block10;
                    }
                    valueLayout = ValueLayout.JAVA_BOOLEAN;
                    break block10;
                }
                case 6: {
                    Class c = clazz2;
                    if (c != Character.TYPE) {
                        n = 7;
                        continue block10;
                    }
                    valueLayout = ValueLayout.JAVA_CHAR;
                    break block10;
                }
                case 7: {
                    Class c = clazz2;
                    if (c != Short.TYPE) {
                        n = 8;
                        continue block10;
                    }
                    valueLayout = ValueLayout.JAVA_SHORT;
                    break block10;
                }
                default: {
                    valueLayout = null;
                    break block10;
                }
            }
            break;
        }
        return valueLayout;
    }

    static {
        errorBuffer = new ThreadLocal();
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            AllocateErrorBuffer_MH = lookup.findStatic(NativeLookup.class, "allocateErrorBuffer", MethodType.methodType(MemorySegment.class));
            errorHandle = MethodHandles.insertCoordinates(Linker.Option.captureStateLayout().varHandle(MemoryLayout.PathElement.groupElement("errno")), 1, 0);
            FILL_ERROR_CODE_VOID_MH = lookup.findStatic(NativeLookup.class, "fillTLErrorVoid", MethodType.methodType(Void.TYPE));
            FILL_ERROR_CODE_BYTE_MH = lookup.findStatic(NativeLookup.class, "fillTLErrorByte", MethodType.methodType(Byte.TYPE, Byte.TYPE));
            FILL_ERROR_CODE_SHORT_MH = lookup.findStatic(NativeLookup.class, "fillTLErrorShort", MethodType.methodType(Short.TYPE, Short.TYPE));
            FILL_ERROR_CODE_INT_MH = lookup.findStatic(NativeLookup.class, "fillTLErrorInt", MethodType.methodType(Integer.TYPE, Integer.TYPE));
            FILL_ERROR_CODE_LONG_MH = lookup.findStatic(NativeLookup.class, "fillTLErrorLong", MethodType.methodType(Long.TYPE, Long.TYPE));
            FILL_ERROR_CODE_FLOAT_MH = lookup.findStatic(NativeLookup.class, "fillTLErrorFloat", MethodType.methodType(Float.TYPE, Float.TYPE));
            FILL_ERROR_CODE_DOUBLE_MH = lookup.findStatic(NativeLookup.class, "fillTLErrorDouble", MethodType.methodType(Double.TYPE, Double.TYPE));
            FILL_ERROR_CODE_BOOLEAN_MH = lookup.findStatic(NativeLookup.class, "fillTLErrorBoolean", MethodType.methodType(Boolean.TYPE, Boolean.TYPE));
            FILL_ERROR_CODE_CHAR_MH = lookup.findStatic(NativeLookup.class, "fillTLErrorChar", MethodType.methodType(Character.TYPE, Character.TYPE));
            FILL_ERROR_CODE_ADDRESS_MH = lookup.findStatic(NativeLookup.class, "fillTLErrorAddress", MethodType.methodType(MemorySegment.class, MemorySegment.class));
            MEMORY_SEGMENT_HEAP_INT_MH = lookup.findStatic(MemorySegment.class, "ofArray", MethodType.methodType(MemorySegment.class, int[].class));
            MEMORY_SEGMENT_HEAP_LONG_MH = lookup.findStatic(MemorySegment.class, "ofArray", MethodType.methodType(MemorySegment.class, long[].class));
            MEMORY_SEGMENT_HEAP_CHAR_MH = lookup.findStatic(MemorySegment.class, "ofArray", MethodType.methodType(MemorySegment.class, char[].class));
            MEMORY_SEGMENT_HEAP_FLOAT_MH = lookup.findStatic(MemorySegment.class, "ofArray", MethodType.methodType(MemorySegment.class, float[].class));
            MEMORY_SEGMENT_HEAP_DOUBLE_MH = lookup.findStatic(MemorySegment.class, "ofArray", MethodType.methodType(MemorySegment.class, double[].class));
            MEMORY_SEGMENT_HEAP_BYTE_MH = lookup.findStatic(MemorySegment.class, "ofArray", MethodType.methodType(MemorySegment.class, byte[].class));
            MEMORY_SEGMENT_HEAP_SHORT_MH = lookup.findStatic(MemorySegment.class, "ofArray", MethodType.methodType(MemorySegment.class, short[].class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

