/*
 * Decompiled with CFR 0.152.
 */
package top.dreamlike.panama.generator.proxy;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.classfile.AccessFlags;
import java.lang.classfile.Annotation;
import java.lang.classfile.AnnotationElement;
import java.lang.classfile.AnnotationValue;
import java.lang.classfile.ClassFile;
import java.lang.classfile.ClassFileElement;
import java.lang.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import java.lang.classfile.attribute.RuntimeVisibleParameterAnnotationsAttribute;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import sun.misc.Unsafe;
import top.dreamlike.panama.generator.annotation.Alignment;
import top.dreamlike.panama.generator.annotation.CLib;
import top.dreamlike.panama.generator.annotation.CompileTimeGenerate;
import top.dreamlike.panama.generator.annotation.NativeArrayMark;
import top.dreamlike.panama.generator.annotation.NativeFunction;
import top.dreamlike.panama.generator.annotation.Pointer;
import top.dreamlike.panama.generator.annotation.ShortcutOption;
import top.dreamlike.panama.generator.annotation.Skip;
import top.dreamlike.panama.generator.annotation.Union;
import top.dreamlike.panama.generator.exception.StructException;
import top.dreamlike.panama.generator.helper.ClassFileHelper;
import top.dreamlike.panama.generator.helper.NativeGeneratorHelper;
import top.dreamlike.panama.generator.helper.NativeStructEnhanceMark;
import top.dreamlike.panama.generator.proxy.NativeArray;
import top.dreamlike.panama.generator.proxy.NativeCallGenerator;
import top.dreamlike.panama.generator.proxy.StructProxyGenerator;

@SupportedAnnotationTypes(value={"top.dreamlike.panama.generator.annotation.CompileTimeGenerate"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_22)
@SupportedOptions(value={"indy.enable", "generate.graal.feature.enable", "generate.graal.feature.name"})
public class PanamaAnnotationProcessor
extends AbstractProcessor {
    static final String INDY_ENABLE = "indy.enable";
    static final String GENERATE_GRAAL_FEATURE_ENABLE = "generate.graal.feature.enable";
    static final String GENERATE_GRAAL_FEATURE_NAME = "generate.graal.feature.name";
    private ProcessingEnvironment env;
    private boolean enableIndy;
    private boolean enableGraalFeature;
    private String packageName;
    private String className;
    private String featureName;
    private StructProxyGenerator structProxyGenerator;
    private NativeCallGenerator nativeCallGenerator;
    private ArrayList<ProxyPair> proxyPair = new ArrayList();
    private ClassFile classFile = ClassFile.of();
    private MethodHandle DEFINE_CLASS_METHOD_HANDLE;
    private Map<String, Class> classMap = new HashMap<String, Class<NativeArray>>(Map.of(MemorySegment.class.getCanonicalName(), MemorySegment.class, NativeArray.class.getCanonicalName(), NativeArray.class));

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.env = processingEnv;
        this.enableIndy = Boolean.parseBoolean(this.env.getOptions().getOrDefault(INDY_ENABLE, "false"));
        this.enableGraalFeature = Boolean.parseBoolean(this.env.getOptions().getOrDefault(GENERATE_GRAAL_FEATURE_ENABLE, "false"));
        this.featureName = this.env.getOptions().getOrDefault(GENERATE_GRAAL_FEATURE_NAME, "PanamaGeneratorFeature");
        this.packageName = null;
        this.className = this.featureName;
        int lastIndexOf = this.featureName.lastIndexOf(".");
        if (lastIndexOf != -1) {
            this.packageName = this.featureName.substring(0, lastIndexOf);
            this.className = this.featureName.substring(lastIndexOf + 1);
        }
        this.structProxyGenerator = new StructProxyGenerator();
        this.structProxyGenerator.skipInit = false;
        this.structProxyGenerator.classDataPeek = (className, bytecode) -> {
            try (OutputStream ouputStream = this.env.getFiler().createClassFile((CharSequence)className, new Element[0]).openOutputStream();){
                ouputStream.write((byte[])bytecode);
                ouputStream.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        this.nativeCallGenerator = new NativeCallGenerator(this.structProxyGenerator);
        if (this.enableIndy) {
            this.nativeCallGenerator.indyMode();
        } else {
            this.nativeCallGenerator.plainMode();
        }
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            Unsafe unsafe = (Unsafe)field.get(null);
            Field implLookup = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            long offset = unsafe.staticFieldOffset(implLookup);
            MethodHandles.Lookup mastKey = (MethodHandles.Lookup)unsafe.getObject(unsafe.staticFieldBase(implLookup), offset);
            this.DEFINE_CLASS_METHOD_HANDLE = mastKey.findVirtual(ClassLoader.class, "defineClass", MethodType.methodType(Class.class, byte[].class, Integer.TYPE, Integer.TYPE));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        block15: {
            try {
                Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(CompileTimeGenerate.class);
                for (Element element : elements) {
                    if (!(element instanceof TypeElement)) continue;
                    TypeElement typeElement = (TypeElement)element;
                    boolean isInterface = typeElement.getKind().isInterface();
                    Class runtimeClass = this.toRuntiumeClass(typeElement.asType());
                    CompileTimeGenerate.GenerateType generateType = element.getAnnotation(CompileTimeGenerate.class).value();
                    if (!isInterface) {
                        this.structProxyGenerator.enhance(runtimeClass);
                        this.proxyPair.add(new ProxyPair(runtimeClass.getName(), StructProxyGenerator.generateProxyClassName(runtimeClass), CompileTimeGenerate.GenerateType.STRUCT_PROXY));
                        continue;
                    }
                    switch (generateType) {
                        case STRUCT_PROXY: {
                            this.structProxyGenerator.enhance(runtimeClass);
                            this.proxyPair.add(new ProxyPair(runtimeClass.getName(), StructProxyGenerator.generateProxyClassName(runtimeClass), CompileTimeGenerate.GenerateType.STRUCT_PROXY));
                            break;
                        }
                        case SHORTCUT: {
                            this.structProxyGenerator.generateShortcut(runtimeClass);
                            this.proxyPair.add(new ProxyPair(runtimeClass.getName(), this.structProxyGenerator.generatorShortcutProxyName(runtimeClass), CompileTimeGenerate.GenerateType.SHORTCUT));
                            break;
                        }
                        case NATIVE_CALL: {
                            this.nativeCallGenerator.generate(runtimeClass);
                            this.proxyPair.add(new ProxyPair(runtimeClass.getName(), this.nativeCallGenerator.generateProxyClassName(runtimeClass), CompileTimeGenerate.GenerateType.NATIVE_CALL));
                        }
                    }
                }
                if (!roundEnv.processingOver() || !this.enableGraalFeature) break block15;
                String generatedFeatureJsonFile = this.generateFeature();
                try (OutputStream outputStream = this.env.getFiler().createSourceFile(this.featureName, new Element[0]).openOutputStream();){
                    outputStream.write(generatedFeatureJsonFile.getBytes(StandardCharsets.UTF_8));
                    outputStream.flush();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return false;
    }

    private Class toRuntiumeClass(TypeMirror mirror) {
        if (mirror.getKind() == TypeKind.VOID) {
            return Void.TYPE;
        }
        if (mirror.getKind().isPrimitive()) {
            return switch (mirror.getKind()) {
                case TypeKind.BOOLEAN -> Boolean.TYPE;
                case TypeKind.BYTE -> Byte.TYPE;
                case TypeKind.SHORT -> Short.TYPE;
                case TypeKind.INT -> Integer.TYPE;
                case TypeKind.LONG -> Long.TYPE;
                case TypeKind.CHAR -> Character.TYPE;
                case TypeKind.FLOAT -> Float.TYPE;
                case TypeKind.DOUBLE -> Double.TYPE;
                case TypeKind.VOID -> Void.TYPE;
                default -> throw new IllegalArgumentException("should not reach here! " + String.valueOf(mirror));
            };
        }
        if (mirror.getKind() == TypeKind.ARRAY) {
            ArrayType type = (ArrayType)mirror;
            TypeMirror typeComponentType = type.getComponentType();
            if (!typeComponentType.getKind().isPrimitive()) {
                throw new IllegalArgumentException("array must be primitive type");
            }
            return switch (mirror.getKind()) {
                case TypeKind.BYTE -> byte[].class;
                case TypeKind.SHORT -> short[].class;
                case TypeKind.INT -> int[].class;
                case TypeKind.LONG -> long[].class;
                case TypeKind.CHAR -> char[].class;
                case TypeKind.FLOAT -> float[].class;
                case TypeKind.DOUBLE -> double[].class;
                default -> throw new IllegalArgumentException("should not reach here! " + String.valueOf(mirror));
            };
        }
        TypeElement currentTypeElement = (TypeElement)this.env.getTypeUtils().asElement(mirror);
        if (mirror.getKind() != TypeKind.DECLARED) {
            throw new IllegalStateException("dont support other type!current kind is: " + String.valueOf((Object)mirror.getKind()) + ", in " + String.valueOf(currentTypeElement));
        }
        Class aClass = this.classMap.get(currentTypeElement.getQualifiedName().toString());
        if (aClass != null) {
            return aClass;
        }
        boolean isInterface = currentTypeElement.getKind().isInterface();
        CompileTimeGenerate compileTimeGenerate = currentTypeElement.getAnnotation(CompileTimeGenerate.class);
        CompileTimeGenerate.GenerateType type = compileTimeGenerate.value();
        try {
            Class c = null;
            if (!isInterface) {
                c = this.toRuntimeClassForNativeStruct(currentTypeElement);
            } else {
                c = switch (type) {
                    default -> throw new MatchException(null, null);
                    case CompileTimeGenerate.GenerateType.STRUCT_PROXY -> this.toRuntimeClassForNativeStruct(currentTypeElement);
                    case CompileTimeGenerate.GenerateType.SHORTCUT -> this.toRuntimeClassForShortcutInterface(currentTypeElement);
                    case CompileTimeGenerate.GenerateType.NATIVE_CALL -> this.toRuntimeClassForNativeCallInterface(currentTypeElement);
                };
            }
            return c;
        }
        catch (Throwable t) {
            throw new StructException("should not reach here!", t);
        }
    }

    public Class toRuntimeClassForNativeCallInterface(TypeElement currentTypeElement) throws Throwable {
        String thisClassName = this.getRealName(currentTypeElement);
        Object thisClassDescStr = thisClassName.replace(".", "/");
        thisClassDescStr = "L" + (String)thisClassDescStr + ";";
        ClassDesc thisClassDesc = ClassDesc.ofDescriptor((String)thisClassDescStr);
        byte[] classByteCode = this.classFile.build(thisClassDesc, classBuilder -> {
            classBuilder.withFlags(new AccessFlag[]{AccessFlag.PUBLIC, AccessFlag.INTERFACE, AccessFlag.ABSTRACT});
            CLib cLib = currentTypeElement.getAnnotation(CLib.class);
            if (cLib != null) {
                Annotation annotation = Annotation.of((ClassDesc)ClassFileHelper.toDesc(CLib.class), (AnnotationElement[])new AnnotationElement[]{AnnotationElement.of((String)"value", (AnnotationValue)AnnotationValue.ofString((String)cLib.value())), AnnotationElement.of((String)"inClassPath", (AnnotationValue)AnnotationValue.ofBoolean((boolean)cLib.inClassPath())), AnnotationElement.of((String)"isLib", (AnnotationValue)AnnotationValue.ofBoolean((boolean)cLib.isLib()))});
                classBuilder.with((ClassFileElement)RuntimeVisibleAnnotationsAttribute.of((Annotation[])new Annotation[]{annotation}));
            }
            List<ExecutableElement> executableElements = ElementFilter.methodsIn(currentTypeElement.getEnclosedElements());
            for (ExecutableElement executableElement : executableElements) {
                if (executableElement.getModifiers().contains((Object)Modifier.DEFAULT)) continue;
                Class returnClass = this.toRuntiumeClass(executableElement.getReturnType());
                List<? extends VariableElement> parameters = executableElement.getParameters();
                String parametersSignature = parameters.stream().map(VariableElement::asType).map(this::toRuntiumeClass).map(ClassFileHelper::toSignature).collect(Collectors.joining());
                String returnSignature = ClassFileHelper.toSignature(returnClass);
                MethodTypeDesc methodTypeDesc = MethodTypeDesc.ofDescriptor("(" + parametersSignature + ")" + returnSignature);
                classBuilder.withMethod(executableElement.getSimpleName().toString(), methodTypeDesc, AccessFlags.ofMethod((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC, AccessFlag.ABSTRACT}).flagsMask(), it -> {
                    List<List> parameterAnnotation = parameters.stream().map(v -> v.getAnnotation(Pointer.class) == null ? List.of() : List.of(Annotation.of((ClassDesc)ClassFileHelper.toDesc(Pointer.class), (AnnotationElement[])new AnnotationElement[0]))).toList();
                    it.with((ClassFileElement)RuntimeVisibleParameterAnnotationsAttribute.of(parameterAnnotation));
                    NativeFunction nativeFunction = executableElement.getAnnotation(NativeFunction.class);
                    if (nativeFunction != null) {
                        Annotation annotation = Annotation.of((ClassDesc)ClassFileHelper.toDesc(NativeFunction.class), (AnnotationElement[])new AnnotationElement[]{AnnotationElement.of((String)"value", (AnnotationValue)AnnotationValue.ofString((String)nativeFunction.value())), AnnotationElement.of((String)"fast", (AnnotationValue)AnnotationValue.ofBoolean((boolean)nativeFunction.fast())), AnnotationElement.of((String)"allowPassHeap", (AnnotationValue)AnnotationValue.ofBoolean((boolean)nativeFunction.allowPassHeap())), AnnotationElement.of((String)"returnIsPointer", (AnnotationValue)AnnotationValue.ofBoolean((boolean)nativeFunction.returnIsPointer())), AnnotationElement.of((String)"needErrorNo", (AnnotationValue)AnnotationValue.ofBoolean((boolean)nativeFunction.needErrorNo()))});
                        it.with((ClassFileElement)RuntimeVisibleAnnotationsAttribute.of((Annotation[])new Annotation[]{annotation}));
                    }
                });
            }
        });
        return this.define(thisClassName, classByteCode);
    }

    public Class toRuntimeClassForShortcutInterface(TypeElement currentTypeElement) throws Throwable {
        String thisClassName = this.getRealName(currentTypeElement);
        ClassDesc thisClassDesc = ClassFileHelper.toDesc(thisClassName);
        byte[] bytecode = this.classFile.build(thisClassDesc, cb -> {
            cb.withFlags(new AccessFlag[]{AccessFlag.PUBLIC, AccessFlag.INTERFACE, AccessFlag.ABSTRACT});
            List<ExecutableElement> executableElements = ElementFilter.methodsIn(currentTypeElement.getEnclosedElements());
            for (ExecutableElement executableElement : executableElements) {
                if (executableElement.getModifiers().contains((Object)Modifier.DEFAULT) || executableElement.getModifiers().contains((Object)Modifier.DEFAULT)) continue;
                Class returnClass = this.toRuntiumeClass(executableElement.getReturnType());
                List<? extends VariableElement> parameters = executableElement.getParameters();
                String parametersSignature = parameters.stream().map(VariableElement::asType).map(this::toRuntiumeClass).map(ClassFileHelper::toSignature).collect(Collectors.joining());
                String returnSignature = ClassFileHelper.toSignature(returnClass);
                MethodTypeDesc methodTypeDesc = MethodTypeDesc.ofDescriptor("(" + parametersSignature + ")" + returnSignature);
                cb.withMethod(executableElement.getSimpleName().toString(), methodTypeDesc, AccessFlags.ofMethod((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC, AccessFlag.ABSTRACT}).flagsMask(), it -> {
                    ShortcutOption option = executableElement.getAnnotation(ShortcutOption.class);
                    if (option != null) {
                        List<AnnotationValue> valued = Stream.of(option.value()).map(AnnotationValue::ofString).map(c -> c).toList();
                        AnnotationElement[] annotationElementArray = new AnnotationElement[3];
                        annotationElementArray[0] = AnnotationElement.of((String)"value", (AnnotationValue)AnnotationValue.ofArray(valued));
                        annotationElementArray[1] = AnnotationElement.of((String)"mode", (AnnotationValue)AnnotationValue.ofEnum((ClassDesc)ClassFileHelper.toDesc(VarHandle.AccessMode.class), (String)option.mode().name()));
                        annotationElementArray[2] = AnnotationElement.ofClass((String)"owner", (ClassDesc)ClassFileHelper.toDesc(this.getAnnotationAttributeClassValue(option::owner)));
                        Annotation annotation = Annotation.of((ClassDesc)ClassFileHelper.toDesc(ShortcutOption.class), (AnnotationElement[])annotationElementArray);
                        it.with((ClassFileElement)RuntimeVisibleAnnotationsAttribute.of((Annotation[])new Annotation[]{annotation}));
                    }
                });
            }
        });
        return this.define(thisClassName, bytecode);
    }

    private Class getAnnotationAttributeClassValue(Supplier<Class> supplier) {
        try {
            return supplier.get();
        }
        catch (MirroredTypeException exception) {
            TypeMirror typeMirror = exception.getTypeMirror();
            return this.toRuntiumeClass(typeMirror);
        }
    }

    public Class toRuntimeClassForNativeStruct(TypeElement currentTypeElement) throws Throwable {
        String thisClassName = this.getRealName(currentTypeElement);
        Object thisClassDescStr = thisClassName.replace(".", "/");
        thisClassDescStr = "L" + (String)thisClassDescStr + ";";
        ClassDesc thisClassDesc = ClassDesc.ofDescriptor((String)thisClassDescStr);
        byte[] byteCode = this.classFile.build(thisClassDesc, classBuilder -> {
            Union union;
            classBuilder.withFlags(new AccessFlag[]{AccessFlag.PUBLIC});
            Alignment alignment = currentTypeElement.getAnnotation(Alignment.class);
            if (alignment != null) {
                Annotation annotation = Annotation.of((ClassDesc)ClassFileHelper.toDesc(Alignment.class), (AnnotationElement[])new AnnotationElement[]{AnnotationElement.of((String)"byteSize", (AnnotationValue)AnnotationValue.ofInt((int)alignment.byteSize()))});
                classBuilder.with((ClassFileElement)RuntimeVisibleAnnotationsAttribute.of((Annotation[])new Annotation[]{annotation}));
            }
            if ((union = currentTypeElement.getAnnotation(Union.class)) != null) {
                Annotation annotation = Annotation.of((ClassDesc)ClassFileHelper.toDesc(Union.class), (AnnotationElement[])new AnnotationElement[0]);
                classBuilder.with((ClassFileElement)RuntimeVisibleAnnotationsAttribute.of((Annotation[])new Annotation[]{annotation}));
            }
            List<VariableElement> fields = ElementFilter.fieldsIn(currentTypeElement.getEnclosedElements());
            for (VariableElement field : fields) {
                classBuilder.withField(field.getSimpleName().toString(), ClassFileHelper.toDesc(this.toRuntiumeClass(field.asType())), it -> {
                    NativeArrayMark nativeArrayMark;
                    it.withFlags(this.calModifier(field.getModifiers()));
                    ArrayList<Annotation> annotations = new ArrayList<Annotation>();
                    Pointer pointer = field.getAnnotation(Pointer.class);
                    if (pointer != null) {
                        Class layout;
                        try {
                            layout = pointer.targetLayout();
                        }
                        catch (MirroredTypeException exception) {
                            TypeMirror typeMirror = exception.getTypeMirror();
                            layout = this.toRuntiumeClass(typeMirror);
                        }
                        annotations.add(Annotation.of((ClassDesc)ClassFileHelper.toDesc(Pointer.class), (AnnotationElement[])new AnnotationElement[]{AnnotationElement.of((String)"targetLayout", (AnnotationValue)AnnotationValue.ofClass((ClassDesc)ClassFileHelper.toDesc(layout)))}));
                    }
                    if ((nativeArrayMark = field.getAnnotation(NativeArrayMark.class)) != null) {
                        Class size;
                        try {
                            size = nativeArrayMark.size();
                        }
                        catch (MirroredTypeException exception) {
                            TypeMirror typeMirror = exception.getTypeMirror();
                            size = this.toRuntiumeClass(typeMirror);
                        }
                        annotations.add(Annotation.of((ClassDesc)ClassFileHelper.toDesc(NativeArrayMark.class), (AnnotationElement[])new AnnotationElement[]{AnnotationElement.of((String)"size", (AnnotationValue)AnnotationValue.ofClass((ClassDesc)ClassFileHelper.toDesc(size))), AnnotationElement.of((String)"length", (AnnotationValue)AnnotationValue.ofInt((int)nativeArrayMark.length())), AnnotationElement.of((String)"asPointer", (AnnotationValue)AnnotationValue.ofBoolean((boolean)nativeArrayMark.asPointer()))}));
                    }
                    if (field.getAnnotation(Skip.class) != null) {
                        annotations.add(Annotation.of((ClassDesc)ClassFileHelper.toDesc(Skip.class), (AnnotationElement[])new AnnotationElement[0]));
                    }
                    it.with((ClassFileElement)RuntimeVisibleAnnotationsAttribute.of(annotations));
                });
            }
        });
        return this.define(thisClassName, byteCode);
    }

    public Class define(String name, byte[] bytecode) throws Throwable {
        ClassLoader classLoader = PanamaAnnotationProcessor.class.getClassLoader();
        try {
            return Class.forName(name, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.dump(name, bytecode);
            return this.DEFINE_CLASS_METHOD_HANDLE.invokeExact(PanamaAnnotationProcessor.class.getClassLoader(), bytecode, 0, bytecode.length);
        }
    }

    private int calModifier(Set<Modifier> modifiers) {
        int modifier = 0;
        for (Modifier m : modifiers) {
            modifier |= (switch (m) {
                default -> throw new MatchException(null, null);
                case Modifier.PUBLIC -> 1;
                case Modifier.FINAL -> 16;
                case Modifier.PRIVATE -> 2;
                case Modifier.PROTECTED -> 4;
                case Modifier.STATIC -> 8;
                case Modifier.SYNCHRONIZED -> 32;
                case Modifier.VOLATILE -> 64;
                case Modifier.TRANSIENT -> 128;
                case Modifier.NATIVE -> 256;
                case Modifier.ABSTRACT -> 1024;
                case Modifier.STRICTFP -> 2048;
                case Modifier.DEFAULT, Modifier.NON_SEALED, Modifier.SEALED -> 0;
            });
        }
        return modifier;
    }

    private String generateDuringSetupBlock() {
        ArrayList<ProxyPair> callInterfaceNames = this.proxyPair;
        return callInterfaceNames.stream().filter(p -> p.generateType == CompileTimeGenerate.GenerateType.NATIVE_CALL).map(proxyPair -> "NativeImageHelper.initPanamaFeature(" + proxyPair.origin + ".class);").collect(Collectors.joining("\n"));
    }

    private String generateBeforeAnalysisBlock() {
        Stream<String> interfaceStream = this.proxyPair.stream().filter(p -> p.generateType == CompileTimeGenerate.GenerateType.NATIVE_CALL || p.generateType == CompileTimeGenerate.GenerateType.SHORTCUT).map(p -> String.format("        needRegisterClass = Class.forName(\"%s\", false, getClass().getClassLoader());\n        RuntimeReflection.registerFieldLookup(needRegisterClass, \"_generator\");\n        RuntimeReflection.registerConstructorLookup(needRegisterClass);\n        RuntimeReflection.registerMethodLookup(needRegisterClass,\"<init>\");\n        RuntimeReflection.register(needRegisterClass);\n        RuntimeReflection.registerForReflectiveInstantiation(needRegisterClass);\n        needRegisterClass = Class.forName(\"%s\", false, getClass().getClassLoader());\n        RuntimeReflection.registerAllMethods(needRegisterClass);\n\n        RuntimeReflection.registerAllDeclaredClasses(needRegisterClass);\n      //  RuntimeClassInitialization.initializeAtBuildTime(needRegisterClass);\n", p.proxy, p.origin));
        Stream<String> structProxyStream = this.proxyPair.stream().filter(p -> p.generateType == CompileTimeGenerate.GenerateType.STRUCT_PROXY).map(p -> String.format("        needRegisterClass = Class.forName(\"%s\", false, getClass().getClassLoader());\n      //  RuntimeReflection.registerConstructorLookup(needRegisterClass, MemorySegment.class);\n        RuntimeReflection.register(needRegisterClass);\n        RuntimeReflection.registerAllDeclaredFields(needRegisterClass);\n        needRegisterClass = Class.forName(\"%s\", false, getClass().getClassLoader());\n        constructor = needRegisterClass.getDeclaredConstructor(MemorySegment.class);\n        RuntimeReflection.register(constructor);\n        RuntimeReflection.register(needRegisterClass);\n        RuntimeReflection.registerAllDeclaredConstructors(needRegisterClass);\n      //  RuntimeClassInitialization.initializeAtBuildTime(needRegisterClass);\n", p.origin, p.proxy));
        Stream<String> baseStream = Stream.of(NativeStructEnhanceMark.class, NativeGeneratorHelper.class).map(Class::getName).map(name -> String.format("needRegisterClass = Class.forName(\"%s\", false, getClass().getClassLoader());\n RuntimeReflection.registerAllMethods(needRegisterClass);\n", name));
        return Stream.of(baseStream, interfaceStream, structProxyStream).flatMap(Function.identity()).collect(Collectors.joining("\n"));
    }

    private String generateFeature() {
        ArrayList<Object> statements = new ArrayList<Object>();
        if (this.packageName != null) {
            statements.add("package " + this.packageName + ";");
        }
        statements.add("import org.graalvm.nativeimage.hosted.Feature;\nimport org.graalvm.nativeimage.hosted.RuntimeReflection;\nimport java.lang.foreign.MemorySegment;\nimport top.dreamlike.panama.generator.proxy.NativeImageHelper;\nimport org.graalvm.nativeimage.hosted.RuntimeClassInitialization;\nimport java.lang.reflect.Constructor;\n");
        statements.add(String.format("public class %s implements Feature {\n    @Override\n    public void duringSetup(DuringSetupAccess access) {\n       Class needRegisterClass = null;\n\n       try {\n         %s\n       } catch(Throwable t) {\n          t.printStackTrace();\n       }\n    }\n\n    @Override\n    public void beforeAnalysis(BeforeAnalysisAccess access) {\n        Class needRegisterClass = null;\n         Constructor constructor;\n        try {\n         %s\n        } catch(Throwable t) {\n          t.printStackTrace();\n       }\n    }\n}\n", this.className, this.generateDuringSetupBlock(), this.generateBeforeAnalysisBlock()));
        return String.join((CharSequence)"\n", statements);
    }

    public String getRealName(TypeElement typeElement) {
        String mayHost;
        String qualifiedName = typeElement.getQualifiedName().toString();
        if (!typeElement.getNestingKind().isNested()) {
            return qualifiedName;
        }
        ArrayDeque<String> realNameDeque = new ArrayDeque<String>();
        while (true) {
            int lastIndexOf = qualifiedName.lastIndexOf(".");
            mayHost = qualifiedName.substring(0, lastIndexOf);
            TypeElement element = this.env.getElementUtils().getTypeElement(mayHost);
            realNameDeque.addFirst(qualifiedName.substring(lastIndexOf + 1));
            realNameDeque.addFirst("$");
            if (element == null || !element.getNestingKind().isNested()) break;
            qualifiedName = mayHost;
        }
        realNameDeque.addFirst(mayHost);
        return String.join((CharSequence)"", realNameDeque);
    }

    private void dump(String className, byte[] bytes) {
        if (System.getProperty("panama.generator.debug") == null) {
            return;
        }
        try {
            String fileName = className + ".class";
            Path path = Path.of("apt-generator", new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            Files.write(Path.of(path.toFile().getAbsolutePath(), fileName), bytes, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        }
        catch (Throwable r) {
            throw new RuntimeException(r);
        }
    }

    private record ProxyPair(String origin, String proxy, CompileTimeGenerate.GenerateType generateType) {
    }
}

