/*
 * Decompiled with CFR 0.152.
 */
package top.dreamlike.panama.generator.proxy;

import java.lang.classfile.AccessFlags;
import java.lang.classfile.ClassBuilder;
import java.lang.classfile.ClassFile;
import java.lang.classfile.CodeBuilder;
import java.lang.classfile.TypeKind;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicCallSiteDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.foreign.AddressLayout;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SegmentAllocator;
import java.lang.foreign.SequenceLayout;
import java.lang.foreign.UnionLayout;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import top.dreamlike.panama.generator.annotation.Alignment;
import top.dreamlike.panama.generator.annotation.NativeArrayMark;
import top.dreamlike.panama.generator.annotation.Pointer;
import top.dreamlike.panama.generator.annotation.ShortcutOption;
import top.dreamlike.panama.generator.annotation.Skip;
import top.dreamlike.panama.generator.annotation.Union;
import top.dreamlike.panama.generator.exception.StructException;
import top.dreamlike.panama.generator.helper.ClassFileHelper;
import top.dreamlike.panama.generator.helper.NativeAddressable;
import top.dreamlike.panama.generator.helper.NativeGeneratorHelper;
import top.dreamlike.panama.generator.helper.NativeStructEnhanceMark;
import top.dreamlike.panama.generator.helper.StructProxyContext;
import top.dreamlike.panama.generator.proxy.InvokeDynamicFactory;
import top.dreamlike.panama.generator.proxy.NativeArray;
import top.dreamlike.panama.generator.proxy.NativeArrayPointer;
import top.dreamlike.panama.generator.proxy.NativeImageHelper;
import top.dreamlike.panama.generator.proxy.NativeLookup;

public class StructProxyGenerator {
    static final String MEMORY_FIELD = "_realMemory";
    static final String GENERATOR_FIELD = "_generator";
    static final String LAYOUT_FIELD = "_layout";
    BiConsumer<String, byte[]> classDataPeek;
    private static final Method REALMEMORY_METHOD;
    private static final Method GENERATOR_VARHANDLE;
    private static final Method SHORTCUT_INDY_BOOTSTRAP_METHOD;
    static final MethodHandle ENHANCE_MH;
    private volatile boolean use_lmf = !NativeImageHelper.inExecutable();
    private ClassFile classFile = ClassFile.of();
    boolean skipInit = false;
    final Map<Class<?>, Function<MemorySegment, Object>> ctorCaches = new ConcurrentHashMap();
    private final Map<Class<?>, MemoryLayout> layoutCaches = new ConcurrentHashMap();
    private static final Set<VarHandle.AccessMode> getterModes;
    private static final Set<VarHandle.AccessMode> setterModes;

    private static String upperFirstChar(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static VarHandle generateVarHandle(MemoryLayout current, String name) {
        VarHandle handle = current.varHandle(MemoryLayout.PathElement.groupElement(name));
        handle = MethodHandles.insertCoordinates(handle, 1, 0);
        return handle.withInvokeExactBehavior();
    }

    public static MemorySegment findMemorySegment(Object o) {
        if (o instanceof NativeStructEnhanceMark) {
            NativeStructEnhanceMark mark = (NativeStructEnhanceMark)o;
            return mark.realMemory();
        }
        if (o instanceof NativeAddressable) {
            NativeAddressable addressable = (NativeAddressable)o;
            return addressable.address();
        }
        throw new StructException("before findMemorySegment, you should enhance it");
    }

    public <T> T enhance(MemorySegment binder, T ... dummy) {
        return this.enhance((Class<T>)dummy.getClass().componentType(), binder);
    }

    @SafeVarargs
    public final <T> NativeArray<T> enhanceArray(MemorySegment chunk, T ... dummy) {
        Class<?> component = dummy.getClass().getComponentType();
        return new NativeArray(this, chunk, component);
    }

    public static boolean isNativeStruct(Object o) {
        return o instanceof NativeStructEnhanceMark || o instanceof NativeAddressable;
    }

    public static void rebind(Object proxyObject, MemorySegment memorySegment) {
        if (proxyObject instanceof NativeStructEnhanceMark) {
            NativeStructEnhanceMark memoryHolder = (NativeStructEnhanceMark)proxyObject;
            memoryHolder.rebind(memorySegment);
            return;
        }
        throw new StructException("before rebinding, you should enhance it");
    }

    public <T> T enhance(Class<T> t, MemorySegment binder) {
        Objects.requireNonNull(t);
        if (t.isPrimitive()) {
            throw new IllegalArgumentException("only support not primitive type!");
        }
        if (binder.address() == MemorySegment.NULL.address()) {
            return null;
        }
        try {
            return (T)this.ctorCaches.computeIfAbsent(t, this::enhance).apply(binder);
        }
        catch (Throwable throwable) {
            throw new StructException("should not reach here!", throwable);
        }
    }

    public <T> T allocate(SegmentAllocator allocator, Class<T> t) {
        return this.enhance(t, allocator.allocate(this.extract(t)));
    }

    public void setProxySavePath(String proxySavePath) {
        this.classDataPeek = (className, classData) -> {
            try {
                Path dir = Path.of(proxySavePath, new String[0]);
                if (!Files.exists(dir, new LinkOption[0])) {
                    Files.createDirectory(dir, new FileAttribute[0]);
                }
                Files.write(Path.of(proxySavePath, className + ".class"), classData, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        };
    }

    private MemoryLayout setAlignment(MemoryLayout memoryLayout, Alignment alignment) {
        if (alignment == null || alignment.byteSize() <= 0) {
            return memoryLayout;
        }
        return memoryLayout.withByteAlignment(alignment.byteSize());
    }

    public boolean isUnion(Class type) {
        return type.getAnnotation(Union.class) != null;
    }

    public <T> MemoryLayout extract(Class<T> structClass) {
        if (structClass == Void.TYPE) {
            return null;
        }
        MemoryLayout memoryLayout = this.layoutCaches.get(structClass);
        if (memoryLayout != null) {
            return memoryLayout;
        }
        MemoryLayout mayPrimitive = NativeLookup.primitiveMapToMemoryLayout(structClass);
        if (mayPrimitive != null) {
            this.layoutCaches.put(structClass, mayPrimitive);
            return mayPrimitive;
        }
        ArrayList<MemoryLayout> list = new ArrayList<MemoryLayout>();
        Alignment alignment = structClass.getAnnotation(Alignment.class);
        if (alignment != null && alignment.byteSize() <= 0) {
            throw new StructException("alignment cant be " + alignment.byteSize());
        }
        int alignmentByteSize = alignment == null ? -1 : alignment.byteSize();
        for (Field field : structClass.getDeclaredFields()) {
            MemoryLayout layout;
            if (this.needSkip(field)) continue;
            if (field.getType().isPrimitive()) {
                layout = NativeLookup.primitiveMapToMemoryLayout(field.getType()).withName(field.getName());
                layout = alignmentByteSize == -1 ? layout : layout.withByteAlignment(alignmentByteSize);
                list.add(layout);
                continue;
            }
            if (field.getAnnotation(Pointer.class) != null || field.getType() == NativeArrayPointer.class) {
                AddressLayout addressLayout = Optional.ofNullable(field.getAnnotation(Pointer.class)).map(Pointer::targetLayout).filter(c -> !c.equals(Void.TYPE)).or(() -> field.getType() == NativeArrayPointer.class || MemorySegment.class.isAssignableFrom(field.getType()) ? Optional.empty() : Optional.of(field.getType())).map(this::extract).map(targetLayout -> ValueLayout.ADDRESS.withName(field.getName()).withTargetLayout((MemoryLayout)targetLayout)).orElse(ValueLayout.ADDRESS.withName(field.getName()));
                list.add(addressLayout);
                continue;
            }
            if (field.getType() == MemorySegment.class || field.getType() == NativeArray.class) {
                NativeArrayMark nativeArrayMark = field.getAnnotation(NativeArrayMark.class);
                if (nativeArrayMark != null) {
                    if (nativeArrayMark.asPointer()) {
                        list.add(ValueLayout.ADDRESS.withName(field.getName()));
                        continue;
                    }
                    SequenceLayout layout2 = MemoryLayout.sequenceLayout(nativeArrayMark.length(), this.extract(nativeArrayMark.size()));
                    list.add(layout2.withName(field.getName()));
                    continue;
                }
                throw new StructException(String.valueOf(field) + " must be pointer or nativeArray");
            }
            layout = this.extract(field.getType()).withName(field.getName());
            layout = alignmentByteSize == -1 ? layout : layout.withByteAlignment(alignmentByteSize);
            list.add(layout);
        }
        if (this.isUnion(structClass)) {
            UnionLayout unionLayout = MemoryLayout.unionLayout((MemoryLayout[])list.toArray(MemoryLayout[]::new));
            this.layoutCaches.put(structClass, unionLayout);
            return unionLayout;
        }
        memoryLayout = NativeGeneratorHelper.calAlignLayout(list);
        this.layoutCaches.put(structClass, memoryLayout);
        return memoryLayout;
    }

    <T> Function<MemorySegment, Object> enhance(Class<T> targetClass) {
        try {
            Object classByteCode;
            MemoryLayout structMemoryLayout = this.extract(targetClass);
            NativeGeneratorHelper.STRUCT_CONTEXT.set(new StructProxyContext(this, structMemoryLayout));
            String className = StructProxyGenerator.generateProxyClassName(targetClass);
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(targetClass, MethodHandles.lookup());
            Class<?> aClass = null;
            try {
                aClass = lookup.findClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (aClass == null) {
                ClassDesc thisClassDesc = ClassDesc.of(className);
                classByteCode = this.classFile.build(thisClassDesc, classBuilder -> {
                    this.generatorCtor((ClassBuilder)classBuilder, thisClassDesc, targetClass);
                    ArrayList<Consumer<CodeBuilder>> clinitBlocks = new ArrayList<Consumer<CodeBuilder>>();
                    Consumer<CodeBuilder> interfaceClinit = this.implementStructMarkInterface((ClassBuilder)classBuilder, thisClassDesc);
                    clinitBlocks.add(interfaceClinit);
                    for (Field field : targetClass.getDeclaredFields()) {
                        Consumer<CodeBuilder> consumer;
                        if (this.needSkip(field)) continue;
                        Objects.requireNonNull(field.getType());
                        int index$1 = 0;
                        block6: while (true) {
                            Class<?> selector0$temp;
                            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, Class.class, Class.class}, selector0$temp, index$1)) {
                                case 0: {
                                    Class<?> c = selector0$temp;
                                    if (!c.isPrimitive()) {
                                        index$1 = 1;
                                        continue block6;
                                    }
                                    consumer = this.generatePrimitiveFieldVarHandle((ClassBuilder)classBuilder, thisClassDesc, field, structMemoryLayout);
                                    break block6;
                                }
                                case 1: {
                                    Class<?> c = selector0$temp;
                                    if (!c.equals(NativeArray.class)) {
                                        index$1 = 2;
                                        continue block6;
                                    }
                                    consumer = this.generateNativeArray((ClassBuilder)classBuilder, thisClassDesc, field, structMemoryLayout);
                                    break block6;
                                }
                                case 2: {
                                    Class<?> c = selector0$temp;
                                    if (!MemorySegment.class.isAssignableFrom(c)) {
                                        index$1 = 3;
                                        continue block6;
                                    }
                                    consumer = this.generateMemorySegmentField((ClassBuilder)classBuilder, thisClassDesc, field, structMemoryLayout);
                                    break block6;
                                }
                                default: {
                                    consumer = this.generatorSubStructField((ClassBuilder)classBuilder, thisClassDesc, field, structMemoryLayout);
                                    break block6;
                                }
                            }
                            break;
                        }
                        Consumer<CodeBuilder> clinitBlock = consumer;
                        clinitBlocks.add(clinitBlock);
                    }
                    classBuilder.withMethodBody("<clinit>", ConstantDescs.MTD_void, AccessFlag.STATIC.mask(), it -> {
                        clinitBlocks.forEach(init -> init.accept(it));
                        it.return_();
                    });
                });
                if (this.classDataPeek != null) {
                    this.classDataPeek.accept(className, (byte[])classByteCode);
                }
                aClass = lookup.defineClass((byte[])classByteCode);
            }
            if (!this.skipInit) {
                lookup.ensureInitialized(aClass);
            }
            MethodHandle ctorMh = MethodHandles.lookup().findConstructor(aClass, MethodType.methodType(Void.TYPE, MemorySegment.class));
            if (this.use_lmf) {
                classByteCode = NativeGeneratorHelper.memoryBinder(ctorMh, structMemoryLayout);
                return classByteCode;
            }
            MethodHandle ctorErased = ctorMh.asType(ctorMh.type().changeReturnType(Object.class));
            Function<MemorySegment, Object> function = memorySegment -> {
                memorySegment = memorySegment.reinterpret(structMemoryLayout.byteSize());
                try {
                    return ctorErased.invokeExact((MemorySegment)memorySegment);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return null;
                }
            };
            return function;
        }
        catch (Throwable e) {
            throw new StructException("should not reach here!", e);
        }
        finally {
            NativeGeneratorHelper.STRUCT_CONTEXT.remove();
        }
    }

    public <T> void register(Class<T> target) {
        this.enhance(target);
    }

    public <T> Supplier<T> generateShortcut(Class<T> shortcutInterface) {
        if (!shortcutInterface.isInterface()) {
            throw new IllegalArgumentException("shortcut should be interface!");
        }
        String proxyName = this.generatorShortcutProxyName(shortcutInterface);
        NativeGeneratorHelper.STRUCT_CONTEXT.set(new StructProxyContext(this, null));
        try {
            Class<Object> targetProxyClass = null;
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(shortcutInterface, MethodHandles.lookup());
            try {
                targetProxyClass = lookup.findClass(proxyName);
            }
            catch (ClassNotFoundException ignore) {
                targetProxyClass = this.generateShortcutClass(lookup, shortcutInterface);
            }
            if (!this.skipInit) {
                lookup.ensureInitialized(targetProxyClass);
            }
            MethodHandle methodHandle = MethodHandles.lookup().findConstructor(targetProxyClass, MethodType.methodType(Void.TYPE));
            if (this.use_lmf) {
                Supplier<Object> supplier = NativeGeneratorHelper.ctorBinder(methodHandle);
                return supplier;
            }
            Supplier<Object> supplier = () -> {
                MethodHandle mh = methodHandle.asType(methodHandle.type().changeReturnType(Object.class));
                try {
                    return mh.invokeExact();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    return null;
                }
            };
            return supplier;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            NativeGeneratorHelper.STRUCT_CONTEXT.remove();
        }
    }

    private <T> Class<T> generateShortcutClass(MethodHandles.Lookup lookup, Class<T> interfaceClass) throws IllegalAccessException {
        List<ShortCutInfo> shortCutInfoList = Arrays.stream(interfaceClass.getMethods()).filter(m -> !m.isSynthetic() && !m.isBridge() && !m.isDefault()).map(this::parseShortcutMethod).toList();
        String shortcutProxyName = this.generatorShortcutProxyName(interfaceClass);
        ClassDesc thisClass = ClassDesc.of(shortcutProxyName);
        byte[] byteCode = this.classFile.build(thisClass, cb -> {
            cb.withField(GENERATOR_FIELD, ClassFileHelper.toDesc(StructProxyGenerator.class), AccessFlags.ofField((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC, AccessFlag.STATIC, AccessFlag.FINAL}).flagsMask());
            cb.withInterfaceSymbols(new ClassDesc[]{ClassFileHelper.toDesc(interfaceClass)});
            for (ShortCutInfo info : shortCutInfoList) {
                Method method = info.method;
                cb.withMethodBody(method.getName(), ClassFileHelper.toMethodDescriptor(method), AccessFlags.ofMethod((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC}).flagsMask(), it -> {
                    ClassFileHelper.loadAllArgs(method, it);
                    it.invokedynamic(DynamicCallSiteDesc.of(MethodHandleDesc.ofMethod(DirectMethodHandleDesc.Kind.STATIC, ClassFileHelper.toDesc(InvokeDynamicFactory.class), SHORTCUT_INDY_BOOTSTRAP_METHOD.getName(), ClassFileHelper.toMethodDescriptor(SHORTCUT_INDY_BOOTSTRAP_METHOD)), method.getName(), ClassFileHelper.toMethodDescriptor(method)));
                    ClassFileHelper.returnValue(it, method.getReturnType());
                });
            }
            cb.withMethodBody("<clinit>", ConstantDescs.MTD_void, AccessFlag.STATIC.mask(), it -> {
                ClassFileHelper.invoke(it, NativeGeneratorHelper.FETCH_CURRENT_STRUCT_GENERATOR_GENERATOR);
                it.putstatic(thisClass, GENERATOR_FIELD, ClassFileHelper.toDesc(StructProxyGenerator.class));
                it.return_();
            });
            cb.withMethodBody("<init>", ConstantDescs.MTD_void, AccessFlags.ofMethod((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC}).flagsMask(), it -> {
                it.aload(0);
                it.invokespecial(ConstantDescs.CD_Object, "<init>", ConstantDescs.MTD_void);
                it.return_();
            });
        });
        if (this.classDataPeek != null) {
            this.classDataPeek.accept(shortcutProxyName, byteCode);
        }
        return lookup.defineClass(byteCode);
    }

    private ShortCutInfo parseShortcutMethod(Method shortcutMethod) {
        MemoryLayout targetFieldLayout;
        ShortcutOption option = shortcutMethod.getAnnotation(ShortcutOption.class);
        if (option == null) {
            throw new IllegalArgumentException("shortcut method should be marked as ShortcutOption");
        }
        Class owner = option.owner();
        if (NativeLookup.primitiveMapToMemoryLayout(owner) != null) {
            throw new IllegalArgumentException("owner cant be primitive!");
        }
        VarHandle.AccessMode accessMode = option.mode();
        if (!getterModes.contains((Object)accessMode) && !setterModes.contains((Object)accessMode)) {
            throw new IllegalArgumentException("mode should be getter or setter");
        }
        boolean isGetter = getterModes.contains((Object)accessMode);
        Parameter[] parameters = shortcutMethod.getParameters();
        if (isGetter) {
            if (parameters.length != 1 || !parameters[0].getType().equals(owner) && !MemorySegment.class.isAssignableFrom(parameters[0].getType())) {
                throw new IllegalArgumentException("getter shortcut method should have one parameter and type should be `owner` or MemorySegment");
            }
            if (!shortcutMethod.getReturnType().isPrimitive() || shortcutMethod.getReturnType() == Void.TYPE) {
                throw new IllegalArgumentException("getter shortcut method should return primitive type");
            }
            targetFieldLayout = NativeLookup.primitiveMapToMemoryLayout(shortcutMethod.getReturnType());
        } else {
            if (parameters.length != 2 || !parameters[0].getType().equals(owner) && !MemorySegment.class.isAssignableFrom(parameters[0].getType()) || !parameters[1].getType().isPrimitive()) {
                throw new IllegalArgumentException("setter shortcut method should have two parameter and type should be `owner` or MemorySegment");
            }
            if (!shortcutMethod.getReturnType().equals(Void.TYPE)) {
                throw new IllegalArgumentException("setter shortcut method should return void");
            }
            targetFieldLayout = NativeLookup.primitiveMapToMemoryLayout(parameters[1].getType());
        }
        MemoryLayout memoryLayout = this.extract(owner);
        String[] pathNodes = option.value();
        if (pathNodes.length == 0) {
            throw new IllegalArgumentException("path length cant equal zero");
        }
        for (String node : pathNodes) {
            MemoryLayout fieldLayout = memoryLayout.select(MemoryLayout.PathElement.groupElement(node));
            if (fieldLayout instanceof AddressLayout) {
                AddressLayout addressLayout = (AddressLayout)fieldLayout;
                memoryLayout = addressLayout.targetLayout().orElseThrow(() -> new StructException(node + " as address layout should have target layout"));
                continue;
            }
            memoryLayout = fieldLayout;
        }
        if (memoryLayout.byteSize() != targetFieldLayout.byteSize()) {
            throw new IllegalArgumentException("shortcut type size not match");
        }
        return new ShortCutInfo(pathNodes, accessMode, shortcutMethod);
    }

    MethodHandle generateShortcutTrustedMH(Method method) {
        MemoryLayout ownerLayout;
        ShortcutOption shortcutOption = method.getAnnotation(ShortcutOption.class);
        VarHandle.AccessMode accessMode = shortcutOption.mode();
        Class ownered = shortcutOption.owner();
        MemoryLayout memoryLayout = ownerLayout = this.extract(ownered);
        String[] pathNodes = shortcutOption.value();
        ArrayList<MemoryLayout.PathElement> pathElements = new ArrayList<MemoryLayout.PathElement>(pathNodes.length);
        for (String node : pathNodes) {
            memoryLayout = memoryLayout.select(MemoryLayout.PathElement.groupElement(node));
            pathElements.add(MemoryLayout.PathElement.groupElement(node));
            if (!(memoryLayout instanceof AddressLayout)) continue;
            AddressLayout addressLayout = (AddressLayout)memoryLayout;
            memoryLayout = addressLayout.targetLayout().get();
            pathElements.add(MemoryLayout.PathElement.dereferenceElement());
        }
        MemoryLayout.PathElement[] path = pathElements.toArray(new MemoryLayout.PathElement[pathElements.size()]);
        MethodHandle mh = MethodHandles.insertCoordinates(ownerLayout.varHandle(path), 1, 0L).toMethodHandle(accessMode);
        return MethodHandles.filterArguments(mh, 0, NativeGeneratorHelper.TRANSFORM_OBJECT_TO_STRUCT_MH.asType(NativeGeneratorHelper.TRANSFORM_OBJECT_TO_STRUCT_MH.type().changeParameterType(0, method.getParameters()[0].getType())));
    }

    <T> String generatorShortcutProxyName(Class<T> shortcutInterface) {
        return shortcutInterface.getName() + "_shortcut_proxy";
    }

    public void useLmf(boolean use_lmf) {
        this.use_lmf = use_lmf;
    }

    private boolean needSkip(Field field) {
        return field.isSynthetic() || Modifier.isStatic(field.getModifiers()) || field.getAnnotation(Skip.class) != null;
    }

    public VarHandle findFieldVarHandle(Field field) {
        Class<?> declaringClass = field.getDeclaringClass();
        MemoryLayout layout = this.layoutCaches.get(declaringClass);
        if (layout == null) {
            throw new StructException("you should enhance " + String.valueOf(declaringClass) + " first");
        }
        Class<?> type = field.getType();
        if (type.isPrimitive() || field.getAnnotation(Pointer.class) != null || Optional.ofNullable(field.getAnnotation(NativeArrayMark.class)).map(NativeArrayMark::asPointer).orElse(false).booleanValue()) {
            return MethodHandles.insertCoordinates(layout.varHandle(MemoryLayout.PathElement.groupElement(field.getName())), 1, 0);
        }
        throw new StructException("only support primitive type or pointer type");
    }

    static String generateProxyClassName(Class targetClass) {
        return targetClass.getName() + "_native_struct_proxy";
    }

    static String generateVarHandleName(Field field) {
        return field.getName() + "_native_struct_vh";
    }

    private Consumer<CodeBuilder> implementStructMarkInterface(ClassBuilder cb, ClassDesc thisClass) {
        cb.withField(GENERATOR_FIELD, ClassFileHelper.toDesc(StructProxyGenerator.class), AccessFlags.ofField((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC, AccessFlag.STATIC, AccessFlag.FINAL}).flagsMask());
        cb.withField(LAYOUT_FIELD, ClassFileHelper.toDesc(MemoryLayout.class), AccessFlags.ofField((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC, AccessFlag.STATIC, AccessFlag.FINAL}).flagsMask());
        cb.withField(MEMORY_FIELD, ClassFileHelper.toDesc(MemorySegment.class), AccessFlags.ofField((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC}).flagsMask());
        cb.withInterfaceSymbols(new ClassDesc[]{ClassFileHelper.toDesc(NativeStructEnhanceMark.class)});
        cb.withMethodBody("fetchStructProxyGenerator", ClassFileHelper.toMethodDescriptor(NativeGeneratorHelper.FETCH_STRUCT_PROXY_GENERATOR), AccessFlags.ofMethod((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC}).flagsMask(), it -> {
            it.getstatic(thisClass, GENERATOR_FIELD, ClassFileHelper.toDesc(StructProxyGenerator.class));
            it.areturn();
        });
        cb.withMethodBody("realMemory", ClassFileHelper.toMethodDescriptor(NativeGeneratorHelper.REAL_MEMORY), AccessFlags.ofMethod((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC}).flagsMask(), it -> {
            it.aload(0);
            it.getfield(thisClass, MEMORY_FIELD, ClassFileHelper.toDesc(MemorySegment.class));
            it.areturn();
        });
        cb.withMethodBody("rebind", ClassFileHelper.toMethodDescriptor(NativeGeneratorHelper.REBIND_MEMORY), AccessFlags.ofMethod((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC}).flagsMask(), it -> {
            it.aload(1);
            it.aload(0);
            it.getfield(thisClass, MEMORY_FIELD, ClassFileHelper.toDesc(MemorySegment.class));
            ClassFileHelper.invoke(it, NativeGeneratorHelper.REBIND_ASSERT_METHOD);
            it.aload(0);
            it.aload(1);
            it.putfield(thisClass, MEMORY_FIELD, ClassFileHelper.toDesc(MemorySegment.class));
            it.return_();
        });
        cb.withMethodBody("layout", ClassFileHelper.toMethodDescriptor(NativeGeneratorHelper.REAL_MEMORY), AccessFlags.ofMethod((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC}).flagsMask(), it -> {
            it.getstatic(thisClass, LAYOUT_FIELD, ClassFileHelper.toDesc(MemoryLayout.class));
            it.areturn();
        });
        return it -> {
            ClassFileHelper.invoke(it, NativeGeneratorHelper.FETCH_CURRENT_STRUCT_LAYOUT_GENERATOR);
            it.putstatic(thisClass, LAYOUT_FIELD, ClassFileHelper.toDesc(MemoryLayout.class));
            ClassFileHelper.invoke(it, NativeGeneratorHelper.FETCH_CURRENT_STRUCT_GENERATOR_GENERATOR);
            it.putstatic(thisClass, GENERATOR_FIELD, ClassFileHelper.toDesc(StructProxyGenerator.class));
        };
    }

    private void generatorCtor(ClassBuilder cb, ClassDesc thisClass, Class originClass) {
        cb.withSuperclass(ClassFileHelper.toDesc(originClass));
        cb.withMethodBody("<init>", MethodType.methodType(Void.TYPE, MemorySegment.class).describeConstable().get(), AccessFlags.ofMethod((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC}).flagsMask(), it -> {
            it.aload(0);
            it.invokespecial(ClassFileHelper.toDesc(originClass), "<init>", ConstantDescs.MTD_void);
            it.aload(0);
            it.aload(1);
            it.putfield(thisClass, MEMORY_FIELD, ClassFileHelper.toDesc(MemorySegment.class));
            it.return_();
        });
    }

    private Consumer<CodeBuilder> initVarHandleBlock(ClassBuilder cb, ClassDesc thisClass, Field field) {
        String varHandleFieldName = StructProxyGenerator.generateVarHandleName(field);
        cb.withField(varHandleFieldName, ClassFileHelper.toDesc(VarHandle.class), AccessFlags.ofField((AccessFlag[])new AccessFlag[]{AccessFlag.FINAL, AccessFlag.STATIC, AccessFlag.PUBLIC}).flagsMask());
        return it -> {
            it.getstatic(thisClass, LAYOUT_FIELD, ClassFileHelper.toDesc(MemoryLayout.class));
            it.ldc((ConstantDesc)((Object)field.getName()));
            it.invokestatic(ClassFileHelper.toDesc(StructProxyGenerator.class), "generateVarHandle", ClassFileHelper.toMethodDescriptor(GENERATOR_VARHANDLE));
            it.putstatic(thisClass, varHandleFieldName, ClassFileHelper.toDesc(VarHandle.class));
        };
    }

    private Consumer<CodeBuilder> generatePrimitiveFieldVarHandle(ClassBuilder cb, ClassDesc thisClass, Field field, MemoryLayout __) {
        String varHandleFieldName = field.getName() + "_native_struct_vh";
        cb.withMethodBody("get" + StructProxyGenerator.upperFirstChar(field.getName()), MethodType.methodType(field.getType()).describeConstable().get(), AccessFlags.ofMethod((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC}).flagsMask(), it -> {
            it.getstatic(thisClass, varHandleFieldName, ClassFileHelper.toDesc(VarHandle.class));
            it.aload(0);
            ClassFileHelper.invoke(it, REALMEMORY_METHOD, true);
            MethodTypeDesc methodTypeDesc = MethodType.methodType(field.getType(), MemorySegment.class).describeConstable().get();
            it.invokevirtual(ClassFileHelper.toDesc(VarHandle.class), "get", methodTypeDesc);
            ClassFileHelper.returnValue(it, field.getType());
        });
        cb.withMethodBody("set" + StructProxyGenerator.upperFirstChar(field.getName()), MethodType.methodType(Void.TYPE, field.getType()).describeConstable().get(), AccessFlags.ofMethod((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC}).flagsMask(), it -> {
            it.getstatic(thisClass, varHandleFieldName, ClassFileHelper.toDesc(VarHandle.class));
            it.aload(0);
            ClassFileHelper.invoke(it, REALMEMORY_METHOD, true);
            TypeKind typeKind = TypeKind.from(field.getType());
            it.loadLocal(typeKind, it.parameterSlot(0));
            MethodTypeDesc methodTypeDesc = MethodType.methodType(Void.TYPE, MemorySegment.class, field.getType()).describeConstable().get();
            it.invokevirtual(ConstantDescs.CD_VarHandle, "set", methodTypeDesc);
            it.return_();
        });
        return this.initVarHandleBlock(cb, thisClass, field);
    }

    private Consumer<CodeBuilder> generateNativeArray(ClassBuilder cb, ClassDesc thisClass, Field field, MemoryLayout structLayout) {
        NativeArrayMark arrayMark = field.getAnnotation(NativeArrayMark.class);
        if (arrayMark == null) {
            throw new IllegalArgumentException(String.valueOf(field) + " must be marked as NativeArrayMark");
        }
        long offset = structLayout.byteOffset(MemoryLayout.PathElement.groupElement(field.getName()));
        long newSize = this.extract(arrayMark.size()).byteSize() * (long)arrayMark.length();
        boolean asPointer = field.getAnnotation(Pointer.class) != null || arrayMark.asPointer();
        cb.withMethodBody("get" + StructProxyGenerator.upperFirstChar(field.getName()), MethodType.methodType(NativeArray.class).describeConstable().get(), AccessFlags.ofMethod((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC}).flagsMask(), it -> {
            it.aload(0);
            ClassFileHelper.invoke(it, REALMEMORY_METHOD, true);
            it.astore(1);
            it.aload(1);
            if (asPointer) {
                it.getstatic(ClassFileHelper.toDesc(ValueLayout.class), "ADDRESS", ClassFileHelper.toDesc(AddressLayout.class));
                it.ldc((ConstantDesc)Long.valueOf(offset));
                ClassFileHelper.invoke(it, NativeGeneratorHelper.GET_ADDRESS_FROM_MEMORY_SEGMENT, true);
                it.ldc((ConstantDesc)Long.valueOf(newSize));
                ClassFileHelper.invoke(it, NativeGeneratorHelper.REINTERPRET, true);
            } else {
                it.ldc((ConstantDesc)Long.valueOf(offset));
                it.ldc((ConstantDesc)Long.valueOf(newSize));
                ClassFileHelper.invoke(it, NativeGeneratorHelper.AS_SLICE, true);
            }
            it.astore(1);
            it.new_(ClassFileHelper.toDesc(NativeArray.class));
            it.dup();
            it.getstatic(thisClass, GENERATOR_FIELD, ClassFileHelper.toDesc(StructProxyGenerator.class));
            it.aload(1);
            it.ldc((ConstantDesc)ClassFileHelper.toDesc(arrayMark.size()));
            it.invokespecial(ClassFileHelper.toDesc(NativeArray.class), "<init>", MethodType.methodType(Void.TYPE, StructProxyGenerator.class, MemorySegment.class, Class.class).describeConstable().get());
            it.areturn();
        });
        cb.withMethodBody("set" + StructProxyGenerator.upperFirstChar(field.getName()), MethodType.methodType(Void.TYPE, NativeArray.class).describeConstable().get(), AccessFlags.ofMethod((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC}).flagsMask(), it -> {
            if (asPointer) {
                this.generateSetPtr((CodeBuilder)it, offset);
            } else {
                this.generateSetSubElement((CodeBuilder)it, offset, newSize);
            }
            it.return_();
        });
        cb.withMethodBody("set" + StructProxyGenerator.upperFirstChar(field.getName()), MethodType.methodType(Void.TYPE, MemorySegment.class).describeConstable().get(), AccessFlags.ofMethod((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC}).flagsMask(), it -> {
            if (asPointer) {
                this.generateSetPtr((CodeBuilder)it, offset);
            } else {
                this.generateSetSubElement((CodeBuilder)it, offset, newSize);
            }
            it.return_();
        });
        return it -> {};
    }

    private void generateSetPtr(CodeBuilder it, long offset) {
        it.aload(0);
        it.ldc((ConstantDesc)Long.valueOf(offset));
        it.aload(1);
        ClassFileHelper.invoke(it, NativeGeneratorHelper.SET_PTR);
    }

    private void generateSetSubElement(CodeBuilder it, long offset, long newSize) {
        it.aload(0);
        it.ldc((ConstantDesc)Long.valueOf(offset));
        it.ldc((ConstantDesc)Long.valueOf(newSize));
        it.aload(1);
        ClassFileHelper.invoke(it, NativeGeneratorHelper.OVER_WRITE_SUB_ELEMENT);
    }

    private Consumer<CodeBuilder> generateMemorySegmentField(ClassBuilder cb, ClassDesc thisClass, Field field, MemoryLayout structLayout) {
        long offset = structLayout.byteOffset(MemoryLayout.PathElement.groupElement(field.getName()));
        NativeArrayMark arrayMark = field.getAnnotation(NativeArrayMark.class);
        boolean pointerMarked = field.getAnnotation(Pointer.class) != null;
        boolean pointer = arrayMark != null && arrayMark.asPointer();
        cb.withMethodBody("get" + StructProxyGenerator.upperFirstChar(field.getName()), MethodType.methodType(MemorySegment.class).describeConstable().get(), AccessFlags.ofMethod((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC}).flagsMask(), it -> {
            it.aload(0);
            ClassFileHelper.invoke(it, REALMEMORY_METHOD, true);
            it.astore(1);
            it.aload(1);
            if (pointerMarked) {
                it.getstatic(ClassFileHelper.toDesc(ValueLayout.class), "ADDRESS", ClassFileHelper.toDesc(AddressLayout.class));
                it.ldc((ConstantDesc)Long.valueOf(offset));
                ClassFileHelper.invoke(it, NativeGeneratorHelper.GET_ADDRESS_FROM_MEMORY_SEGMENT, true);
                it.areturn();
                return;
            }
            MemoryLayout realSize = this.extract(arrayMark.size());
            if (pointer) {
                it.getstatic(ClassFileHelper.toDesc(ValueLayout.class), "ADDRESS", ClassFileHelper.toDesc(AddressLayout.class));
                it.ldc((ConstantDesc)Long.valueOf(offset));
                ClassFileHelper.invoke(it, NativeGeneratorHelper.GET_ADDRESS_FROM_MEMORY_SEGMENT, true);
                it.ldc((ConstantDesc)Long.valueOf(realSize.byteSize() * (long)arrayMark.length()));
                ClassFileHelper.invoke(it, NativeGeneratorHelper.REINTERPRET, true);
                it.areturn();
            } else {
                it.ldc((ConstantDesc)Long.valueOf(offset));
                it.ldc((ConstantDesc)Long.valueOf(realSize.byteSize() * (long)arrayMark.length()));
                ClassFileHelper.invoke(it, NativeGeneratorHelper.AS_SLICE, true);
                it.areturn();
            }
        });
        cb.withMethodBody("set" + StructProxyGenerator.upperFirstChar(field.getName()), MethodType.methodType(Void.TYPE, MemorySegment.class).describeConstable().get(), AccessFlags.ofMethod((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC}).flagsMask(), it -> {
            if (pointer || pointerMarked) {
                this.generateSetPtr((CodeBuilder)it, offset);
            } else {
                MemoryLayout realSize = this.extract(arrayMark.size());
                this.generateSetSubElement((CodeBuilder)it, offset, realSize.byteSize() * (long)arrayMark.length());
            }
            it.return_();
        });
        return it -> {};
    }

    private Consumer<CodeBuilder> generatorSubStructField(ClassBuilder cb, ClassDesc thisClass, Field field, MemoryLayout structLayout) {
        long subStructLayoutSize = structLayout.select(MemoryLayout.PathElement.groupElement(field.getName())).byteSize();
        long offset = structLayout.byteOffset(MemoryLayout.PathElement.groupElement(field.getName()));
        boolean isPointer = field.getAnnotation(Pointer.class) != null;
        cb.withMethodBody("get" + StructProxyGenerator.upperFirstChar(field.getName()), MethodType.methodType(field.getType()).describeConstable().get(), AccessFlags.ofMethod((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC}).flagsMask(), it -> {
            it.aload(0);
            ClassFileHelper.invoke(it, REALMEMORY_METHOD, true);
            it.astore(1);
            it.aload(1);
            if (isPointer) {
                it.getstatic(ClassFileHelper.toDesc(ValueLayout.class), "ADDRESS", ClassFileHelper.toDesc(AddressLayout.class));
                it.ldc((ConstantDesc)Long.valueOf(offset));
                ClassFileHelper.invoke(it, NativeGeneratorHelper.GET_ADDRESS_FROM_MEMORY_SEGMENT, true);
                it.ldc((ConstantDesc)Long.valueOf(subStructLayoutSize));
                ClassFileHelper.invoke(it, NativeGeneratorHelper.REINTERPRET, true);
                it.astore(2);
                it.getstatic(thisClass, GENERATOR_FIELD, ClassFileHelper.toDesc(StructProxyGenerator.class));
                it.ldc((ConstantDesc)ClassFileHelper.toDesc(field.getType()));
                it.aload(2);
            } else {
                it.ldc((ConstantDesc)Long.valueOf(offset));
                it.ldc((ConstantDesc)Long.valueOf(subStructLayoutSize));
                ClassFileHelper.invoke(it, NativeGeneratorHelper.AS_SLICE, true);
                it.astore(1);
                it.getstatic(thisClass, GENERATOR_FIELD, ClassFileHelper.toDesc(StructProxyGenerator.class));
                it.ldc((ConstantDesc)ClassFileHelper.toDesc(field.getType()));
                it.aload(1);
            }
            ClassFileHelper.invoke(it, NativeGeneratorHelper.ENHANCE);
            it.checkcast(ClassFileHelper.toDesc(field.getType()));
            it.areturn();
        });
        cb.withMethodBody("set" + StructProxyGenerator.upperFirstChar(field.getName()), MethodType.methodType(Void.TYPE, field.getType()).describeConstable().get(), AccessFlags.ofMethod((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC}).flagsMask(), it -> {
            if (isPointer) {
                this.generateSetPtr((CodeBuilder)it, offset);
            } else {
                this.generateSetSubElement((CodeBuilder)it, offset, subStructLayoutSize);
            }
            it.return_();
        });
        cb.withMethodBody("set" + StructProxyGenerator.upperFirstChar(field.getName()), MethodType.methodType(Void.TYPE, MemorySegment.class).describeConstable().get(), AccessFlags.ofMethod((AccessFlag[])new AccessFlag[]{AccessFlag.PUBLIC}).flagsMask(), it -> {
            if (isPointer) {
                this.generateSetPtr((CodeBuilder)it, offset);
            } else {
                this.generateSetSubElement((CodeBuilder)it, offset, subStructLayoutSize);
            }
            it.return_();
        });
        return it -> {};
    }

    static {
        try {
            ENHANCE_MH = MethodHandles.lookup().findVirtual(StructProxyGenerator.class, "enhance", MethodType.methodType(Object.class, Class.class, MemorySegment.class));
            REALMEMORY_METHOD = NativeStructEnhanceMark.class.getMethod("realMemory", new Class[0]);
            GENERATOR_VARHANDLE = StructProxyGenerator.class.getMethod("generateVarHandle", MemoryLayout.class, String.class);
            SHORTCUT_INDY_BOOTSTRAP_METHOD = InvokeDynamicFactory.class.getMethod("shortcutIndyFactory", MethodHandles.Lookup.class, String.class, MethodType.class, Object[].class);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        getterModes = Set.of(VarHandle.AccessMode.GET, VarHandle.AccessMode.GET_VOLATILE, VarHandle.AccessMode.GET_OPAQUE, VarHandle.AccessMode.GET_ACQUIRE);
        setterModes = Set.of(VarHandle.AccessMode.SET, VarHandle.AccessMode.SET_VOLATILE, VarHandle.AccessMode.SET_OPAQUE, VarHandle.AccessMode.SET_RELEASE);
    }

    private record ShortCutInfo(String[] path, VarHandle.AccessMode accessMode, Method method) {
    }
}

