/*
 * Decompiled with CFR 0.152.
 */
package io.github.dreamlike.unsafe.vthread;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.BooleanSupplier;
import top.dreamlike.unsafe.core.MasterKey;

public class Poller {
    public static final short POLLIN;
    public static final short POLLOUT;
    public static final short POLLERR;
    public static final short POLLHUP;
    public static final short POLLNVAL;
    public static final short POLLCONN;
    private static final MethodHandle POLLER_POLL_MH;

    public static void poll(int fdVal, int event, long nanos, BooleanSupplier isOpenSupplier) {
        try {
            POLLER_POLL_MH.invokeExact(fdVal, event, nanos, isOpenSupplier);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            MethodHandles.Lookup lookup = MasterKey.INSTANCE.getTrustedLookup();
            Class<?> sunNetClazz = Class.forName("sun.nio.ch.Net");
            POLLIN = lookup.findStaticVarHandle(sunNetClazz, "POLLIN", Short.TYPE).get();
            POLLOUT = lookup.findStaticVarHandle(sunNetClazz, "POLLOUT", Short.TYPE).get();
            POLLERR = lookup.findStaticVarHandle(sunNetClazz, "POLLERR", Short.TYPE).get();
            POLLHUP = lookup.findStaticVarHandle(sunNetClazz, "POLLHUP", Short.TYPE).get();
            POLLNVAL = lookup.findStaticVarHandle(sunNetClazz, "POLLNVAL", Short.TYPE).get();
            POLLCONN = lookup.findStaticVarHandle(sunNetClazz, "POLLCONN", Short.TYPE).get();
            Class<?> sunNetPoller = Class.forName("sun.nio.ch.Poller");
            POLLER_POLL_MH = lookup.findStatic(sunNetPoller, "poll", MethodType.methodType(Void.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, BooleanSupplier.class));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

